/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.palette;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspTagTokenContext;

public final class JSPPaletteUtilities {
    public static int wrapTags(JspSyntaxSupport sup, int start, int end, BaseDocument doc) {
        try {
            TokenItem token = sup.getTokenChain(start, start + 1);
            if (token == null) {
                return end;
            }
            while (token.getOffset() < end && (token = token.getNext()) != null) {
                if ((!token.getImage().startsWith("<") || token.getTokenID() != JspTagTokenContext.SYMBOL) && token.getTokenID() != HTMLTokenContext.TAG_OPEN_SYMBOL) continue;
                int offset = token.getOffset();
                doc.insertString(offset, "\n", null);
                ++end;
                token = sup.getTokenChain(offset + 1, offset + 2);
            }
        }
        catch (IllegalStateException ise) {
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        return end;
    }

    public static void insert(String s, JTextComponent target) throws BadLocationException {
        JSPPaletteUtilities.insert(s, target, true);
    }

    public static void insert(String s, JTextComponent target, boolean reformat) throws BadLocationException {
        Document doc = target.getDocument();
        if (doc == null) {
            return;
        }
        if (s == null) {
            s = "";
        }
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).atomicLock();
        }
        int start = JSPPaletteUtilities.insert(s, target, doc);
        if (reformat && start >= 0 && doc instanceof BaseDocument) {
            int end = start + s.length();
            Formatter f = ((BaseDocument)doc).getFormatter();
            f.reformat((BaseDocument)doc, start, end);
        }
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).atomicUnlock();
        }
    }

    private static int insert(String s, JTextComponent target, Document doc) throws BadLocationException {
        int start = -1;
        try {
            Caret caret = target.getCaret();
            int p0 = Math.min(caret.getDot(), caret.getMark());
            int p1 = Math.max(caret.getDot(), caret.getMark());
            doc.remove(p0, p1 - p0);
            start = caret.getDot();
            doc.insertString(start, s, null);
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        return start;
    }
}

