/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.xerces.util.XMLChar;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.wizards.BrowseFolders;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.TargetChooserPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class TargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final String TAG_FILE_FOLDER = "WEB-INF/tags";
    private static final String TAG_FILE_IN_JAVALIB_FOLDER = "META-INF/tags";
    private static final String TLD_FOLDER = "WEB-INF/tlds";
    private static final String TLD_IN_JAVALIB_FOLDER = "META-INF";
    private TargetChooserPanel wizardPanel;
    private Project project;
    private String expectedExtension;
    private final List listeners = new ArrayList();
    private SourceGroup[] folders;
    private FileType fileType;
    private WebModule wm;
    private ButtonGroup buttonGroup1;
    private JTextArea descriptionArea;
    private JScrollPane jScrollPane1;
    private JRadioButton jspSyntaxButton;
    private JRadioButton xmlSyntaxButton;
    private JCheckBox segmentBox;
    private JCheckBox tldCheckBox;
    private JButton browseButton1;
    private JLabel descriptionLabel;
    private JLabel optionLabel;
    private JPanel optionsPanel;
    private Set tagValues;
    private String tagName;
    private JTextField uriTextField;
    private JTextField prefixTextField;
    private JTextField tldTextField;
    private JTextField tagNameTextField;
    private JLabel uriLabel;
    private JLabel prefixLabel;
    private boolean uriWasTyped;
    private boolean prefixWasTyped;
    boolean tagFileValid = true;
    private FileObject tldFo;
    private JButton browseButton;
    private JPanel customPanel;
    private JTextField documentNameTextField;
    private JTextField fileTextField;
    private JPanel fillerPanel;
    private JLabel folderLabel;
    private JTextField folderTextField;
    private JComboBox locationCB;
    private JLabel locationLabel;
    private JLabel nameLabel;
    private JLabel pathLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JSeparator targetSeparator;

    public TargetChooserPanelGUI(final TargetChooserPanel wizardPanel, Project project, SourceGroup[] folders, FileType fileType) {
        this.wizardPanel = wizardPanel;
        this.project = project;
        this.folders = folders;
        this.fileType = fileType;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_TargetPanel", (Object)fileType.toString()));
        if (FileType.JSP.equals(fileType) || FileType.TAG.equals(fileType)) {
            this.buttonGroup1 = new ButtonGroup();
            this.jScrollPane1 = new JScrollPane();
            this.descriptionArea = new JTextArea();
            this.segmentBox = new JCheckBox();
            this.descriptionLabel = new JLabel();
            this.optionLabel = new JLabel();
            this.jspSyntaxButton = new JRadioButton();
            this.xmlSyntaxButton = new JRadioButton();
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.weightx = 2.0;
            gridBagConstraints.fill = 1;
            this.customPanel.add((Component)this.optionsPanel, gridBagConstraints);
            this.segmentBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    TargetChooserPanelGUI.this.checkBoxChanged(evt);
                }
            });
            this.optionLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Options"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.anchor = 18;
            this.optionsPanel.add((Component)this.optionLabel, gridBagConstraints);
            this.jspSyntaxButton.setSelected(true);
            if (FileType.JSP.equals(fileType)) {
                this.jspSyntaxButton.setMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_JspStandard_mnem").charAt(0));
            } else {
                this.jspSyntaxButton.setMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_TagStandard_mnem").charAt(0));
            }
            this.buttonGroup1.add(this.jspSyntaxButton);
            this.jspSyntaxButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    TargetChooserPanelGUI.this.checkBoxChanged(evt);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            gridBagConstraints.anchor = 17;
            this.optionsPanel.add((Component)this.jspSyntaxButton, gridBagConstraints);
            this.xmlSyntaxButton.setMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_JspXml_mnem").charAt(0));
            this.buttonGroup1.add(this.xmlSyntaxButton);
            this.xmlSyntaxButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    TargetChooserPanelGUI.this.checkBoxChanged(evt);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            gridBagConstraints.anchor = 17;
            this.optionsPanel.add((Component)this.xmlSyntaxButton, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            this.segmentBox.setMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_JspSegment_mnem").charAt(0));
            this.optionsPanel.add((Component)this.segmentBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 2.0;
            this.optionsPanel.add((Component)new JPanel(), gridBagConstraints);
            this.descriptionLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_description"));
            this.descriptionLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Description_mnem").charAt(0));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 2, 0);
            this.descriptionLabel.setLabelFor(this.descriptionArea);
            this.customPanel.add((Component)this.descriptionLabel, gridBagConstraints);
            this.descriptionArea.setEditable(false);
            this.descriptionArea.setLineWrap(true);
            this.descriptionArea.setRows(2);
            this.descriptionArea.setWrapStyleWord(true);
            this.descriptionArea.setOpaque(false);
            this.descriptionArea.getAccessibleContext().setAccessibleDescription(this.descriptionLabel.getText());
            this.jScrollPane1.setViewportView(this.descriptionArea);
            this.jScrollPane1.setVerticalScrollBarPolicy(21);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 2.0;
            this.customPanel.add((Component)this.jScrollPane1, gridBagConstraints);
            if (FileType.TAG.equals(fileType)) {
                this.tldCheckBox = new JCheckBox();
                this.tldCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_AddToTLD_mnem").charAt(0));
                this.tldCheckBox.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"OPT_addTagFileToTLD"));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.gridwidth = 4;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(6, 0, 2, 0);
                this.customPanel.add((Component)this.tldCheckBox, gridBagConstraints);
                this.tldCheckBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("OPT_addToTLD"));
                JLabel tldFileLabel = new JLabel();
                tldFileLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_TLDName_mnem").charAt(0));
                tldFileLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_tldFile"));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                this.customPanel.add((Component)tldFileLabel, gridBagConstraints);
                this.tldTextField = new JTextField();
                this.tldTextField.setEditable(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.insets = new Insets(0, 12, 0, 0);
                this.customPanel.add((Component)this.tldTextField, gridBagConstraints);
                this.tldTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TLDFile"));
                tldFileLabel.setLabelFor(this.tldTextField);
                this.browseButton1 = new JButton();
                this.browseButton1.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_Browse1_Mnemonic").charAt(0));
                this.browseButton1.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Browse"));
                this.browseButton1.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        TargetChooserPanelGUI.this.browseButton1ActionPerformed(evt);
                    }
                });
                this.browseButton1.setEnabled(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 5;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 6, 0, 0);
                this.customPanel.add((Component)this.browseButton1, gridBagConstraints);
                this.browseButton1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_Browse"));
                this.tldCheckBox.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent evt) {
                        String name;
                        TargetChooserPanelGUI.this.tagNameTextField.setEditable(TargetChooserPanelGUI.this.tldCheckBox.isSelected());
                        TargetChooserPanelGUI.this.browseButton1.setEnabled(TargetChooserPanelGUI.this.tldCheckBox.isSelected());
                        if (TargetChooserPanelGUI.this.tldCheckBox.isSelected() && TargetChooserPanelGUI.this.tagName == null && (name = TargetChooserPanelGUI.this.documentNameTextField.getText().trim()).length() > 0) {
                            TargetChooserPanelGUI.this.tagNameTextField.setText(name);
                            TargetChooserPanelGUI.this.tagName = name;
                        }
                        wizardPanel.fireChange();
                    }
                });
                JLabel tagNameLabel = new JLabel();
                tagNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_TagName_mnem").charAt(0));
                tagNameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_tagName"));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 6;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(6, 0, 0, 0);
                this.customPanel.add((Component)tagNameLabel, gridBagConstraints);
                this.tagNameTextField = new JTextField();
                this.tagNameTextField.setEditable(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 6;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(6, 12, 0, 0);
                this.customPanel.add((Component)this.tagNameTextField, gridBagConstraints);
                this.tagNameTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TagName"));
                tagNameLabel.setLabelFor(this.tagNameTextField);
                this.tagNameTextField.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent evt) {
                        TargetChooserPanelGUI.this.tagName = TargetChooserPanelGUI.this.tagNameTextField.getText().trim();
                        wizardPanel.fireChange();
                    }
                });
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 6;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                this.customPanel.add((Component)new JPanel(), gridBagConstraints);
            }
        } else if (FileType.TAGLIBRARY.equals(fileType)) {
            this.uriTextField = new JTextField();
            this.uriTextField.setColumns(20);
            this.prefixTextField = new JTextField();
            this.prefixTextField.setColumns(5);
            this.uriLabel = new JLabel(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_URI"));
            this.uriLabel.setToolTipText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"TTT_URI"));
            this.uriLabel.setLabelFor(this.uriTextField);
            this.uriLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_URI_mnem").charAt(0));
            this.uriTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_URI"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(6, 0, 6, 0);
            gridBagConstraints.anchor = 17;
            this.customPanel.add((Component)this.uriLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 6, 6, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.customPanel.add((Component)this.uriTextField, gridBagConstraints);
            this.prefixLabel = new JLabel(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Prefix"));
            this.prefixLabel.setLabelFor(this.prefixTextField);
            this.prefixLabel.setToolTipText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"TTT_prefix"));
            this.prefixLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Prefix_mnem").charAt(0));
            this.prefixTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_Prefix"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            this.customPanel.add((Component)this.prefixLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            this.customPanel.add((Component)this.prefixTextField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.weightx = 2.0;
            this.customPanel.add((Component)new JPanel(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.customPanel.add((Component)new JPanel(), gridBagConstraints);
            this.uriTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    TargetChooserPanelGUI.this.uriWasTyped = true;
                    wizardPanel.fireChange();
                }
            });
            this.prefixTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    TargetChooserPanelGUI.this.prefixWasTyped = true;
                    wizardPanel.fireChange();
                }
            });
        }
        this.browseButton.addActionListener(this);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.setName(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"TITLE_name_location"));
        if (fileType.equals(FileType.JSP)) {
            this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_JspName"));
            this.jspSyntaxButton.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"OPT_JspSyntax"));
            this.jspSyntaxButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_JSP"));
            this.xmlSyntaxButton.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"OPT_XmlSyntax"));
            this.xmlSyntaxButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_JSP_XML"));
            this.segmentBox.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"OPT_JspSegment"));
            this.segmentBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_JSP_segment"));
            this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_JSP"));
        } else if (fileType.equals(FileType.TAG)) {
            this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_TagFileName"));
            this.jspSyntaxButton.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"OPT_TagFileJsp"));
            this.jspSyntaxButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_TagFile"));
            this.xmlSyntaxButton.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"OPT_TagFileXml"));
            this.xmlSyntaxButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_TagFileXml"));
            this.segmentBox.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"OPT_TagFileSegment"));
            this.segmentBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_TagFile_segment"));
            this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_TagFile"));
        } else if (fileType.equals(FileType.TAGLIBRARY)) {
            this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_TldName"));
        } else if (fileType.equals(FileType.HTML)) {
            this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_HtmlName"));
            this.locationCB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TargetChooserPanelGUI.this.changedUpdate(null);
                }
            });
        } else if (fileType.equals(FileType.XHTML)) {
            this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_XHtmlName"));
            this.locationCB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TargetChooserPanelGUI.this.changedUpdate(null);
                }
            });
        }
    }

    WebModule getWebModule() {
        return this.wm;
    }

    public void initValues(Project p, FileObject template, FileObject preselectedFolder) {
        this.projectTextField.setText(ProjectUtils.getInformation((Project)p).getDisplayName());
        if (this.folders != null && this.folders.length > 0) {
            this.locationCB.setModel(new DefaultComboBoxModel<Object>(this.getLocations(this.folders)));
            this.wm = WebModule.getWebModule((FileObject)this.folders[0].getRootFolder());
        } else {
            this.locationCB.setModel(new DefaultComboBoxModel<Object>(new Object[]{new LocationItem(p.getProjectDirectory())}));
        }
        String target = null;
        FileObject docBase = this.getLocationRoot();
        if (preselectedFolder != null && FileUtil.isParentOf((FileObject)docBase, (FileObject)preselectedFolder)) {
            target = FileUtil.getRelativePath((FileObject)docBase, (FileObject)preselectedFolder);
        }
        if (this.wm == null) {
            if (FileType.TAG.equals(this.fileType) && target != null && !target.startsWith(TAG_FILE_IN_JAVALIB_FOLDER)) {
                target = null;
            }
            if (FileType.TAGLIBRARY.equals(this.fileType) && target != null && !target.startsWith(TLD_IN_JAVALIB_FOLDER)) {
                target = null;
            }
        }
        if (FileType.TAG.equals(this.fileType)) {
            if (this.wm != null) {
                if (target == null || !target.startsWith(TAG_FILE_FOLDER)) {
                    this.folderTextField.setText("WEB-INF/tags/");
                } else {
                    this.folderTextField.setText(target == null ? "" : target);
                }
            } else if (target == null || !target.startsWith(TAG_FILE_IN_JAVALIB_FOLDER)) {
                this.folderTextField.setText("META-INF/tags/");
            } else {
                this.folderTextField.setText(target == null ? "" : target);
            }
        } else if (FileType.TAGLIBRARY.equals(this.fileType) && target == null) {
            if (this.wm == null) {
                this.folderTextField.setText("META-INF/");
            } else {
                this.folderTextField.setText("WEB-INF/tlds/");
            }
        } else {
            this.folderTextField.setText(target == null ? "" : target);
        }
        String ext = template == null ? "" : template.getExt();
        this.expectedExtension = ext.length() == 0 ? "" : "." + ext;
    }

    private Object[] getLocations(SourceGroup[] folders) {
        Object[] loc = new Object[folders.length];
        for (int i = 0; i < folders.length; ++i) {
            loc[i] = new LocationItem(folders[i]);
        }
        return loc;
    }

    private String getRelativeSourcesFolder() {
        FileObject sourcesBase;
        FileObject docBase;
        String sourceDir = "";
        if (this.wm != null && (sourceDir = FileUtil.getRelativePath((FileObject)(docBase = this.wm.getDocumentBase()), (FileObject)(sourcesBase = ((LocationItem)this.locationCB.getModel().getSelectedItem()).getFileObject()))) == null) {
            sourceDir = "";
        }
        return sourceDir.length() == 0 ? "" : sourceDir + "/";
    }

    public String getRelativeTargetFolder() {
        return this.getRelativeSourcesFolder() + this.getNormalizedFolder();
    }

    public String getNormalizedFolder() {
        int i;
        String norm = this.folderTextField.getText().trim();
        if (norm.length() == 0) {
            return "";
        }
        norm = norm.replace('\\', '/');
        for (i = 0; i < norm.length() && norm.charAt(i) == '/'; ++i) {
        }
        if (i == norm.length()) {
            return "";
        }
        norm = norm.substring(i);
        StringTokenizer tokens = new StringTokenizer(norm, "/");
        ArrayList list = new ArrayList();
        StringBuffer buf = new StringBuffer(tokens.nextToken());
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.length() <= 0) continue;
            buf.append("/" + token);
        }
        return buf.toString();
    }

    public String getTargetFolder() {
        return this.getTargetFile().getPath();
    }

    public File getTargetFile() {
        String text = this.getRelativeTargetFolder();
        if (text.length() == 0) {
            if (this.wm == null) {
                return FileUtil.toFile((FileObject)this.getLocationRoot());
            }
            return FileUtil.toFile((FileObject)this.wm.getDocumentBase());
        }
        if (this.wm == null) {
            return new File(FileUtil.toFile((FileObject)this.getLocationRoot()), text);
        }
        return new File(FileUtil.toFile((FileObject)this.wm.getDocumentBase()), text);
    }

    public String getTargetName() {
        String text = this.documentNameTextField.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationCB = new JComboBox();
        this.folderLabel = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.pathLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.targetSeparator = new JSeparator();
        this.customPanel = new JPanel();
        this.fillerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_FileName_mnem").charAt(0));
        this.nameLabel.setLabelFor(this.documentNameTextField);
        this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_JspName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.documentNameTextField, gridBagConstraints);
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_FileName"));
        this.projectLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Project_mnem").charAt(0));
        this.projectLabel.setLabelFor(this.projectTextField);
        this.projectLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_Project"));
        this.locationLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Location_mnem").charAt(0));
        this.locationLabel.setLabelFor(this.locationCB);
        this.locationLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.locationCB, gridBagConstraints);
        this.locationCB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_Location"));
        this.folderLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Folder_mnem").charAt(0));
        this.folderLabel.setLabelFor(this.folderTextField);
        this.folderLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.folderLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.folderTextField, gridBagConstraints);
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_Folder"));
        this.browseButton.setMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Browse_Mnemonic").charAt(0));
        this.browseButton.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Browse"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"ACSD_Browse"));
        this.pathLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_CreatedFile_mnem").charAt(0));
        this.pathLabel.setLabelFor(this.fileTextField);
        this.pathLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.pathLabel, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.customPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.customPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillerPanel, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.browseButton == e.getSource()) {
            FileObject fo = null;
            if (this.folders != null) {
                fo = BrowseFolders.showDialog(this.folders, DataFolder.class, this.folderTextField.getText().replace(File.separatorChar, '/'));
            } else {
                Sources sources = ProjectUtils.getSources((Project)this.project);
                fo = BrowseFolders.showDialog(sources.getSourceGroups("generic"), DataFolder.class, this.folderTextField.getText().replace(File.separatorChar, '/'));
            }
            if (fo != null && fo.isFolder()) {
                FileObject root = ((LocationItem)this.locationCB.getSelectedItem()).getFileObject();
                this.folderTextField.setText(FileUtil.getRelativePath((FileObject)root, (FileObject)fo));
            }
        }
    }

    public void changedUpdate(DocumentEvent e) {
        File rootDirFile = FileUtil.toFile((FileObject)((LocationItem)this.locationCB.getSelectedItem()).getFileObject());
        if (rootDirFile != null) {
            String documentName = this.documentNameTextField.getText().trim();
            if (documentName.length() == 0) {
                this.fileTextField.setText("");
            } else {
                File newFile = new File(new File(rootDirFile, this.folderTextField.getText().replace('/', File.separatorChar)), documentName + this.expectedExtension + (this.isSegment() ? "f" : (this.isXml() ? "x" : "")));
                this.fileTextField.setText(newFile.getAbsolutePath());
            }
        } else {
            this.fileTextField.setText("");
        }
        if (FileType.TAGLIBRARY.equals(this.fileType)) {
            if (!this.uriWasTyped) {
                String norm = this.getNormalizedFolder();
                if (this.wm == null) {
                    String pack = this.getPackageNameInMetaInf();
                    this.uriTextField.setText((pack.length() > 0 ? pack + "." : "") + this.documentNameTextField.getText());
                } else {
                    this.uriTextField.setText((norm.length() == 0 ? "" : "/" + this.getNormalizedFolder()) + "/" + this.documentNameTextField.getText().trim());
                }
            }
            if (!this.prefixWasTyped) {
                this.prefixTextField.setText(this.documentNameTextField.getText().trim().toLowerCase());
            }
        }
        this.wizardPanel.fireChange();
    }

    private String getPackageNameInMetaInf() {
        String pack = this.getRelativeTargetFolder();
        if (pack.startsWith(TLD_IN_JAVALIB_FOLDER)) {
            if ((pack = pack.substring(8)).length() == 0) {
                return "";
            }
            if (pack.startsWith("/")) {
                pack = pack.substring(1);
            }
        }
        if (pack.length() == 0) {
            return "";
        }
        pack = pack.replace('/', '.');
        return pack;
    }

    private void checkBoxChanged(ItemEvent evt) {
        if (this.fileType.equals(FileType.JSP)) {
            if (this.isSegment()) {
                if (this.isXml()) {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_segment_XML"));
                } else {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_segment"));
                }
                String createdFile = this.fileTextField.getText();
                if (createdFile.endsWith("jspx")) {
                    this.fileTextField.setText(createdFile.substring(0, createdFile.length() - 1) + "f");
                } else if (createdFile.endsWith("jsp")) {
                    this.fileTextField.setText(createdFile + "f");
                }
            } else {
                String createdFile = this.fileTextField.getText();
                if (this.isXml()) {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_JSP_XML"));
                    if (createdFile.endsWith("jspf")) {
                        this.fileTextField.setText(createdFile.substring(0, createdFile.length() - 1) + "x");
                    } else if (createdFile.endsWith("jsp")) {
                        this.fileTextField.setText(createdFile + "x");
                    }
                } else {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_JSP"));
                    if (createdFile.endsWith("jspf") || createdFile.endsWith("jspx")) {
                        this.fileTextField.setText(createdFile.substring(0, createdFile.length() - 1));
                    }
                }
            }
        } else if (this.fileType.equals(FileType.TAG)) {
            if (this.isSegment()) {
                if (this.isXml()) {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_TagFileSegmentXml"));
                } else {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_TagFileSegment"));
                }
                String createdFile = this.fileTextField.getText();
                if (createdFile.endsWith("tagx")) {
                    this.fileTextField.setText(createdFile.substring(0, createdFile.length() - 1) + "f");
                } else if (createdFile.endsWith("tag")) {
                    this.fileTextField.setText(createdFile + "f");
                }
            } else {
                String createdFile = this.fileTextField.getText();
                if (this.isXml()) {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_TagFileXml"));
                    if (createdFile.endsWith("tagf")) {
                        this.fileTextField.setText(createdFile.substring(0, createdFile.length() - 1) + "x");
                    } else if (createdFile.endsWith("tag")) {
                        this.fileTextField.setText(createdFile + "x");
                    }
                } else {
                    this.descriptionArea.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"DESC_TagFile"));
                    if (createdFile.endsWith("tagf") || createdFile.endsWith("tagx")) {
                        this.fileTextField.setText(createdFile.substring(0, createdFile.length() - 1));
                    }
                }
            }
        }
        this.wizardPanel.fireChange();
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    boolean isXml() {
        if (this.xmlSyntaxButton == null) {
            return false;
        }
        return this.xmlSyntaxButton.isSelected();
    }

    boolean isSegment() {
        if (this.segmentBox == null) {
            return false;
        }
        return this.segmentBox.isSelected();
    }

    String getUri() {
        if (this.uriTextField == null) {
            return "";
        }
        return this.uriTextField.getText();
    }

    String getPrefix() {
        if (this.prefixTextField == null) {
            return "";
        }
        return this.prefixTextField.getText();
    }

    String getErrorMessage() {
        if (FileType.JSP.equals(this.fileType)) {
            if (this.isSegment() && !this.getNormalizedFolder().startsWith("WEB-INF/jspf")) {
                return NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"NOTE_segment");
            }
        } else if (FileType.TAG.equals(this.fileType)) {
            this.tagFileValid = true;
            if (this.wm != null) {
                if (!this.getNormalizedFolder().startsWith(TAG_FILE_FOLDER)) {
                    this.tagFileValid = false;
                    return NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"MSG_TagFile");
                }
            } else if (!this.getNormalizedFolder().startsWith(TAG_FILE_IN_JAVALIB_FOLDER)) {
                this.tagFileValid = false;
                return NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"MSG_TagFileInJavalib");
            }
        } else if (FileType.TAGLIBRARY.equals(this.fileType)) {
            if (this.wm == null) {
                if (!this.getNormalizedFolder().startsWith(TLD_IN_JAVALIB_FOLDER)) {
                    return NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"NOTE_TLDInJavalib");
                }
            } else if (!this.getNormalizedFolder().startsWith("WEB-INF")) {
                return NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"NOTE_TLDInWeb");
            }
            if (this.getUri().length() == 0) {
                return NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"MSG_missingUri");
            }
            if (this.getPrefix().length() == 0) {
                return NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"MSG_missingPrefix");
            }
        }
        return null;
    }

    boolean isPanelValid() {
        if (FileType.TAGLIBRARY.equals(this.fileType) && (this.getUri().length() == 0 || this.getPrefix().length() == 0)) {
            return false;
        }
        return !FileType.TAG.equals(this.fileType) || this.tagFileValid;
    }

    FileObject getLocationRoot() {
        return ((LocationItem)this.locationCB.getModel().getSelectedItem()).getFileObject();
    }

    private void browseButton1ActionPerformed(ActionEvent evt) {
        FileObject fo = null;
        if (this.folders != null) {
            fo = BrowseFolders.showDialog(this.folders, TLDDataObject.class, this.folderTextField.getText().replace(File.separatorChar, '/'));
        } else {
            Sources sources = ProjectUtils.getSources((Project)this.project);
            fo = BrowseFolders.showDialog(sources.getSourceGroups("generic"), DataFolder.class, this.folderTextField.getText().replace(File.separatorChar, '/'));
        }
        if (fo != null) {
            this.tldFo = fo;
            FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizardPanel.getTemplateWizard());
            WebModule wm = targetFolder == null ? null : WebModule.getWebModule((FileObject)targetFolder);
            this.tldTextField.setText(FileUtil.getRelativePath((FileObject)(wm == null ? this.project.getProjectDirectory() : wm.getDocumentBase()), (FileObject)fo));
            try {
                InputStream is = this.tldFo.getInputStream();
                this.tagValues = Util.getTagValues(is, new String[]{"tag", "tag-file"}, "name");
                is.close();
            }
            catch (IOException ex) {
            }
            catch (SAXException ex) {
                // empty catch block
            }
            this.wizardPanel.fireChange();
        }
    }

    boolean isTldCheckBoxSelected() {
        return this.tldCheckBox.isSelected();
    }

    String getTagName() {
        return this.tagName;
    }

    FileObject getTldFileObject() {
        return this.tldFo;
    }

    boolean isValidTagName(String name) {
        if (name == null) {
            return false;
        }
        return XMLChar.isValidNCName((String)name);
    }

    boolean tagNameExists(String name) {
        return this.tagValues != null && this.tagValues.contains(name);
    }

    public String getCreatedFilePath() {
        return this.fileTextField.getText();
    }

    public static class LocationItem {
        FileObject fo;
        SourceGroup group;

        public LocationItem(FileObject fo) {
            this.fo = fo;
        }

        public LocationItem(SourceGroup group) {
            this.fo = group.getRootFolder();
            this.group = group;
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public String toString() {
            return this.group == null ? this.fo.getName() : this.group.getDisplayName();
        }
    }
}

