/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class NoSelectedServerWarning
extends JPanel {
    public static final String OK_ENABLED = "ok_enabled";
    private JButton jButtonAddServer;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JList serverList;

    private NoSelectedServerWarning(Object[] moduleTypes, String j2eeSpec) {
        this.initComponents();
        this.serverList.setModel(new ServerListModel(moduleTypes, j2eeSpec));
        if (this.serverList.getModel().getSize() > 0) {
            this.jTextArea2.setVisible(false);
        }
        this.initServerList();
    }

    private void initServerList() {
        this.serverList.setSelectionMode(0);
        this.serverList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                boolean enabled = !NoSelectedServerWarning.this.serverList.isSelectionEmpty();
                NoSelectedServerWarning.this.firePropertyChange(NoSelectedServerWarning.OK_ENABLED, !enabled, enabled);
            }
        });
        this.serverList.setCellRenderer(new ServersRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String selectServerDialog(Object[] moduleTypes, String j2eeSpec, String title, String description) {
        NoSelectedServerWarning panel = new NoSelectedServerWarning(moduleTypes, j2eeSpec);
        Object[] options = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION};
        final DialogDescriptor desc = new DialogDescriptor((Object)panel, title, true, options, DialogDescriptor.OK_OPTION, 0, null, null);
        desc.setMessageType(2);
        Dialog dlg = null;
        try {
            dlg = DialogDisplayer.getDefault().createDialog(desc);
            dlg.getAccessibleContext().setAccessibleDescription(description);
            panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    Object newvalue;
                    if (evt.getPropertyName().equals(NoSelectedServerWarning.OK_ENABLED) && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                        desc.setValid(((Boolean)newvalue).booleanValue());
                    }
                }
            });
            desc.setValid(panel.getSelectedInstance() != null);
            panel.setSize(panel.getPreferredSize());
            dlg.pack();
            dlg.setVisible(true);
        }
        finally {
            if (dlg != null) {
                dlg.dispose();
            }
        }
        return desc.getValue() == DialogDescriptor.OK_OPTION ? panel.getSelectedInstance() : null;
    }

    public String getSelectedInstance() {
        if (this.serverList.getSelectedIndex() == -1) {
            return null;
        }
        return (String)this.serverList.getSelectedValue();
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.serverList = new JList();
        this.jTextArea1 = new JTextArea();
        this.jTextArea2 = new JTextArea();
        this.jButtonAddServer = new JButton();
        this.setLayout(new GridBagLayout());
        this.jScrollPane2.setMinimumSize(new Dimension(200, 100));
        this.serverList.setSelectionMode(0);
        this.serverList.setPreferredSize(null);
        this.serverList.setVisibleRowCount(4);
        this.jScrollPane2.setViewportView(this.serverList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jTextArea1.setColumns(25);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(NbBundle.getMessage(NoSelectedServerWarning.class, (String)"LBL_NoSelectedServerWarning_jLabel1"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setFocusable(false);
        this.jTextArea1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 6, 12);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setText(NbBundle.getMessage(NoSelectedServerWarning.class, (String)"LBL_NoSuitableServerWarning_jLabel2"));
        this.jTextArea2.setWrapStyleWord(true);
        this.jTextArea2.setFocusable(false);
        this.jTextArea2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 6, 12);
        this.add((Component)this.jTextArea2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAddServer, (String)NbBundle.getMessage(NoSelectedServerWarning.class, (String)"LBL_AddServer"));
        this.jButtonAddServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NoSelectedServerWarning.this.jButtonAddServerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jButtonAddServer, gridBagConstraints);
        this.jButtonAddServer.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NoSelectedServerWarning.class, (String)"ACSN_AddServer"));
        this.jButtonAddServer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NoSelectedServerWarning.class, (String)"ACSD_AddServer"));
    }

    private void jButtonAddServerActionPerformed(ActionEvent evt) {
        boolean isEmpty;
        ServerListModel model = (ServerListModel)this.serverList.getModel();
        String lastSelectedValue = (String)this.serverList.getSelectedValue();
        boolean wasEmpty = model.getSize() == 0;
        ServerManager.showCustomizer((String)lastSelectedValue);
        model.refreshModel();
        boolean bl = isEmpty = model.getSize() == 0;
        if (wasEmpty != isEmpty) {
            this.jTextArea2.setVisible(isEmpty);
        }
        if (lastSelectedValue != null && Deployment.getDefault().getJ2eePlatform(lastSelectedValue) != null) {
            this.serverList.setSelectedValue(lastSelectedValue, true);
        } else {
            this.serverList.clearSelection();
        }
    }

    private static final class ServersRenderer
    extends JLabel
    implements ListCellRenderer {
        ServersRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof String) {
                String id = (String)value;
                this.setText(Deployment.getDefault().getServerInstanceDisplayName(id));
            } else {
                this.setText(value.toString());
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private static final class ServerListModel
    extends AbstractListModel {
        private String[] instances;
        private final Object[] moduleTypes;
        private final String j2eeSpec;

        public ServerListModel(Object[] moduleTypes, String j2eeSpec) {
            this.moduleTypes = moduleTypes;
            this.j2eeSpec = j2eeSpec;
            this.instances = Deployment.getDefault().getServerInstanceIDs(moduleTypes, j2eeSpec);
        }

        public synchronized int getSize() {
            return this.instances.length;
        }

        public synchronized Object getElementAt(int index) {
            if (index >= 0 && index < this.instances.length) {
                return this.instances[index];
            }
            return null;
        }

        public synchronized void refreshModel() {
            int oldLength = this.instances.length;
            this.instances = Deployment.getDefault().getServerInstanceIDs(this.moduleTypes, this.j2eeSpec);
            if (this.instances.length > 0) {
                this.fireContentsChanged(this, 0, this.instances.length - 1);
            } else if (oldLength > 0) {
                this.fireIntervalRemoved(this, 0, oldLength - 1);
            }
        }
    }
}

