/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.xml.core.wizard.AbstractPanel;
import org.netbeans.modules.xml.core.wizard.SchemaParser;
import org.netbeans.modules.xml.core.wizard.Util;

public class SchemaPanel
extends AbstractPanel {
    private static final long serialVersionUID = -7568909683682244030L;
    private DefaultComboBoxModel nsModel;
    private DefaultComboBoxModel rootModel;
    private JLabel locationLabel;
    private JLabel rootLabel;
    private JLabel nsLabel;
    private JComboBox rootComboBox;
    private JTextField locationTextField;
    private JTextArea descTextArea;
    private JButton locationButton;
    private JComboBox nsComboBox;
    private JPanel fillPanel;

    public SchemaPanel() {
        this.initComponents();
        this.initAccessibility();
    }

    private void initComponents() {
        this.descTextArea = new JTextArea();
        this.locationLabel = new JLabel();
        this.locationTextField = new JTextField();
        this.locationButton = new JButton();
        this.nsLabel = new JLabel();
        this.nsComboBox = new JComboBox();
        this.rootLabel = new JLabel();
        this.rootComboBox = new JComboBox();
        this.fillPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setName(Util.THIS.getString("PROP_schema_panel_name"));
        this.descTextArea.setColumns(20);
        this.descTextArea.setEditable(false);
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setText(Util.THIS.getString("MSG_schema_wizard_desc"));
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setDisabledTextColor(this.descTextArea.getForeground());
        this.descTextArea.setEnabled(false);
        this.descTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.descTextArea, gridBagConstraints);
        this.locationLabel.setLabelFor(this.locationTextField);
        this.locationLabel.setText(Util.THIS.getString("LBL_schema_location"));
        this.locationLabel.setToolTipText(Util.THIS.getString("PROP_schema_locationLabel_desc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.locationLabel, gridBagConstraints);
        this.locationTextField.setToolTipText(Util.THIS.getString("PROP_schema_locationTextField_desc"));
        this.locationTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                SchemaPanel.this.locationTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.locationTextField, gridBagConstraints);
        this.locationButton.setText(Util.THIS.getString("LBL_browse"));
        this.locationButton.setToolTipText(Util.THIS.getString("PROP_schema_locationButton_desc"));
        this.locationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SchemaPanel.this.locationButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.locationButton, gridBagConstraints);
        this.nsLabel.setLabelFor(this.nsComboBox);
        this.nsLabel.setText(Util.THIS.getString("LBL_root_namespace"));
        this.nsLabel.setToolTipText(Util.THIS.getString("PROP_schema_nsLabel_desc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.nsLabel, gridBagConstraints);
        this.nsComboBox.setEditable(true);
        this.nsComboBox.setToolTipText(Util.THIS.getString("PROP_schema_nsComboBox_desc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.nsComboBox, gridBagConstraints);
        this.rootLabel.setLabelFor(this.rootComboBox);
        this.rootLabel.setText(Util.THIS.getString("PROP_schema_root_name"));
        this.rootLabel.setToolTipText(Util.THIS.getString("PROP_schema_rootLabel_desc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.rootLabel, gridBagConstraints);
        this.rootComboBox.setEditable(true);
        this.rootComboBox.setToolTipText(Util.THIS.getString("PROP_schema_rootComboBox_desc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.rootComboBox, gridBagConstraints);
        this.fillPanel.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillPanel, gridBagConstraints);
    }

    private void initAccessibility() {
        Util util = Util.THIS;
        this.locationLabel.setDisplayedMnemonic(util.getChar("PROP_schema_locationLabel_mne"));
        this.rootLabel.setDisplayedMnemonic(util.getChar("PROP_schema_rootLabel_mne"));
        this.nsLabel.setDisplayedMnemonic(util.getChar("PROP_schema_nsLabel_mne"));
        this.locationButton.setMnemonic(util.getChar("PROP_schema_locationButton_mne"));
        this.getAccessibleContext().setAccessibleDescription(this.descTextArea.getText());
    }

    private void locationTextFieldFocusLost(FocusEvent evt) {
        this.updatePossibilities();
    }

    private void locationButtonActionPerformed(ActionEvent evt) {
        File file = Util.selectSchemaFile("xsd xml xsdl");
        if (file == null) {
            return;
        }
        try {
            URL url = file.toURL();
            this.locationTextField.setText(url.toExternalForm());
            this.updatePossibilities();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void updatePossibilities() {
        Component editor;
        SchemaParser parser = new SchemaParser();
        String systemId = this.locationTextField.getText();
        try {
            URL context = this.model.getTargetFolderURL();
            if (context != null) {
                systemId = new URL(context, systemId).toExternalForm();
            }
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        SchemaParser.SchemaInfo info = parser.parse(systemId);
        if (info == null) {
            return;
        }
        this.nsModel.removeAllElements();
        if (info.namespace != null) {
            this.nsModel.addElement(info.namespace);
        }
        if (info.roots.size() > 0) {
            this.rootModel.removeAllElements();
            Iterator it = info.roots.iterator();
            while (it.hasNext()) {
                String next = (String)it.next();
                this.rootModel.addElement(next);
            }
        }
        if ((editor = this.rootComboBox.getEditor().getEditorComponent()) instanceof JTextComponent) {
            ((JTextComponent)editor).selectAll();
        }
    }

    protected void initView() {
        this.nsModel = new DefaultComboBoxModel();
        this.rootModel = new DefaultComboBoxModel();
        this.nsComboBox.setModel(this.nsModel);
        this.rootComboBox.setModel(this.rootModel);
    }

    protected void updateModel() {
        String uri = this.locationTextField.getText();
        if (uri != null) {
            uri = uri.replaceAll(" ", "%20");
            try {
                uri = new URI(uri).toASCIIString();
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        this.model.setSystemID(uri == null || uri.length() == 0 ? null : uri);
        Object ns = this.nsComboBox.getSelectedItem();
        this.model.setNamespace(ns == null ? null : ns.toString());
        Object root = this.rootComboBox.getSelectedItem();
        this.model.setRoot(root == null ? null : root.toString());
    }

    protected void updateView() {
    }
}

