/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FontEditor
implements PropertyEditor,
XMLPropertyEditor {
    static final Integer[] sizes;
    static final String[] styles;
    private Font font;
    private String fontName;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private static String[] fonts;
    public static final String XML_FONT = "Font";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_SIZE = "size";
    static final /* synthetic */ boolean $assertionsDisabled;

    public Object getValue() {
        return this.font;
    }

    public void setValue(Object object) {
        if (this.font != null && this.font.equals(object)) {
            return;
        }
        if (this.font == null && object == null) {
            return;
        }
        if (object instanceof Font) {
            this.font = (Font)object;
        } else if (object == null) {
            this.font = null;
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Object " + object + " is instanceof Font or null"));
        }
        this.fontName = this.font != null ? this.font.getName() + " " + this.font.getSize() + " " + this.getStyleName(this.font.getStyle()) : null;
        this.support.firePropertyChange("", null, null);
    }

    public String getAsText() {
        return this.fontName;
    }

    public void setAsText(String string) {
    }

    public String getJavaInitializationString() {
        return "new java.awt.Font(\"" + this.font.getName() + "\", " + this.font.getStyle() + ", " + this.font.getSize() + ")";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
        Font paintFont;
        Font originalFont = g.getFont();
        if (this.font == null) {
            this.setValue(null);
        }
        Font font = paintFont = this.font == null ? originalFont : this.font;
        if (!$assertionsDisabled && paintFont == null) {
            throw new AssertionError((Object)"paintFont must exist.");
        }
        FontMetrics fm = g.getFontMetrics(paintFont);
        if (fm.getHeight() > rectangle.height) {
            paintFont = Utilities.getOperatingSystem() == 4096 ? new Font(this.font.getName(), this.font.getStyle(), 12) : this.font.deriveFont(12.0f);
            fm = g.getFontMetrics(paintFont);
        }
        g.setFont(paintFont);
        g.drawString(this.fontName == null ? "null" : this.fontName, rectangle.x, rectangle.y + (rectangle.height - fm.getHeight()) / 2 + fm.getAscent());
        g.setFont(originalFont);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new FontPanel();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    String getStyleName(int i) {
        if ((i & 1) > 0) {
            if ((i & 2) > 0) {
                return NbBundle.getMessage((Class)FontEditor.class, (String)"CTL_BoldItalic");
            }
            return NbBundle.getMessage((Class)FontEditor.class, (String)"CTL_Bold");
        }
        if ((i & 2) > 0) {
            return NbBundle.getMessage((Class)FontEditor.class, (String)"CTL_Italic");
        }
        return NbBundle.getMessage((Class)FontEditor.class, (String)"CTL_Plain");
    }

    private static String[] getFonts() {
        if (fonts == null) {
            try {
                fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            }
            catch (RuntimeException e) {
                fonts = new String[0];
                if (Utilities.getOperatingSystem() == 4096) {
                    String msg = NbBundle.getMessage((Class)FontEditor.class, (String)"MSG_AppleBug");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
                }
                throw e;
            }
        }
        return fonts;
    }

    public void readFromXML(Node element) throws IOException {
        if (!XML_FONT.equals(element.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap attributes = element.getAttributes();
        try {
            String name = attributes.getNamedItem(ATTR_NAME).getNodeValue();
            String style = attributes.getNamedItem(ATTR_STYLE).getNodeValue();
            String size = attributes.getNamedItem(ATTR_SIZE).getNodeValue();
            this.setValue(new Font(name, Integer.parseInt(style), Integer.parseInt(size)));
        }
        catch (NullPointerException e) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document doc) {
        if (this.font == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            ErrorManager manager = ErrorManager.getDefault();
            manager.annotate((Throwable)iae, 4096, null, NbBundle.getMessage((Class)FontEditor.class, (String)"MSG_FontIsNotInitialized"), null, null);
            manager.notify((Throwable)iae);
            return null;
        }
        Element el = doc.createElement(XML_FONT);
        el.setAttribute(ATTR_NAME, this.font.getName());
        el.setAttribute(ATTR_STYLE, Integer.toString(this.font.getStyle()));
        el.setAttribute(ATTR_SIZE, Integer.toString(this.font.getSize()));
        return el;
    }

    static {
        $assertionsDisabled = !FontEditor.class.desiredAssertionStatus();
        sizes = new Integer[]{new Integer(3), new Integer(5), new Integer(8), new Integer(10), new Integer(12), new Integer(14), new Integer(18), new Integer(24), new Integer(36), new Integer(48)};
        styles = new String[]{NbBundle.getMessage((Class)FontEditor.class, (String)"CTL_Plain"), NbBundle.getMessage((Class)FontEditor.class, (String)"CTL_Bold"), NbBundle.getMessage((Class)FontEditor.class, (String)"CTL_Italic"), NbBundle.getMessage((Class)FontEditor.class, (String)"CTL_BoldItalic")};
    }

    class FontPanel
    extends JPanel {
        JTextField tfFont;
        JTextField tfStyle;
        JTextField tfSize;
        JList lFont;
        JList lStyle;
        JList lSize;
        static final long serialVersionUID = 8377025140456676594L;

        FontPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
            Font font = (Font)FontEditor.this.getValue();
            if (font == null) {
                font = FontEditor.getFonts().length > 0 ? new Font(fonts[0], 0, 10) : UIManager.getFont("Label.font");
            }
            this.lFont = new JList<String>(FontEditor.getFonts());
            this.lFont.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$beaninfo$editors$FontEditor == null ? (class$org$netbeans$beaninfo$editors$FontEditor = FontEditor.class$("org.netbeans.beaninfo.editors.FontEditor")) : class$org$netbeans$beaninfo$editors$FontEditor), (String)"ACSD_CTL_Font"));
            this.lStyle = new JList<String>(styles);
            this.lStyle.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$beaninfo$editors$FontEditor == null ? (class$org$netbeans$beaninfo$editors$FontEditor = FontEditor.class$("org.netbeans.beaninfo.editors.FontEditor")) : class$org$netbeans$beaninfo$editors$FontEditor), (String)"ACSD_CTL_FontStyle"));
            this.lSize = new JList<Integer>(sizes);
            this.lSize.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$beaninfo$editors$FontEditor == null ? (class$org$netbeans$beaninfo$editors$FontEditor = FontEditor.class$("org.netbeans.beaninfo.editors.FontEditor")) : class$org$netbeans$beaninfo$editors$FontEditor), (String)"ACSD_CTL_Size"));
            this.tfSize = new JTextField("" + font.getSize());
            this.tfSize.getAccessibleContext().setAccessibleDescription(this.lSize.getAccessibleContext().getAccessibleDescription());
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$beaninfo$editors$FontEditor == null ? (class$org$netbeans$beaninfo$editors$FontEditor = FontEditor.class$("org.netbeans.beaninfo.editors.FontEditor")) : class$org$netbeans$beaninfo$editors$FontEditor), (String)"ACSD_FontCustomEditor"));
            GridBagLayout la = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(la);
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.insets = new Insets(0, 0, 0, 0);
            c.anchor = 17;
            JLabel l = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$beaninfo$editors$FontEditor == null ? (class$org$netbeans$beaninfo$editors$FontEditor = FontEditor.class$("org.netbeans.beaninfo.editors.FontEditor")) : class$org$netbeans$beaninfo$editors$FontEditor), (String)"CTL_Font"));
            l.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$beaninfo$editors$FontEditor == null ? (class$org$netbeans$beaninfo$editors$FontEditor = FontEditor.class$("org.netbeans.beaninfo.editors.FontEditor")) : class$org$netbeans$beaninfo$editors$FontEditor), (String)"CTL_Font_mnemonic").charAt(0));
            l.setLabelFor(this.lFont);
            la.setConstraints(l, c);
            this.add(l);
            c.insets = new Insets(0, 5, 0, 0);
            l = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$beaninfo$editors$FontEditor == null ? (class$org$netbeans$beaninfo$editors$FontEditor = FontEditor.class$("org.netbeans.beaninfo.editors.FontEditor")) : class$org$netbeans$beaninfo$editors$FontEditor), (String)"CTL_FontStyle"));
            l.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$beaninfo$editors$FontEditor == null ? (class$org$netbeans$beaninfo$editors$FontEditor = FontEditor.class$("org.netbeans.beaninfo.editors.FontEditor")) : class$org$netbeans$beaninfo$editors$FontEditor), (String)"CTL_FontStyle_mnemonic").charAt(0));
            l.setLabelFor(this.lStyle);
            la.setConstraints(l, c);
            this.add(l);
            c.insets = new Insets(0, 5, 0, 0);
            c.gridwidth = 0;
            l = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$beaninfo$editors$FontEditor == null ? (class$org$netbeans$beaninfo$editors$FontEditor = FontEditor.class$("org.netbeans.beaninfo.editors.FontEditor")) : class$org$netbeans$beaninfo$editors$FontEditor), (String)"CTL_Size"));
            l.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$beaninfo$editors$FontEditor == null ? (class$org$netbeans$beaninfo$editors$FontEditor = FontEditor.class$("org.netbeans.beaninfo.editors.FontEditor")) : class$org$netbeans$beaninfo$editors$FontEditor), (String)"CTL_Size_mnemonic").charAt(0));
            l.setLabelFor(this.tfSize);
            la.setConstraints(l, c);
            this.add(l);
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 1;
            c.fill = 2;
            this.tfFont = new JTextField(font.getName());
            this.tfFont.setEnabled(false);
            la.setConstraints(this.tfFont, c);
            this.add(this.tfFont);
            c.insets = new Insets(5, 5, 0, 0);
            this.tfStyle = new JTextField(FontEditor.this.getStyleName(font.getStyle()));
            this.tfStyle.setEnabled(false);
            la.setConstraints(this.tfStyle, c);
            this.add(this.tfStyle);
            c.insets = new Insets(5, 5, 0, 0);
            c.gridwidth = 0;
            this.tfSize.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        FontPanel.this.setValue();
                    }
                }
            });
            this.tfSize.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent evt) {
                    FontPanel.this.setValue();
                }
            });
            la.setConstraints(this.tfSize, c);
            this.add(this.tfSize);
            c.gridwidth = 1;
            c.insets = new Insets(5, 0, 0, 0);
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.lFont.setVisibleRowCount(5);
            this.lFont.setSelectedValue(font.getName(), true);
            this.lFont.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!FontPanel.this.lFont.isSelectionEmpty() && FontEditor.getFonts().length > 0) {
                        int i = FontPanel.this.lFont.getSelectedIndex();
                        FontPanel.this.tfFont.setText(FontEditor.getFonts()[i]);
                        FontPanel.this.setValue();
                    }
                }
            });
            JScrollPane sp = new JScrollPane(this.lFont);
            sp.setVerticalScrollBarPolicy(22);
            la.setConstraints(sp, c);
            this.add(sp);
            this.lStyle.setVisibleRowCount(5);
            this.lStyle.setSelectedValue(FontEditor.this.getStyleName(font.getStyle()), true);
            this.lStyle.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!FontPanel.this.lStyle.isSelectionEmpty()) {
                        int i = FontPanel.this.lStyle.getSelectedIndex();
                        FontPanel.this.tfStyle.setText(styles[i]);
                        FontPanel.this.setValue();
                    }
                }
            });
            sp = new JScrollPane(this.lStyle);
            sp.setVerticalScrollBarPolicy(22);
            c.insets = new Insets(5, 5, 0, 0);
            la.setConstraints(sp, c);
            this.add(sp);
            c.gridwidth = 0;
            this.lSize.getAccessibleContext().setAccessibleName(this.tfSize.getAccessibleContext().getAccessibleName());
            this.lSize.setVisibleRowCount(5);
            this.updateSizeList(font.getSize());
            this.lSize.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!FontPanel.this.lSize.isSelectionEmpty()) {
                        int i = FontPanel.this.lSize.getSelectedIndex();
                        FontPanel.this.tfSize.setText("" + sizes[i]);
                        FontPanel.this.setValue();
                    }
                }
            });
            sp = new JScrollPane(this.lSize);
            sp.setVerticalScrollBarPolicy(22);
            c.insets = new Insets(5, 5, 0, 0);
            la.setConstraints(sp, c);
            this.add(sp);
            c.gridwidth = 0;
            c.weighty = 2.0;
            JPanel p = new JPanel(new BorderLayout());
            p.setBorder(new TitledBorder(" " + NbBundle.getMessage((Class)(class$org$netbeans$beaninfo$editors$FontEditor == null ? (class$org$netbeans$beaninfo$editors$FontEditor = FontEditor.class$("org.netbeans.beaninfo.editors.FontEditor")) : class$org$netbeans$beaninfo$editors$FontEditor), (String)"CTL_Preview") + " "));
            JPanel pp = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(150, 60);
                }

                public void paint(Graphics g) {
                    FontEditor.this.paintValue(g, new Rectangle(0, 0, this.getSize().width - 1, this.getSize().height - 1));
                }
            };
            p.add("Center", pp);
            c.insets = new Insets(12, 0, 0, 0);
            la.setConstraints(p, c);
            this.add(p);
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 250);
        }

        private void updateSizeList(int size) {
            if (Arrays.asList(sizes).contains(new Integer(size))) {
                this.lSize.setSelectedValue(new Integer(size), true);
            } else {
                this.lSize.clearSelection();
            }
        }

        void setValue() {
            int size = 12;
            try {
                size = Integer.parseInt(this.tfSize.getText());
                this.updateSizeList(size);
            }
            catch (NumberFormatException e) {
                return;
            }
            int i = this.lStyle.getSelectedIndex();
            int ii = 0;
            switch (i) {
                case 0: {
                    ii = 0;
                    break;
                }
                case 1: {
                    ii = 1;
                    break;
                }
                case 2: {
                    ii = 2;
                    break;
                }
                case 3: {
                    ii = 3;
                }
            }
            FontEditor.this.setValue(new Font(this.tfFont.getText(), ii, size));
            this.invalidate();
            Container p = this.getParent();
            if (p != null) {
                ((Component)p).validate();
            }
            this.repaint();
        }
    }
}

