/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.beaninfo.editors.PropertiesEditor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PropertiesCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    private PropertiesEditor editor;
    private JScrollPane textAreaScroll;
    private JEditorPane editorPane;
    private static final long serialVersionUID = 2473843831910895646L;

    public PropertiesCustomEditor(PropertiesEditor ed) {
        this.editor = ed;
        this.initComponents();
        Properties props = (Properties)this.editor.getValue();
        if (props == null) {
            props = new Properties();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            props.store(baos, "");
        }
        catch (IOException e) {
            // empty catch block
        }
        this.editorPane.setText(baos.toString());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        HelpCtx.setHelpIDString((JComponent)this, (String)PropertiesCustomEditor.class.getName());
        this.editorPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)PropertiesCustomEditor.class).getString("ACS_PropertiesEditorPane"));
        this.editorPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)PropertiesCustomEditor.class).getString("ACSD_PropertiesEditorPane"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)PropertiesCustomEditor.class).getString("ACSD_CustomPropertiesEditor"));
    }

    private boolean containsCommentedProps() {
        StringTokenizer tok = new StringTokenizer(this.editorPane.getText(), "\n", false);
        while (tok.hasMoreTokens()) {
            String row = tok.nextToken().trim();
            if (!row.startsWith("#") || row.indexOf(61) <= 0) continue;
            return true;
        }
        return false;
    }

    public Object getPropertyValue() throws IllegalStateException {
        if (this.containsCommentedProps()) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getBundle((Class)PropertiesCustomEditor.class).getString("MSG_PropertiesComments"));
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                throw new IllegalStateException();
            }
        }
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(this.editorPane.getText().getBytes()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 400);
    }

    private void initComponents() {
        this.textAreaScroll = new JScrollPane();
        this.editorPane = new JEditorPane();
        this.setLayout(new BorderLayout());
        this.editorPane.setContentType("text/x-properties");
        this.textAreaScroll.setViewportView(this.editorPane);
        this.add((Component)this.textAreaScroll, "Center");
    }
}

