/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class InputPanel
extends JPanel
implements ActionListener,
FocusListener {
    public static final String ACTION_EOF = "eof";
    public static final String ACTION_NEWTEXT = "text";
    private JTextField field = new JTextField();
    private JButton eof = new JButton(NbBundle.getMessage((Class)InputPanel.class, (String)"LBL_EOF"));
    private ActionListener listener = null;
    private JLabel lbl = new JLabel(NbBundle.getMessage((Class)InputPanel.class, (String)"LBL_INPUT"));

    public InputPanel() {
        this.init();
        this.setFocusable(false);
    }

    public void requestFocus() {
        this.field.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.field.requestFocusInWindow();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.lbl, "West");
        this.add((Component)this.field, "Center");
        this.field.setEditable(true);
        this.add((Component)this.eof, "East");
        this.field.addActionListener(this);
        this.eof.addActionListener(this);
        this.eof.setToolTipText(NbBundle.getMessage((Class)InputPanel.class, (String)"TIP_EOF"));
        this.field.setToolTipText(NbBundle.getMessage((Class)InputPanel.class, (String)"TIP_INPUT"));
        this.field.getAccessibleContext().setAccessibleName(this.lbl.getText());
        this.eof.getAccessibleContext().setAccessibleName(this.eof.getText());
        this.field.getAccessibleContext().setAccessibleDescription(this.field.getToolTipText());
        this.eof.getAccessibleContext().setAccessibleDescription(this.eof.getToolTipText());
        this.lbl.setDisplayedMnemonic(Utilities.stringToKey((String)NbBundle.getMessage((Class)InputPanel.class, (String)"INPUT.mnemonic")).getKeyCode());
        this.lbl.setDisplayedMnemonicIndex(Integer.parseInt(NbBundle.getMessage((Class)InputPanel.class, (String)"INPUT.index")));
        this.eof.setMnemonic(NbBundle.getMessage((Class)InputPanel.class, (String)"EOF.mnemonic").charAt(0));
        Border b = this.field.getBorder();
        this.field.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, this.getBackground()), b));
        this.lbl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.lbl.setLabelFor(this.field);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlShadow")), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.field.addFocusListener(this);
    }

    public void doLayout() {
        Dimension lblp = this.lbl.getPreferredSize();
        Dimension eofp = this.eof.getPreferredSize();
        Dimension fp = this.field.getPreferredSize();
        Insets ins = this.getInsets();
        this.lbl.setBounds(ins.left, ins.top, lblp.width, this.getHeight() - (ins.top + ins.bottom));
        int ftop = this.getHeight() / 2 - fp.height / 2;
        int fright = this.getWidth() - (ins.right + eofp.width);
        int fleft = ins.left + lblp.width;
        this.field.setBounds(fleft, ftop, fright - fleft, fp.height);
        int btop = this.getHeight() / 2 - eofp.height / 2;
        this.eof.setBounds(fright, btop, this.getWidth() - (fright + ins.right), eofp.height);
    }

    public Dimension getPreferredSize() {
        Dimension lblp = this.lbl.getPreferredSize();
        Dimension eofp = this.eof.getPreferredSize();
        Dimension fp = this.field.getPreferredSize();
        Insets ins = this.getInsets();
        int h = ins.top + ins.bottom + Math.max(Math.max(lblp.height, eofp.height), fp.height);
        int w = ins.left + lblp.width + eofp.width + fp.width + ins.right;
        return new Dimension(w, h);
    }

    public Dimension getMinimumSize() {
        Dimension lblp = this.lbl.getMinimumSize();
        Dimension eofp = this.eof.getMinimumSize();
        Dimension fp = this.field.getMinimumSize();
        Insets ins = this.getInsets();
        int h = ins.top + ins.bottom + Math.max(Math.max(lblp.height, eofp.height), fp.height);
        int w = ins.left + lblp.width + eofp.width + fp.width + ins.right;
        return new Dimension(w, h);
    }

    public String getText() {
        return this.field.getText();
    }

    public void addActionListener(ActionListener listener) {
        if (this.listener != null) {
            throw new IllegalStateException(this.listener + " is already " + "listening");
        }
        this.listener = listener;
    }

    public void removeActionListener(ActionListener listener) {
        if (listener != this.listener) {
            throw new IllegalArgumentException(listener + " is not " + this.listener);
        }
        this.listener = null;
    }

    public void actionPerformed(ActionEvent ae) {
        ActionEvent e = new ActionEvent(this, 1001, ae.getSource() == this.eof ? ACTION_EOF : ACTION_NEWTEXT);
        if (Controller.log) {
            Controller.log("Got action event from " + ae.getSource());
        }
        if (Controller.log) {
            Controller.log("  Posting event to listener(tab) " + e);
        }
        if (ae.getSource() == this.field && this.field.getText().length() > 0) {
            this.field.setSelectionStart(0);
            this.field.setSelectionEnd(this.field.getText().length());
        }
        this.listener.actionPerformed(e);
    }

    private AbstractOutputTab findOutputTab() {
        if (this.getParent() != null) {
            return (AbstractOutputTab)SwingUtilities.getAncestorOfClass(AbstractOutputTab.class, this);
        }
        return null;
    }

    public void focusGained(FocusEvent fe) {
        AbstractOutputTab tab = this.findOutputTab();
        if (tab != null) {
            tab.notifyInputFocusGained();
        }
    }

    public void focusLost(FocusEvent fe) {
    }
}

