/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspTagTokenContext;
import org.netbeans.modules.web.core.syntax.spi.ErrorAnnotation;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public class JspParserErrorAnnotation
extends ErrorAnnotation.LineSetAnnotation {
    private Line docline;
    private final int line;
    private final int column;
    private final String error;
    private NbEditorDocument document;

    public JspParserErrorAnnotation(int line, int column, String error, NbEditorDocument document) {
        this.line = line;
        this.column = column;
        this.error = error;
        this.document = document;
    }

    public String getShortDescription() {
        return this.error;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getError() {
        return this.error;
    }

    public String getAnnotationType() {
        return "org-netbeans-modules-web-core-syntax-JspParserErrorAnnotation";
    }

    public void attachToLineSet(Line.Set lines) {
        try {
            this.docline = lines.getCurrent(this.line - 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return;
        }
        String annTxt = this.docline.getText();
        if (annTxt == null) {
            return;
        }
        ExtSyntaxSupport support = (ExtSyntaxSupport)this.document.getSyntaxSupport();
        int offset = NbDocument.findLineOffset((StyledDocument)this.document, (int)this.docline.getLineNumber()) + this.column + 1;
        TokenItem token = null;
        int start = 0;
        char[] string = annTxt.toCharArray();
        int end = string.length - 1;
        if (offset < 1) {
            this.textOnLine(this.docline);
            return;
        }
        try {
            token = ((JspSyntaxSupport)support).getTokenChain(offset - 1, offset);
            if (token == null) {
                this.textOnLine(this.docline);
                return;
            }
            start = NbDocument.findLineColumn((StyledDocument)this.document, (int)token.getOffset());
            offset = token.getOffset();
            TokenContextPath contextPath = token.getTokenContextPath();
            if (contextPath.contains(JspTagTokenContext.contextPath) || contextPath.contains(HTMLTokenContext.contextPath)) {
                while (token != null && (token.getTokenID().getNumericID() != 4 || token.getImage().charAt(0) != '<')) {
                    if ((token = token.getPrevious()) == null) continue;
                    start = NbDocument.findLineColumn((StyledDocument)this.document, (int)token.getOffset());
                    offset = token.getOffset();
                }
                while (token != null && (token.getTokenID().getNumericID() != 4 || token.getImage().charAt(token.getImage().trim().length() - 1) != '>') && token.getTokenID().getNumericID() != 9) {
                    token = token.getNext();
                }
            } else {
                while (token != null && (token.getTokenID().getNumericID() != 7 || token.getImage().charAt(0) != '$')) {
                    if ((token = token.getPrevious()) == null) continue;
                    start = NbDocument.findLineColumn((StyledDocument)this.document, (int)token.getOffset());
                    offset = token.getOffset();
                }
                while (token != null && (token.getTokenID().getNumericID() != 7 || token.getImage().charAt(token.getImage().trim().length() - 1) != '}') && token.getTokenID().getNumericID() != 6) {
                    token = token.getNext();
                }
            }
            if (token != null) {
                end = token.getOffset() + token.getImage().trim().length() - offset;
            } else {
                while (end >= 0 && end > start && string[end] != ' ') {
                    --end;
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace(System.out);
            return;
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace(System.out);
            return;
        }
        Line.Part part = this.docline.createPart(start, end);
        this.attach((Annotatable)part);
    }

    private void textOnLine(Line docline) {
        int start;
        char[] string = docline.getText().toCharArray();
        int end = string.length - 1;
        for (start = 0; start <= end && string[start] <= ' '; ++start) {
        }
        while (start <= end && string[end] <= ' ') {
            --end;
        }
        Line.Part part = start <= end ? docline.createPart(start, end - start + 1) : docline.createPart(0, string.length);
        this.attach((Annotatable)part);
    }

    public boolean equals(Object obj) {
        if (obj instanceof JspParserErrorAnnotation) {
            JspParserErrorAnnotation ann = (JspParserErrorAnnotation)((Object)obj);
            if (this == obj) {
                return true;
            }
            if (this.line != ann.getLine()) {
                return false;
            }
            if (this.column != ann.getColumn()) {
                return false;
            }
            return this.error.equals(ann.getError());
        }
        return false;
    }
}

