/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.spi.JSPColoringData;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProvider;
import org.openide.loaders.DataObject;
import org.openide.util.WeakListeners;

final class JspUpToDateStatusProvider
extends UpToDateStatusProvider
implements DocumentListener,
PropertyChangeListener {
    private UpToDateStatus upToDate = UpToDateStatus.UP_TO_DATE_OK;

    public static JspUpToDateStatusProvider get(Document doc) {
        JspUpToDateStatusProvider provider = (JspUpToDateStatusProvider)doc.getProperty(JspUpToDateStatusProvider.class);
        if (provider == null) {
            provider = new JspUpToDateStatusProvider(doc);
            doc.putProperty(JspUpToDateStatusProvider.class, provider);
        }
        return provider;
    }

    private JspUpToDateStatusProvider(Document document) {
        document.addDocumentListener(this);
        DataObject documentDO = NbEditorUtilities.getDataObject((Document)document);
        if (documentDO != null && documentDO.isValid()) {
            JSPColoringData jspcd = JspUtils.getJSPColoringData(document, documentDO.getPrimaryFile());
            jspcd.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jspcd));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Boolean newValue = (Boolean)evt.getNewValue();
        if ("parsingInProgress".equals(evt.getPropertyName()) && newValue.booleanValue()) {
            this.setUpToDate(UpToDateStatus.UP_TO_DATE_PROCESSING);
        }
        if ("parsingSuccessful".equals(evt.getPropertyName())) {
            this.setUpToDate(UpToDateStatus.UP_TO_DATE_OK);
        }
    }

    public synchronized UpToDateStatus getUpToDate() {
        return this.upToDate;
    }

    private void setUpToDate(UpToDateStatus upToDate) {
        UpToDateStatus oldStatus = this.upToDate;
        if (oldStatus.equals((Object)upToDate)) {
            return;
        }
        this.upToDate = upToDate;
        this.firePropertyChange("upToDate", oldStatus, upToDate);
    }

    public synchronized void removeUpdate(DocumentEvent e) {
        this.setUpToDate(UpToDateStatus.UP_TO_DATE_DIRTY);
    }

    public synchronized void insertUpdate(DocumentEvent e) {
        this.setUpToDate(UpToDateStatus.UP_TO_DATE_DIRTY);
    }

    public void changedUpdate(DocumentEvent e) {
    }
}

