/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.html.HTMLCompletionQuery;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JavaCompletionQuery;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.core.syntax.JSPKit;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspTagTokenContext;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.AttrSupports;
import org.netbeans.modules.web.core.syntax.completion.AttributeValueSupport;
import org.netbeans.modules.web.core.syntax.completion.ELExpression;
import org.netbeans.modules.web.core.syntax.completion.ELFunctions;
import org.netbeans.modules.web.core.syntax.completion.ELImplicitObjects;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionItem;
import org.netbeans.modules.web.core.syntax.completion.ResultItem;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class JspCompletionQuery
implements CompletionQuery {
    private static final Set stdXMLEntities = new TreeSet();
    protected CompletionQuery contentQuery;

    public JspCompletionQuery(CompletionQuery contentQuery) {
        this.contentQuery = contentQuery;
    }

    public CompletionQuery.Result query(JTextComponent component, int offset, SyntaxSupport support) {
        BaseDocument doc = (BaseDocument)component.getDocument();
        JspSyntaxSupport sup = (JspSyntaxSupport)support.get(JspSyntaxSupport.class);
        try {
            SyntaxElement elem = sup.getElementChain(offset);
            if (elem == null) {
                return null;
            }
            switch (elem.getCompletionContext()) {
                case 1: {
                    return this.queryJspTag(component, offset, sup, (SyntaxElement.Tag)elem);
                }
                case 2: {
                    CompletionData jspData = this.queryJspEndTag(offset, sup, (SyntaxElement.EndTag)elem, doc);
                    return this.result(component, offset, jspData);
                }
                case 7: {
                    return this.queryJspDirectiveInScriptlet(component, offset, sup, elem, doc);
                }
                case 3: {
                    return this.queryJspDirective(component, offset, sup, (SyntaxElement.Directive)elem, doc);
                }
                case 9: {
                    return this.queryEL(component, offset, sup, elem, doc);
                }
                case 6: {
                    CompletionQuery.Result contentLResult = this.contentQuery == null ? null : this.contentQuery.query(component, offset, support);
                    CompletionData jspData = this.queryJspTagInContent(offset, sup, doc);
                    CompletionQuery.Result jspDirec = this.queryJspDirectiveInContent(component, offset, sup, doc);
                    if (jspData.completionItems.isEmpty() && jspDirec.getData().isEmpty() && (contentLResult == null || contentLResult.getData().isEmpty())) {
                        return null;
                    }
                    CompletionQuery.Result jspRes = this.result(component, offset, jspData);
                    ArrayList all = new ArrayList();
                    all.addAll(jspDirec.getData());
                    all.addAll(jspRes.getData());
                    if (contentLResult != null) {
                        DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
                        if (dobj != null && JspUtils.getJSPColoringData((Document)doc, dobj.getPrimaryFile()).isXMLSyntax()) {
                            this.filterNonStandardXMLEntities(all, contentLResult.getData());
                        } else {
                            all.addAll(contentLResult.getData());
                        }
                    }
                    int htmlAnchorOffset = contentLResult == null || contentLResult.getData().isEmpty() ? -1 : ((HTMLCompletionQuery.HTMLCompletionResult)contentLResult).getSubstituteOffset();
                    JspCompletionResult result = new JspCompletionResult(component, NbBundle.getMessage(JSPKit.class, (String)"CTL_JSP_Completion_Title"), all, offset, jspData.removeLength, htmlAnchorOffset);
                    return result;
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void filterNonStandardXMLEntities(List completionItemsRep, List htmlSuggestions) {
        for (CompletionQuery.ResultItem item : htmlSuggestions) {
            String itemText = item.getItemText();
            boolean filterOut = false;
            if (itemText.startsWith("&") && itemText.endsWith(";") && !stdXMLEntities.contains(itemText)) {
                filterOut = true;
            }
            if (filterOut) continue;
            completionItemsRep.add(item);
        }
    }

    private void setResultItemsOffset(List items, int removeLength, int ccoffset) {
        for (CompletionQuery.ResultItem ri : items) {
            if (!(ri instanceof ResultItem)) continue;
            ((ResultItem)ri).setSubstituteOffset(ccoffset - removeLength);
        }
    }

    private void setResultItemsOffset(CompletionData cd, int ccoffset) {
        this.setResultItemsOffset(cd.completionItems, cd.removeLength, ccoffset);
    }

    protected CompletionQuery.Result queryJspTag(JTextComponent component, int offset, JspSyntaxSupport sup, SyntaxElement.Tag elem) throws BadLocationException {
        BaseDocument doc = (BaseDocument)component.getDocument();
        List compItems = new ArrayList();
        int removeLength = 0;
        TokenItem item = sup.getItemAtOrBefore(offset);
        if (item == null) {
            return this.result(component, offset, new CompletionData(compItems, 0));
        }
        TokenID id = item.getTokenID();
        String tokenPart = item.getImage().substring(0, offset - item.getOffset());
        String token = item.getImage().trim();
        if (id == JspTagTokenContext.SYMBOL) {
            AttributeValueSupport attSup;
            String attrName;
            if (tokenPart.equals("<")) {
                removeLength = 0;
                this.addTagPrefixItems(sup, compItems, sup.getTagPrefixes(""));
            }
            if (tokenPart.endsWith("\"") && (attrName = this.findAttributeForValue(sup, item)) != null && (attSup = AttributeValueSupport.getSupport(true, elem.getName(), attrName)) != null) {
                return attSup.getResult(component, offset, sup, elem, "");
            }
            if (tokenPart.endsWith(">") && !tokenPart.endsWith("/>")) {
                compItems = sup.getAutocompletedEndTag(offset);
            }
        }
        if (id == JspTagTokenContext.TAG || id == JspTagTokenContext.WHITESPACE || id == JspTagTokenContext.EOL) {
            if (this.isBlank(tokenPart.charAt(tokenPart.length() - 1)) || tokenPart.equals("\n")) {
                removeLength = 0;
                this.addAttributeItems(sup, compItems, elem, sup.getTagAttributes(elem.getName(), ""), null);
            } else {
                int colonIndex = tokenPart.indexOf(":");
                if (colonIndex == -1) {
                    removeLength = tokenPart.length();
                    this.addTagPrefixItems(sup, compItems, sup.getTagPrefixes(tokenPart));
                } else {
                    String prefix = tokenPart.substring(0, colonIndex);
                    removeLength = tokenPart.length();
                    this.addTagPrefixItems(sup, compItems, prefix, sup.getTags(tokenPart), elem);
                }
            }
        }
        if (id == JspTagTokenContext.ATTRIBUTE) {
            if (this.isBlank(tokenPart.charAt(tokenPart.length() - 1))) {
                removeLength = 0;
                this.addAttributeItems(sup, compItems, elem, sup.getTagAttributes(elem.getName(), ""), null);
            } else {
                removeLength = tokenPart.length();
                this.addAttributeItems(sup, compItems, elem, sup.getTagAttributes(elem.getName(), tokenPart), token);
            }
        }
        if (id == JspTagTokenContext.ATTR_VALUE) {
            AttributeValueSupport attSup;
            String valuePart = tokenPart.trim();
            if (valuePart.length() == 0) {
                return this.result(component, offset, new CompletionData(compItems, 0));
            }
            for (item = item.getPrevious(); item != null && item.getTokenID() == JspTagTokenContext.ATTR_VALUE; item = item.getPrevious()) {
                valuePart = item.getImage() + valuePart;
            }
            valuePart = valuePart.substring(1);
            removeLength = valuePart.length();
            String attrName = this.findAttributeForValue(sup, item);
            if (attrName != null && (attSup = AttributeValueSupport.getSupport(true, elem.getName(), attrName)) != null) {
                CompletionQuery.Result result = attSup.getResult(component, offset, sup, elem, valuePart);
                if (!(attSup instanceof AttrSupports.FilenameSupport)) {
                    this.setResultItemsOffset(result.getData(), valuePart.length(), offset);
                }
                return result;
            }
        }
        return this.result(component, offset, new CompletionData(compItems, removeLength));
    }

    protected CompletionData queryJspEndTag(int offset, JspSyntaxSupport sup, SyntaxElement.EndTag elem, BaseDocument doc) throws BadLocationException {
        ArrayList compItems = new ArrayList();
        int removeLength = 0;
        TokenItem item = sup.getItemAtOrBefore(offset);
        if (item == null) {
            return new CompletionData(compItems, 0);
        }
        TokenID id = item.getTokenID();
        String tokenPart = item.getImage().substring(0, offset - item.getOffset());
        removeLength = tokenPart.length();
        return new CompletionData(sup.getPossibleEndTags(offset, tokenPart), removeLength);
    }

    protected CompletionQuery.Result queryEL(JTextComponent component, int offset, JspSyntaxSupport sup, SyntaxElement elem, BaseDocument doc) throws BadLocationException {
        ELExpression elExpr = new ELExpression(sup);
        ArrayList<JspCompletionItem.JspResultItem> complItems = new ArrayList<JspCompletionItem.JspResultItem>();
        switch (elExpr.parse(offset)) {
            case 1: {
                for (ELImplicitObjects.ELImplicitObject implOb : ELImplicitObjects.getELImplicitObjects(elExpr.getReplace())) {
                    complItems.add(new JspCompletionItem.ELImplicitObject(implOb.getName(), implOb.getType()));
                }
                PageInfo.BeanData[] beans = sup.getBeanData();
                if (beans != null) {
                    for (int i = 0; i < beans.length; ++i) {
                        if (!beans[i].getId().startsWith(elExpr.getReplace())) continue;
                        complItems.add(new JspCompletionItem.ELBean(beans[i].getId(), beans[i].getClassName()));
                    }
                }
                List functions = ELFunctions.getFunctions(sup, elExpr.getReplace());
                for (ELFunctions.Function fun : functions) {
                    complItems.add(new JspCompletionItem.ELFunction(fun.getPrefix(), fun.getName(), fun.getReturnType(), fun.getParameters()));
                }
                break;
            }
            case 2: {
                JavaClass bean = elExpr.getBean(elExpr.getExpression());
                Iterator property = elExpr.getProperties(elExpr.getExpression(), bean).iterator();
                while (property.hasNext()) {
                    String name = (String)property.next();
                    if (!name.startsWith(elExpr.getReplace())) continue;
                    complItems.add(new JspCompletionItem.ELProperty(name, (String)property.next()));
                }
                break;
            }
            case 3: {
                List<ELImplicitObjects.Property> properties;
                ELImplicitObjects.ELImplicitObject implObj = ELImplicitObjects.getELImplicitObject(elExpr.getExpression());
                if (implObj == null || (properties = implObj.getPossibbleValues(elExpr.getExpression(), sup)) == null) break;
                for (ELImplicitObjects.Property prop : properties) {
                    if (!prop.getName().startsWith(elExpr.getReplace())) continue;
                    complItems.add(new JspCompletionItem.ELProperty(prop.getName(), prop.getType()));
                }
                break;
            }
        }
        return this.result(component, offset, new CompletionData(complItems, elExpr.getReplace().length()));
    }

    protected CompletionQuery.Result queryJspDirectiveInScriptlet(JTextComponent component, int offset, JspSyntaxSupport sup, SyntaxElement elem, BaseDocument doc) throws BadLocationException {
        ArrayList compItems = new ArrayList();
        TokenItem item = sup.getItemAtOrBefore(offset);
        if (item == null) {
            return this.result(component, offset, new CompletionData(compItems, 0));
        }
        TokenID id = item.getTokenID();
        String tokenPart = item.getImage().substring(0, offset - item.getOffset());
        if (id == JspTagTokenContext.SYMBOL2 && tokenPart.equals("<%")) {
            this.addDirectiveItems(sup, compItems, sup.getDirectives(""));
        }
        return this.result(component, offset, new CompletionData(compItems, 1));
    }

    protected CompletionQuery.Result queryJspDirective(JTextComponent component, int offset, JspSyntaxSupport sup, SyntaxElement.Directive elem, BaseDocument doc) throws BadLocationException {
        ArrayList compItems = new ArrayList();
        int removeLength = 0;
        TokenItem item = sup.getItemAtOrBefore(offset);
        if (item == null) {
            return this.result(component, offset, new CompletionData(compItems, 0));
        }
        TokenID id = item.getTokenID();
        String tokenPart = item.getImage().substring(0, offset - item.getOffset());
        String token = item.getImage().trim();
        if (id.getNumericID() == 4) {
            AttributeValueSupport attSup;
            String attrName;
            if (tokenPart.startsWith("<")) {
                removeLength = tokenPart.length() - 1;
                this.addDirectiveItems(sup, compItems, sup.getDirectives(""));
            }
            if (tokenPart.endsWith("\"") && (attrName = this.findAttributeForValue(sup, item)) != null && (attSup = AttributeValueSupport.getSupport(false, elem.getName(), attrName)) != null) {
                return attSup.getResult(component, offset, sup, elem, "");
            }
        }
        if (id.getNumericID() == 3 || id.getNumericID() == 11 || id.getNumericID() == 9) {
            if (this.isBlank(tokenPart.charAt(tokenPart.length() - 1)) || tokenPart.equals("\n")) {
                TokenItem prevItem = item.getPrevious();
                TokenID prevId = prevItem.getTokenID();
                String prevToken = prevItem.getImage().trim();
                if (prevId.getNumericID() == 3 || prevId.getNumericID() == 8 || prevId.getNumericID() == 11 || prevId.getNumericID() == 9) {
                    removeLength = 0;
                    this.addAttributeItems(sup, compItems, elem, sup.getDirectiveAttributes(elem.getName(), ""), null);
                } else if (prevId.getNumericID() == 4 && prevToken.equals("<%@")) {
                    removeLength = tokenPart.length() + 2;
                    this.addDirectiveItems(sup, compItems, sup.getDirectives(""));
                }
            } else {
                Object directive;
                List list;
                boolean add = true;
                int whitespaceLength = 0;
                TokenItem prevItem = item.getPrevious();
                TokenID prevId = prevItem.getTokenID();
                if (prevId.getNumericID() == 3 && "".equals(prevItem.getImage().trim())) {
                    whitespaceLength = prevItem.getImage().length();
                }
                if ((list = sup.getDirectives(tokenPart)).size() == 1 && (directive = list.get(0)) instanceof TagInfo && ((TagInfo)directive).getTagName().equalsIgnoreCase(tokenPart)) {
                    add = false;
                }
                if (add) {
                    removeLength = whitespaceLength + tokenPart.length() + 2;
                    this.addDirectiveItems(sup, compItems, list);
                }
            }
        }
        if (id.getNumericID() == 7) {
            if (this.isBlank(tokenPart.charAt(tokenPart.length() - 1))) {
                removeLength = 0;
                this.addAttributeItems(sup, compItems, elem, sup.getDirectiveAttributes(elem.getName(), ""), null);
            } else {
                removeLength = tokenPart.length();
                this.addAttributeItems(sup, compItems, elem, sup.getDirectiveAttributes(elem.getName(), tokenPart), token);
            }
        }
        if (id.getNumericID() == 8) {
            AttributeValueSupport attSup;
            String valuePart = tokenPart;
            for (item = item.getPrevious(); item != null && item.getTokenID().getNumericID() == 8; item = item.getPrevious()) {
                valuePart = item.getImage() + valuePart;
            }
            valuePart = valuePart.substring(1);
            removeLength = valuePart.length();
            String attrName = this.findAttributeForValue(sup, item);
            if (attrName != null && (attSup = AttributeValueSupport.getSupport(false, elem.getName(), attrName)) != null) {
                CompletionQuery.Result result = attSup.getResult(component, offset, sup, elem, valuePart);
                if (!(attSup instanceof AttrSupports.FilenameSupport)) {
                    this.setResultItemsOffset(result.getData(), valuePart.length(), offset);
                }
                return result;
            }
        }
        return this.result(component, offset, new CompletionData(compItems, removeLength));
    }

    protected CompletionData queryJspTagInContent(int offset, JspSyntaxSupport sup, BaseDocument doc) throws BadLocationException {
        List compItems = new ArrayList();
        int removeLength = 0;
        TokenItem item = sup.getItemAtOrBefore(offset);
        if (item == null) {
            return new CompletionData(compItems, 0);
        }
        String tokenPart = item.getImage().substring(0, offset - item.getOffset() >= item.getImage().length() ? item.getImage().length() : offset - item.getOffset());
        int ltIndex = tokenPart.lastIndexOf(60);
        if (ltIndex != -1) {
            tokenPart = tokenPart.substring(ltIndex + 1);
        }
        while (ltIndex == -1) {
            if ((item = item.getPrevious()) == null) {
                return new CompletionData(compItems, 0);
            }
            String newImage = item.getImage();
            ltIndex = newImage.lastIndexOf(60);
            tokenPart = ltIndex != -1 ? newImage.substring(ltIndex + 1) + tokenPart : newImage + tokenPart;
            if (tokenPart.length() <= 20) continue;
            return new CompletionData(compItems, 0);
        }
        if (tokenPart.startsWith("/")) {
            tokenPart = tokenPart.substring(1);
            compItems = sup.getPossibleEndTags(offset, tokenPart, true);
        } else {
            this.addTagPrefixItems(sup, compItems, sup.getTagPrefixes(tokenPart));
        }
        removeLength = tokenPart.length();
        return new CompletionData(compItems, removeLength);
    }

    protected CompletionQuery.Result queryJspDirectiveInContent(JTextComponent component, int offset, JspSyntaxSupport sup, BaseDocument doc) throws BadLocationException {
        ArrayList compItems = new ArrayList();
        int removeLength = 0;
        TokenItem item = sup.getItemAtOrBefore(offset);
        if (item == null) {
            return this.result(component, offset, new CompletionData(compItems, 0));
        }
        String tokenPart = item.getImage().substring(0, offset - item.getOffset() >= item.getImage().length() ? item.getImage().length() : offset - item.getOffset());
        if (!tokenPart.equals("<") && !tokenPart.equals("<%")) {
            return this.result(component, offset, new CompletionData(compItems, 0));
        }
        removeLength = "<%".equals(tokenPart) ? 1 : 0;
        this.addDirectiveItems(sup, compItems, sup.getDirectives(""));
        return this.result(component, offset, new CompletionData(compItems, removeLength));
    }

    private boolean isBlank(char c) {
        return c == ' ';
    }

    protected String findAttributeForValue(JspSyntaxSupport sup, TokenItem item) {
        while (item != null && item.getTokenID().getNumericID() == 8) {
            item = item.getPrevious();
        }
        String symbols = "";
        while (item != null && item.getTokenID().getNumericID() == 4) {
            symbols = item.getImage() + symbols;
            item = item.getPrevious();
        }
        if (!sup.isValueBeginning(symbols)) {
            return null;
        }
        String attributeName = "";
        while (item != null && item.getImage().trim().length() == 0) {
            item = item.getPrevious();
        }
        while (item != null && item.getTokenID().getNumericID() == 7) {
            attributeName = item.getImage() + attributeName;
            item = item.getPrevious();
        }
        if (attributeName.trim().length() > 0) {
            return attributeName.trim();
        }
        return null;
    }

    private void addTagPrefixItems(JspSyntaxSupport sup, List compItemList, String prefix, List tagStringItems, SyntaxElement.Tag set) {
        for (int i = 0; i < tagStringItems.size(); ++i) {
            Object item = tagStringItems.get(i);
            if (item instanceof TagInfo) {
                compItemList.add(new JspCompletionItem.PrefixTag(prefix, (TagInfo)item, set));
                continue;
            }
            compItemList.add(new JspCompletionItem.PrefixTag(prefix + ":" + (String)item));
        }
    }

    private void addTagPrefixItems(JspSyntaxSupport sup, List compItemList, List prefixStringItems) {
        for (int i = 0; i < prefixStringItems.size(); ++i) {
            String prefix = (String)prefixStringItems.get(i);
            List tags = sup.getTags(prefix, "");
            for (int j = 0; j < tags.size(); ++j) {
                Object item = tags.get(j);
                if (item instanceof TagInfo) {
                    compItemList.add(new JspCompletionItem.PrefixTag(prefix, (TagInfo)item));
                    continue;
                }
                compItemList.add(new JspCompletionItem.PrefixTag(prefix + ":" + (String)item));
            }
        }
    }

    private void addDirectiveItems(JspSyntaxSupport sup, List compItemList, List directiveStringItems) {
        for (int i = 0; i < directiveStringItems.size(); ++i) {
            Object item = directiveStringItems.get(i);
            if (item instanceof TagInfo) {
                TagInfo ti = (TagInfo)item;
                compItemList.add(new JspCompletionItem.Directive(ti.getTagName(), ti));
                continue;
            }
            compItemList.add(new JspCompletionItem.Directive((String)item));
        }
    }

    private void addAttributeItems(JspSyntaxSupport sup, List compItemList, SyntaxElement.TagDirective tagDir, List attributeItems, String currentAttr) {
        for (int i = 0; i < attributeItems.size(); ++i) {
            Object item = attributeItems.get(i);
            String attr = item instanceof TagAttributeInfo ? ((TagAttributeInfo)item).getName() : (String)item;
            boolean isThere = tagDir.getAttributes().keySet().contains(attr);
            if (isThere && !attr.equalsIgnoreCase(currentAttr) && (currentAttr == null || !attr.startsWith(currentAttr) || attr.length() <= currentAttr.length() || isThere)) continue;
            if (item instanceof TagAttributeInfo) {
                if ("taglib".equalsIgnoreCase(tagDir.getName())) {
                    if (!attr.equalsIgnoreCase("prefix") && (!attr.equalsIgnoreCase("uri") || tagDir.getAttributes().keySet().contains("tagdir")) && (!attr.equalsIgnoreCase("tagdir") || tagDir.getAttributes().keySet().contains("uri"))) continue;
                    compItemList.add(new JspCompletionItem.Attribute((TagAttributeInfo)item));
                    continue;
                }
                compItemList.add(new JspCompletionItem.Attribute((TagAttributeInfo)item));
                continue;
            }
            compItemList.add(new JspCompletionItem.Attribute((String)item));
        }
    }

    private CompletionQuery.Result result(JTextComponent component, int offset, CompletionData complData) {
        this.setResultItemsOffset(complData, offset);
        return new JspCompletionResult(component, NbBundle.getMessage(JSPKit.class, (String)"CTL_JSP_Completion_Title"), complData.completionItems, offset, complData.removeLength, -1);
    }

    static {
        stdXMLEntities.add("&lt;");
        stdXMLEntities.add("&gt;");
        stdXMLEntities.add("&apos;");
        stdXMLEntities.add("&quot;");
        stdXMLEntities.add("&amp;");
    }

    public static class JspJavaCompletionResult
    extends JavaCompletionQuery.JavaResult
    implements SubstituteOffsetProvider {
        private int substituteOffset;

        public JspJavaCompletionResult(JTextComponent component, List data, String title, JCExpression substituteExp, int substituteOffset, int substituteLength, int classDisplayOffset) {
            super(component, data, title, null, substituteOffset, substituteLength, 0);
            this.substituteOffset = substituteOffset;
        }

        public int getSubstituteOffset() {
            return this.substituteOffset;
        }
    }

    public static class JspCompletionResult
    extends CompletionQuery.DefaultResult
    implements SubstituteOffsetProvider {
        private int substituteOffset;

        public JspCompletionResult(JTextComponent component, String title, List data, int offset, int len, int htmlAnchorOffset) {
            super(component, title, data, offset, len);
            this.substituteOffset = htmlAnchorOffset == -1 ? offset - len : htmlAnchorOffset;
        }

        public int getSubstituteOffset() {
            return this.substituteOffset;
        }
    }

    static interface SubstituteOffsetProvider {
        public int getSubstituteOffset();
    }

    public static class CompletionData {
        public List completionItems;
        public int removeLength;

        public CompletionData(List items, int length) {
            this.completionItems = items;
            this.removeLength = length;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("------ completion items, remove " + this.removeLength + " : ----------\n");
            for (int i = 0; i < this.completionItems.size(); ++i) {
                CompletionQuery.DefaultResultItem item = (CompletionQuery.DefaultResultItem)this.completionItems.get(i);
                sb.append(item.getItemText());
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

