/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.fileupload;

import com.sun.javaee.blueprints.components.ui.fileupload.FileUploadStatus;
import java.io.IOException;
import javax.servlet.ServletInputStream;

public class MonitoredServletInputStream
extends ServletInputStream {
    private ServletInputStream servletInputStream = null;
    private FileUploadStatus status = null;

    public MonitoredServletInputStream(ServletInputStream sis, FileUploadStatus status) {
        this.servletInputStream = sis;
        this.status = status;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        int iRet = this.servletInputStream.readLine(b, off, len);
        this.status.incrementCurrentSizeRead(iRet);
        return iRet;
    }

    public int read() throws IOException {
        int iRet = this.servletInputStream.read();
        this.status.incrementCurrentSizeRead(iRet);
        return iRet;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int iRet = this.servletInputStream.read(b, off, len);
        this.status.incrementCurrentSizeRead(iRet);
        return iRet;
    }

    public long skip(long n) throws IOException {
        return this.servletInputStream.skip(n);
    }

    public int available() throws IOException {
        return this.servletInputStream.available();
    }

    public void close() throws IOException {
        this.servletInputStream.close();
    }

    public void mark(int readlimit) {
        this.servletInputStream.mark(readlimit);
    }

    public void reset() throws IOException {
        this.servletInputStream.reset();
    }

    public boolean markSupported() {
        return this.servletInputStream.markSupported();
    }
}

