/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.ide.JBLogWriter;
import org.netbeans.modules.j2ee.jboss4.ide.JBStartServer;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.openide.ErrorManager;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

class JBStartRunnable
implements Runnable {
    private static final String STARTUP_SH = "/bin/run.sh";
    private static final String STARTUP_BAT = "/bin/run.bat";
    private JBDeploymentManager dm;
    private String instanceName;
    private JBStartServer startServer;
    private ProfilerServerSettings profilerSettings;

    JBStartRunnable(ProfilerServerSettings profilerSettings, JBDeploymentManager dm, JBStartServer startServer) {
        this.dm = dm;
        this.instanceName = dm.getInstanceProperties().getProperty("displayName");
        this.startServer = startServer;
        this.profilerSettings = profilerSettings;
    }

    public void run() {
        InstanceProperties ip = this.dm.getInstanceProperties();
        boolean free = this.checkPorts(ip);
        if (!free) {
            return;
        }
        Process serverProcess = this.createProcess(ip);
        if (serverProcess == null) {
            return;
        }
        JBLogWriter logWriter = this.createLogWriter();
        this.waitForServerToStart(logWriter, serverProcess);
    }

    private String[] createEnvironment(InstanceProperties ip) {
        JBProperties properties = this.dm.getProperties();
        String javaOpts = properties.getJavaOpts();
        StringBuilder javaOptsBuilder = new StringBuilder(javaOpts);
        if (properties.getProxyEnabled()) {
            String[] PROXY_PROPS;
            for (String prop : PROXY_PROPS = new String[]{"http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"}) {
                String value;
                if (javaOpts.indexOf(prop) != -1 || (value = System.getProperty(prop)) == null) continue;
                if ("http.nonProxyHosts".equals(prop)) {
                    try {
                        BufferedReader br = new BufferedReader(new StringReader(value));
                        String line = null;
                        StringBuilder noNL = new StringBuilder();
                        while ((line = br.readLine()) != null) {
                            noNL.append(line);
                        }
                        value = noNL.toString();
                        value = "\"" + value + "\"";
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().annotate((Throwable)ioe, NbBundle.getMessage(JBStartRunnable.class, (String)"ERR_NonProxyHostParsingError"));
                        ErrorManager.getDefault().notify(4096, (Throwable)ioe);
                        value = null;
                    }
                }
                if (value == null) continue;
                javaOptsBuilder.append(" -D").append(prop).append("=").append(value);
            }
        }
        if (this.startServer.getMode() == JBStartServer.MODE.DEBUG && javaOptsBuilder.toString().indexOf("-Xdebug") == -1) {
            javaOptsBuilder.append(" -classic -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,address=").append(this.dm.getDebuggingPort()).append(",server=y,suspend=n");
        } else if (this.startServer.getMode() == JBStartServer.MODE.PROFILE) {
            String[] profJvmArgs = this.profilerSettings.getJvmArgs();
            for (int i = 0; i < profJvmArgs.length; ++i) {
                javaOptsBuilder.append(" ").append(profJvmArgs[i]);
            }
        }
        javaOpts = javaOptsBuilder.toString();
        JavaPlatform platform = this.startServer.getMode() != JBStartServer.MODE.PROFILE ? properties.getJavaPlatform() : this.profilerSettings.getJavaPlatform();
        String javaHome = JBStartRunnable.getJavaHome(platform);
        String[] envp = new String[]{"JAVA=" + javaHome + "/bin/java", "JAVA_HOME=" + javaHome, "JAVA_OPTS=" + javaOpts};
        return envp;
    }

    private boolean checkPorts(InstanceProperties ip) {
        try {
            String strRMIInvokerPort;
            int RMIInvokerPort;
            String serverName = ip.getProperty("displayName");
            String strHTTPConnectorPort = ip.getProperty("port");
            int HTTPConnectorPort = new Integer(strHTTPConnectorPort);
            if (!JBPluginUtils.isPortFree(HTTPConnectorPort)) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_HTTP_PORT_IN_USE", strHTTPConnectorPort));
                return false;
            }
            String serverDir = ip.getProperty("server-dir");
            String strJNPServicePort = JBPluginUtils.getJnpPort(serverDir);
            int JNPServicePort = new Integer(strJNPServicePort);
            if (!JBPluginUtils.isPortFree(JNPServicePort)) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_JNP_PORT_IN_USE", strJNPServicePort));
                return false;
            }
            String strRMINamingServicePort = JBPluginUtils.getRMINamingServicePort(serverDir);
            int RMINamingServicePort = new Integer(strRMINamingServicePort);
            if (!JBPluginUtils.isPortFree(RMINamingServicePort)) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_RMI_PORT_IN_USE", strRMINamingServicePort));
                return false;
            }
            String server = ip.getProperty("server");
            if (!"minimal".equals(server) && !JBPluginUtils.isPortFree(RMIInvokerPort = new Integer(strRMIInvokerPort = JBPluginUtils.getRMIInvokerPort(serverDir)).intValue())) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_INVOKER_PORT_IN_USE", strRMIInvokerPort));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return true;
    }

    private NbProcessDescriptor createProcessDescriptor(InstanceProperties ip) {
        String serverLocation = ip.getProperty("root-dir");
        String serverRunFileName = serverLocation + (Utilities.isWindows() ? STARTUP_BAT : STARTUP_SH);
        if (!new File(serverRunFileName).exists()) {
            String serverName = ip.getProperty("displayName");
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_FNF"));
            return null;
        }
        String instanceName = ip.getProperty("server");
        String args = ("all".equals(instanceName) ? "-b 127.0.0.1 " : "") + "-c " + instanceName;
        return new NbProcessDescriptor(serverRunFileName, args);
    }

    private static String getJavaHome(JavaPlatform platform) {
        FileObject fo = (FileObject)platform.getInstallFolders().iterator().next();
        return FileUtil.toFile((FileObject)fo).getAbsolutePath();
    }

    private String createProgressMessage(String resName) {
        return this.createProgressMessage(resName, null);
    }

    private String createProgressMessage(String resName, String param) {
        return NbBundle.getMessage(JBStartRunnable.class, (String)resName, (Object)this.instanceName, (Object)param);
    }

    private Process createProcess(InstanceProperties ip) {
        NbProcessDescriptor pd;
        JBLogWriter logWriter;
        if (this.startServer.getMode() == JBStartServer.MODE.PROFILE && (logWriter = JBLogWriter.getInstance(this.instanceName)) != null && logWriter.isRunning()) {
            logWriter.stop();
        }
        if ((pd = this.createProcessDescriptor(ip)) == null) {
            return null;
        }
        String[] envp = this.createEnvironment(ip);
        try {
            return pd.exec(null, envp, true, null);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
            String serverLocation = ip.getProperty("root-dir");
            String serverRunFileName = serverLocation + (Utilities.isWindows() ? STARTUP_BAT : STARTUP_SH);
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_PD", serverRunFileName));
            return null;
        }
    }

    private InputOutput openConsole() {
        InputOutput io = UISupport.getServerIO((String)this.dm.getUrl());
        if (io == null) {
            return null;
        }
        try {
            io.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        io.select();
        return io;
    }

    private void fireStartProgressEvent(StateType stateType, String msg) {
        this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.START, stateType, msg));
    }

    private JBLogWriter createLogWriter() {
        InputOutput io = this.openConsole();
        return JBLogWriter.createInstance(io, this.instanceName);
    }

    private void waitForServerToStart(JBLogWriter logWriter, Process serverProcess) {
        this.fireStartProgressEvent(StateType.RUNNING, this.createProgressMessage("MSG_START_SERVER_IN_PROGRESS"));
        JBStartServer.ACTION_STATUS status = logWriter.start(serverProcess, this.startServer);
        if (status == JBStartServer.ACTION_STATUS.SUCCESS) {
            this.fireStartProgressEvent(StateType.COMPLETED, this.createProgressMessage("MSG_SERVER_STARTED"));
        } else if (status == JBStartServer.ACTION_STATUS.FAILURE) {
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED"));
        } else if (status == JBStartServer.ACTION_STATUS.UNKNOWN) {
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_StartServerTimeout"));
        }
    }
}

