/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.balancer.rules;

import javax.servlet.http.HttpServletRequest;
import org.apache.webapp.balancer.rules.BaseRule;

public class URLStringMatchRule
extends BaseRule {
    private String targetString;

    public void setTargetString(String theTargetString) {
        if (theTargetString == null) {
            throw new IllegalArgumentException("The target string cannot be null.");
        }
        this.targetString = theTargetString;
    }

    protected String getTargetString() {
        return this.targetString;
    }

    public boolean matches(HttpServletRequest request) {
        String requestUrl = request.getRequestURL().toString();
        int index = requestUrl.indexOf(this.getTargetString());
        return index > -1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.getClass().getName());
        buffer.append(": ");
        buffer.append("Target string: ");
        buffer.append(this.getTargetString());
        buffer.append(" / ");
        buffer.append("Redirect URL: ");
        buffer.append(this.getRedirectUrl());
        buffer.append("]");
        return buffer.toString();
    }
}

