/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.nodes;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.ddl.impl.CreateIndex;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.DropIndex;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.infos.ColumnNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.IndexNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class IndexNode
extends DatabaseNode {
    protected void createPasteTypes(Transferable t, List s) {
        ColumnNodeInfo nfo;
        super.createPasteTypes(t, s);
        Node node = NodeTransfer.node((Transferable)t, (int)6);
        if (node != null && (nfo = (ColumnNodeInfo)node.getCookie(ColumnNodeInfo.class)) != null) {
            s.add(new IndexPasteType(nfo, null));
        }
    }

    public String getShortDescription() {
        return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ND_Index");
    }

    class IndexPasteType
    extends PasteType {
        private DatabaseNodeInfo info;
        private Node node;

        public IndexPasteType(ColumnNodeInfo info, Node node) {
            this.info = info;
            this.node = node;
        }

        public String getName() {
            return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("IndexPasteTypeName");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Transferable paste() throws IOException {
            IndexNodeInfo destinfo = (IndexNodeInfo)IndexNode.this.getInfo();
            if (this.info == null) throw new IOException(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_CannotFindIndexOwnerInformation"));
            try {
                Specification spec = (Specification)this.info.getSpecification();
                DriverSpecification drvSpec = this.info.getDriverSpecification();
                drvSpec.getIndexInfo(this.info.getTable(), false, true);
                ResultSet rs = drvSpec.getResultSet();
                if (rs == null) return null;
                String index = destinfo.getName();
                HashSet<String> ixrm = new HashSet<String>();
                HashMap rset = new HashMap();
                while (rs.next()) {
                    rset = drvSpec.getRow();
                    String ixname = (String)rset.get(new Integer(6));
                    String colname = (String)rset.get(new Integer(9));
                    if (ixname.equals(index)) {
                        ixrm.add(colname);
                    }
                    rset.clear();
                }
                rs.close();
                if (ixrm.contains(this.info.getName())) {
                    String message = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_IndexContainsColumn"), index, this.info.getName());
                    throw new IOException(message);
                }
                CreateIndex icmd = spec.createCommandCreateIndex(this.info.getTable());
                icmd.setIndexName(destinfo.getName());
                Iterator enu = ixrm.iterator();
                while (enu.hasNext()) {
                    icmd.specifyColumn((String)enu.next());
                }
                icmd.specifyColumn(this.info.getName());
                DropIndex dicmd = spec.createCommandDropIndex(index);
                dicmd.setObjectOwner((String)destinfo.get("schema"));
                dicmd.execute();
                icmd.setObjectOwner((String)destinfo.get("schema"));
                icmd.execute();
                drvSpec.getIndexInfo(destinfo.getTable(), false, true);
                rs = drvSpec.getResultSet();
                if (rs == null) return null;
                while (rs.next()) {
                    rset = drvSpec.getRow();
                    String ixname = (String)rset.get(new Integer(6));
                    String colname = (String)rset.get(new Integer(9));
                    if (ixname.equals(index) && colname.equals(this.info.getName())) {
                        IndexNodeInfo ixinfo = (IndexNodeInfo)DatabaseNodeInfo.createNodeInfo(destinfo, "index", rset);
                        if (ixinfo == null) throw new Exception(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_UnableToCreateIndexNodeInfo"));
                        ((DatabaseNodeChildren)destinfo.getNode().getChildren()).createSubnode(ixinfo, true);
                    }
                    rset.clear();
                }
                rs.close();
                return null;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

