/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.ant.freeform.FreeformProjectGenerator;
import org.netbeans.modules.ant.freeform.Util;
import org.netbeans.modules.ant.freeform.spi.ProjectPropertiesPanel;
import org.netbeans.modules.ant.freeform.spi.TargetDescriptor;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TargetMappingPanel
extends JPanel
implements ActionListener,
HelpCtx.Provider {
    public static String BUILD_ACTION;
    public static String CLEAN_ACTION;
    public static String REBUILD_ACTION;
    public static String JAVADOC_ACTION;
    public static String RUN_ACTION;
    public static String TEST_ACTION;
    private static List DEFAULT_BUILD_TARGETS;
    private static List DEFAULT_CLEAN_TARGETS;
    private static List DEFAULT_REBUILD_TARGETS;
    private static List DEFAULT_JAVADOC_TARGETS;
    private static List DEFAULT_RUN_TARGETS;
    private static List DEFAULT_TEST_TARGETS;
    private List targetNames;
    private List targetMappings;
    private List custTargets;
    private CustomTargetsModel customTargetsModel;
    private String antScript;
    private ArrayList combos = new ArrayList();
    private ArrayList targetDescs = new ArrayList();
    private boolean dirtyRegular;
    private boolean dirtyCustom;
    private AntProjectHelper helper;
    private JButton add;
    private JLabel additionalTargetsLabel;
    private JComboBox buildCombo;
    private JLabel buildLabel;
    private JComboBox cleanCombo;
    private JLabel cleanLabel;
    private JTable customTargets;
    private JScrollPane jScrollPane1;
    private JComboBox javadocCombo;
    private JLabel javadocLabel;
    private JLabel mainLabel;
    private JPanel remainder;
    private JButton remove;
    private JComboBox runCombo;
    private JLabel runLabel;
    private JPanel specialRemainder;
    private JPanel targetsPanel;
    private JComboBox testCombo;
    private JLabel testLabel;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$String;

    public TargetMappingPanel(boolean advancedPart) {
        this(new ArrayList(), advancedPart);
    }

    public TargetMappingPanel(List extraTargets, boolean advancedPart) {
        this.initComponents();
        this.targetMappings = new ArrayList();
        this.custTargets = new ArrayList();
        this.customTargetsModel = new CustomTargetsModel();
        this.customTargets.setModel(this.customTargetsModel);
        this.customTargets.getTableHeader().setReorderingAllowed(false);
        this.addTargets(extraTargets);
        this.showAdvancedPart(advancedPart);
    }

    public TargetMappingPanel(List extraTargets, PropertyEvaluator evaluator, AntProjectHelper helper) {
        this(extraTargets, true);
        this.helper = helper;
        FileObject as = FreeformProjectGenerator.getAntScript(helper, evaluator);
        List l = null;
        if (as != null) {
            l = Util.getAntScriptTargetNames(as);
        }
        if (l != null) {
            this.setTargetNames(l, false);
            this.initAntTargetEditor(l);
        }
        this.antScript = TargetMappingPanel.defaultAntScript(evaluator);
        this.initMappings(FreeformProjectGenerator.getTargetMappings(helper), this.antScript);
        this.custTargets = FreeformProjectGenerator.getCustomContextMenuActions(helper);
        this.customTargetsModel.fireTableDataChanged();
        this.updateButtons();
    }

    static String defaultAntScript(PropertyEvaluator evaluator) {
        String antScript = evaluator.getProperty("ant.script");
        if (antScript == null) {
            return null;
        }
        return "${ant.script}";
    }

    private void addTargets(List extraTargets) {
        this.combos.add(this.buildCombo);
        this.targetDescs.add(new TargetDescriptor(BUILD_ACTION, DEFAULT_BUILD_TARGETS, null, null));
        this.combos.add(this.cleanCombo);
        this.targetDescs.add(new TargetDescriptor(CLEAN_ACTION, DEFAULT_CLEAN_TARGETS, null, null));
        this.combos.add(this.javadocCombo);
        this.targetDescs.add(new TargetDescriptor(JAVADOC_ACTION, DEFAULT_JAVADOC_TARGETS, null, null));
        this.combos.add(this.runCombo);
        this.targetDescs.add(new TargetDescriptor(RUN_ACTION, DEFAULT_RUN_TARGETS, null, null));
        this.combos.add(this.testCombo);
        this.targetDescs.add(new TargetDescriptor(TEST_ACTION, DEFAULT_TEST_TARGETS, null, null));
        int y = 5;
        Iterator it = extraTargets.iterator();
        while (it.hasNext()) {
            TargetDescriptor desc = (TargetDescriptor)it.next();
            this.targetDescs.add(desc);
            JComboBox combo = new JComboBox();
            combo.setEditable(true);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 6, 0);
            this.targetsPanel.add(combo, gridBagConstraints);
            JLabel label = new JLabel();
            label.setLabelFor(combo);
            Mnemonics.setLocalizedText((JLabel)label, (String)desc.getIDEActionLabel());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = y++;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 6, 6);
            this.targetsPanel.add((Component)label, gridBagConstraints);
            label.getAccessibleContext().setAccessibleDescription(desc.getAccessibleLabel());
            this.combos.add(combo);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TargetMappingPanel.class);
    }

    private void showAdvancedPart(boolean show) {
        this.additionalTargetsLabel.setVisible(show);
        this.jScrollPane1.setVisible(show);
        this.customTargets.setVisible(show);
        this.add.setVisible(show);
        this.remove.setVisible(show);
        this.remainder.setVisible(show);
        this.specialRemainder.setVisible(!show);
    }

    private void initAntTargetEditor(List targets) {
        JComboBox<String> combo = new JComboBox<String>();
        combo.setEditable(true);
        Iterator it = targets.iterator();
        while (it.hasNext()) {
            String target = (String)it.next();
            combo.addItem(target);
        }
        this.customTargets.setDefaultEditor(JComboBox.class, new DefaultCellEditor(combo));
    }

    private FreeformProjectGenerator.CustomTarget getItem(int index) {
        return (FreeformProjectGenerator.CustomTarget)this.custTargets.get(index);
    }

    public void setTargetNames(List list, boolean selectDefaults) {
        this.targetNames = list;
        this.targetNames.add(0, "");
        this.updateCombos(selectDefaults);
    }

    public void setScript(String script) {
        this.antScript = script;
        Iterator it = this.targetMappings.iterator();
        while (it.hasNext()) {
            FreeformProjectGenerator.TargetMapping tm = (FreeformProjectGenerator.TargetMapping)it.next();
            tm.script = script;
        }
    }

    private void updateCombos(boolean selectDefaults) {
        Iterator it = this.combos.iterator();
        Iterator it3 = this.targetDescs.iterator();
        while (it.hasNext()) {
            JComboBox combo = (JComboBox)it.next();
            TargetDescriptor desc = (TargetDescriptor)it3.next();
            combo.removeAllItems();
            Iterator it2 = this.targetNames.iterator();
            while (it2.hasNext()) {
                String name = (String)it2.next();
                combo.addItem(name);
            }
            if (!selectDefaults) continue;
            this.selectItem(combo, desc.getDefaultTargets(), false);
        }
    }

    private void selectItem(JComboBox combo, List items, boolean add) {
        ComboBoxModel model = combo.getModel();
        Iterator it = items.iterator();
        while (it.hasNext()) {
            String item = (String)it.next();
            Pattern pattern = Pattern.compile(item);
            for (int i = 0; i < model.getSize(); ++i) {
                String target = (String)model.getElementAt(i);
                Matcher matcher = pattern.matcher(target);
                if (!matcher.matches()) continue;
                model.setSelectedItem(target);
                return;
            }
        }
        if (add) {
            if (!$assertionsDisabled && items.size() != 1) {
                throw new AssertionError((Object)"There should be only one item in this case");
            }
            combo.addItem(items.get(0));
            model.setSelectedItem(items.get(0));
        } else {
            model.setSelectedItem("");
        }
    }

    private void initMappings(List list, String antScript) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            FreeformProjectGenerator.TargetMapping tm = (FreeformProjectGenerator.TargetMapping)it.next();
            Iterator it2 = this.targetDescs.iterator();
            Iterator it3 = this.combos.iterator();
            while (it2.hasNext()) {
                TargetDescriptor desc = (TargetDescriptor)it2.next();
                if (!$assertionsDisabled && !it3.hasNext()) {
                    throw new AssertionError();
                }
                JComboBox combo = (JComboBox)it3.next();
                if (!tm.name.equals(desc.getIDEActionName())) continue;
                this.selectItem(combo, Collections.singletonList(TargetMappingPanel.getListAsString(tm.targets)), true);
                this.checkAntScript(combo, antScript, tm.script);
            }
        }
        this.targetMappings = list;
    }

    private void checkAntScript(JComboBox combo, String antScript, String targetScript) {
        if (antScript == null && targetScript == null || antScript != null && antScript.equals(targetScript)) {
            combo.setEnabled(true);
        } else {
            combo.setEnabled(false);
        }
    }

    private static String getListAsString(List list) {
        if (!$assertionsDisabled && list == null) {
            throw new AssertionError();
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    static List getStringAsList(String str) {
        ArrayList<String> l = new ArrayList<String>(2);
        StringTokenizer tok = new StringTokenizer(str, " ");
        while (tok.hasMoreTokens()) {
            String target = tok.nextToken().trim();
            if (target.length() == 0) continue;
            l.add(target);
        }
        return l;
    }

    private void storeTarget(String key, JComboBox combo) {
        if (combo.getModel().getSelectedItem() == null || ((String)combo.getModel().getSelectedItem()).length() == 0) {
            this.removeTargetMapping(key);
            return;
        }
        FreeformProjectGenerator.TargetMapping tm = this.getTargetMapping(key);
        String value = (String)combo.getModel().getSelectedItem();
        List l = TargetMappingPanel.getStringAsList(value);
        if (!((Object)l).equals(tm.targets)) {
            this.dirtyRegular = true;
        }
        tm.targets = l;
    }

    private FreeformProjectGenerator.TargetMapping getTargetMapping(String key) {
        FreeformProjectGenerator.TargetMapping tm;
        Iterator it = this.targetMappings.iterator();
        while (it.hasNext()) {
            tm = (FreeformProjectGenerator.TargetMapping)it.next();
            if (!tm.name.equals(key)) continue;
            return tm;
        }
        tm = new FreeformProjectGenerator.TargetMapping();
        tm.name = key;
        tm.script = this.antScript;
        this.targetMappings.add(tm);
        this.dirtyRegular = true;
        return tm;
    }

    private void removeTargetMapping(String key) {
        Iterator it = this.targetMappings.iterator();
        while (it.hasNext()) {
            FreeformProjectGenerator.TargetMapping tm = (FreeformProjectGenerator.TargetMapping)it.next();
            if (!tm.name.equals(key)) continue;
            it.remove();
            this.dirtyRegular = true;
            return;
        }
    }

    public List getMapping() {
        Iterator it2 = this.targetDescs.iterator();
        Iterator it3 = this.combos.iterator();
        while (it2.hasNext()) {
            TargetDescriptor desc = (TargetDescriptor)it2.next();
            JComboBox combo = (JComboBox)it3.next();
            this.storeTarget(desc.getIDEActionName(), combo);
        }
        if (this.cleanCombo.getModel().getSelectedItem() != null && ((String)this.cleanCombo.getModel().getSelectedItem()).length() > 0 && this.buildCombo.getModel().getSelectedItem() != null && ((String)this.buildCombo.getModel().getSelectedItem()).length() > 0) {
            FreeformProjectGenerator.TargetMapping tm = this.getTargetMapping(REBUILD_ACTION);
            String val = (String)this.cleanCombo.getModel().getSelectedItem() + " " + (String)this.buildCombo.getModel().getSelectedItem();
            tm.targets = TargetMappingPanel.getStringAsList(val);
        } else {
            this.removeTargetMapping(REBUILD_ACTION);
        }
        return this.targetMappings;
    }

    private void initComponents() {
        this.mainLabel = new JLabel();
        this.additionalTargetsLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.customTargets = new JTable();
        this.add = new JButton();
        this.remove = new JButton();
        this.remainder = new JPanel();
        this.targetsPanel = new JPanel();
        this.buildLabel = new JLabel();
        this.cleanLabel = new JLabel();
        this.runLabel = new JLabel();
        this.javadocLabel = new JLabel();
        this.testLabel = new JLabel();
        this.buildCombo = new JComboBox();
        this.cleanCombo = new JComboBox();
        this.javadocCombo = new JComboBox();
        this.runCombo = new JComboBox();
        this.testCombo = new JComboBox();
        this.specialRemainder = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(300, 280));
        this.mainLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.mainLabel, (String)NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.mainLabel, gridBagConstraints);
        this.mainLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel1"));
        this.additionalTargetsLabel.setLabelFor(this.customTargets);
        Mnemonics.setLocalizedText((JLabel)this.additionalTargetsLabel, (String)NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel10"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.additionalTargetsLabel, gridBagConstraints);
        this.additionalTargetsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel10"));
        this.jScrollPane1.setViewportView(this.customTargets);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.add, (String)NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"BTN_TargetMappingPanel_add"));
        this.add.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.add, gridBagConstraints);
        this.add.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_add"));
        Mnemonics.setLocalizedText((AbstractButton)this.remove, (String)NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"BTN_TargetMappingPanel_remove"));
        this.remove.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.remove, gridBagConstraints);
        this.remove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_remove"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.remainder, gridBagConstraints);
        this.targetsPanel.setLayout(new GridBagLayout());
        this.buildLabel.setLabelFor(this.buildCombo);
        Mnemonics.setLocalizedText((JLabel)this.buildLabel, (String)NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.buildLabel, gridBagConstraints);
        this.buildLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel2"));
        this.cleanLabel.setLabelFor(this.cleanCombo);
        Mnemonics.setLocalizedText((JLabel)this.cleanLabel, (String)NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel4"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.cleanLabel, gridBagConstraints);
        this.cleanLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel4"));
        this.runLabel.setLabelFor(this.runCombo);
        Mnemonics.setLocalizedText((JLabel)this.runLabel, (String)NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.runLabel, gridBagConstraints);
        this.runLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel5"));
        this.javadocLabel.setLabelFor(this.javadocCombo);
        Mnemonics.setLocalizedText((JLabel)this.javadocLabel, (String)NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel6"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.javadocLabel, gridBagConstraints);
        this.javadocLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel6"));
        this.testLabel.setLabelFor(this.testCombo);
        Mnemonics.setLocalizedText((JLabel)this.testLabel, (String)NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel7"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.testLabel, gridBagConstraints);
        this.testLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel7"));
        this.buildCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.buildCombo, gridBagConstraints);
        this.cleanCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.cleanCombo, gridBagConstraints);
        this.javadocCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.javadocCombo, gridBagConstraints);
        this.runCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.runCombo, gridBagConstraints);
        this.testCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.testCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.targetsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.specialRemainder, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.add) {
            this.addActionPerformed(evt);
        } else if (evt.getSource() == this.remove) {
            this.removeActionPerformed(evt);
        }
    }

    private void removeActionPerformed(ActionEvent evt) {
        int index = this.customTargets.getSelectedRow();
        if (index == -1) {
            return;
        }
        this.custTargets.remove(index);
        this.customTargetsModel.fireTableDataChanged();
        this.dirtyCustom = true;
        this.updateButtons();
    }

    private void addActionPerformed(ActionEvent evt) {
        FreeformProjectGenerator.CustomTarget ct = new FreeformProjectGenerator.CustomTarget();
        ct.targets = new ArrayList();
        ct.script = this.antScript;
        this.custTargets.add(ct);
        this.customTargetsModel.fireTableDataChanged();
        this.dirtyCustom = true;
        this.updateButtons();
    }

    private void updateButtons() {
        this.remove.setEnabled(this.custTargets.size() > 0);
    }

    public static void main(String[] ignore) {
        boolean[] adv = new boolean[]{false, true};
        for (int j = 0; j < adv.length; ++j) {
            JDialog dlg = new JDialog((Frame)null, "advancedMode=" + adv[j], false);
            dlg.setDefaultCloseOperation(2);
            TargetMappingPanel panel = new TargetMappingPanel(adv[j]);
            panel.setTargetNames(new ArrayList<String>(Arrays.asList("build", "clean", "test")), true);
            dlg.getContentPane().add(panel);
            dlg.pack();
            dlg.setSize(700, 500);
            dlg.setVisible(true);
        }
    }

    static {
        $assertionsDisabled = !TargetMappingPanel.class.desiredAssertionStatus();
        BUILD_ACTION = "build";
        CLEAN_ACTION = "clean";
        REBUILD_ACTION = "rebuild";
        JAVADOC_ACTION = "javadoc";
        RUN_ACTION = "run";
        TEST_ACTION = "test";
        DEFAULT_BUILD_TARGETS = Arrays.asList("build", "compile", "jar", "dist", "all", ".*jar.*");
        DEFAULT_CLEAN_TARGETS = Arrays.asList("clean", ".*clean.*");
        DEFAULT_REBUILD_TARGETS = Arrays.asList("rebuild", ".*rebuild.*");
        DEFAULT_JAVADOC_TARGETS = Arrays.asList("javadoc", "javadocs", "docs", "doc", ".*javadoc.*", ".*doc.*");
        DEFAULT_RUN_TARGETS = Arrays.asList("run", "start", ".*run.*", ".*start.*");
        DEFAULT_TEST_TARGETS = Arrays.asList("test", ".*test.*");
    }

    private class CustomTargetsModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return NbBundle.getMessage((Class)(class$org$netbeans$modules$ant$freeform$ui$TargetMappingPanel == null ? (class$org$netbeans$modules$ant$freeform$ui$TargetMappingPanel = TargetMappingPanel.class$("org.netbeans.modules.ant.freeform.ui.TargetMappingPanel")) : class$org$netbeans$modules$ant$freeform$ui$TargetMappingPanel), (String)"LBL_TargetMappingPanel_Target");
                }
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$ant$freeform$ui$TargetMappingPanel == null ? (class$org$netbeans$modules$ant$freeform$ui$TargetMappingPanel = TargetMappingPanel.class$("org.netbeans.modules.ant.freeform.ui.TargetMappingPanel")) : class$org$netbeans$modules$ant$freeform$ui$TargetMappingPanel), (String)"LBL_TargetMappingPanel_Label");
        }

        public int getRowCount() {
            return TargetMappingPanel.this.custTargets.size();
        }

        public boolean isCellEditable(int row, int column) {
            if (column == 0) {
                FreeformProjectGenerator.CustomTarget ct = TargetMappingPanel.this.getItem(row);
                if (ct.targets != null && ct.targets.size() > 1) {
                    return false;
                }
                return TargetMappingPanel.this.antScript == null && ct.script == null || TargetMappingPanel.this.antScript != null && TargetMappingPanel.this.antScript.equals(ct.script);
            }
            return true;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return class$javax$swing$JComboBox == null ? (class$javax$swing$JComboBox = TargetMappingPanel.class$("javax.swing.JComboBox")) : class$javax$swing$JComboBox;
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = TargetMappingPanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (TargetMappingPanel.this.getItem(rowIndex) == null || ((TargetMappingPanel)TargetMappingPanel.this).getItem((int)rowIndex).targets == null) {
                    return "";
                }
                return TargetMappingPanel.getListAsString(((TargetMappingPanel)TargetMappingPanel.this).getItem((int)rowIndex).targets);
            }
            return ((TargetMappingPanel)TargetMappingPanel.this).getItem((int)rowIndex).label;
        }

        public void setValueAt(Object val, int rowIndex, int columnIndex) {
            if (rowIndex >= TargetMappingPanel.this.custTargets.size()) {
                return;
            }
            FreeformProjectGenerator.CustomTarget ct = TargetMappingPanel.this.getItem(rowIndex);
            if (columnIndex == 0) {
                ct.targets = ((String)val).length() > 0 ? Collections.singletonList(val) : null;
            } else {
                ct.label = (String)val;
            }
            TargetMappingPanel.this.dirtyCustom = true;
        }
    }

    public static class Panel
    implements ProjectPropertiesPanel {
        private List extraTargets;
        private PropertyEvaluator evaluator;
        private AntProjectHelper helper;
        private TargetMappingPanel panel;

        public Panel(List extraTargets, PropertyEvaluator evaluator, AntProjectHelper helper) {
            this.helper = helper;
            this.extraTargets = extraTargets;
            this.evaluator = evaluator;
        }

        public void storeValues() {
            if (this.panel == null) {
                return;
            }
            List mapping = this.panel.getMapping();
            if (this.panel.dirtyRegular) {
                FreeformProjectGenerator.putTargetMappings(this.helper, mapping);
                FreeformProjectGenerator.putContextMenuAction(this.helper, mapping);
            }
            if (this.panel.dirtyCustom) {
                ArrayList l = new ArrayList(this.panel.custTargets);
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    FreeformProjectGenerator.CustomTarget ct = (FreeformProjectGenerator.CustomTarget)it.next();
                    if (ct.targets == null || ct.targets.size() == 0) {
                        it.remove();
                        continue;
                    }
                    if (ct.label != null && ct.label.length() != 0) continue;
                    ct.label = (String)ct.targets.get(0);
                }
                FreeformProjectGenerator.putCustomContextMenuActions(this.helper, l);
            }
        }

        public String getDisplayName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$ant$freeform$ui$TargetMappingPanel == null ? (class$org$netbeans$modules$ant$freeform$ui$TargetMappingPanel = TargetMappingPanel.class$("org.netbeans.modules.ant.freeform.ui.TargetMappingPanel")) : class$org$netbeans$modules$ant$freeform$ui$TargetMappingPanel), (String)"LBL_ProjectCustomizer_Category_Targets");
        }

        public JComponent getComponent() {
            if (this.panel == null) {
                this.panel = new TargetMappingPanel(this.extraTargets, this.evaluator, this.helper);
            }
            return this.panel;
        }

        public int getPreferredPosition() {
            return 1000;
        }
    }
}

