/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerTarget;
import org.netbeans.modules.j2ee.deployment.impl.ui.FilterXNode;
import org.netbeans.modules.j2ee.deployment.impl.ui.ServerRegistryNode;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class InstanceTargetXNode
extends FilterXNode
implements ServerInstance.StateListener {
    private ServerTarget instanceTarget;
    private ServerInstance instance;
    private InstanceProperties instanceProperties;
    private InstanceTargetChildren instanceTargetChildren;

    public InstanceTargetXNode(Node instanceNode, ServerInstance instance) {
        this(instanceNode, Node.EMPTY, new InstanceTargetChildren(Node.EMPTY));
        this.instance = instance;
        this.instanceProperties = instance.getInstanceProperties();
        instance.addStateListener(this);
    }

    private InstanceTargetXNode(Node instanceNode, Node xnode, InstanceTargetChildren instanceTargetChildren) {
        super(instanceNode, xnode, true, instanceTargetChildren);
        this.instanceTargetChildren = instanceTargetChildren;
    }

    private ServerTarget getServerTarget() {
        if (this.instanceTarget != null) {
            return this.instanceTarget;
        }
        this.instanceTarget = this.instance.getCoTarget();
        return this.instanceTarget;
    }

    public Node getDelegateTargetNode() {
        if (this.xnode != null && this.xnode != Node.EMPTY) {
            return this.xnode;
        }
        ServerTarget st = this.getServerTarget();
        if (st == null) {
            return this.xnode;
        }
        Node tn = this.instance.getServer().getNodeProvider().createTargetNode(st);
        if (tn != null) {
            this.xnode = tn;
        }
        return this.xnode;
    }

    private void resetDelegateTargetNode() {
        this.xnode = null;
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(Arrays.asList(this.getOriginal().getActions(context)));
        if (this.getServerTarget() != null) {
            actions.addAll(Arrays.asList(this.getDelegateTargetNode().getActions(context)));
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public Node.PropertySet[] getPropertySets() {
        Node delegateNode = this.getDelegateTargetNode();
        if (delegateNode == null) {
            return this.getOriginal().getPropertySets();
        }
        return FilterXNode.merge(this.getOriginal().getPropertySets(), delegateNode.getPropertySets());
    }

    public Node.Cookie getCookie(Class type) {
        Node tn = this.getDelegateTargetNode();
        Node.Cookie c = null;
        if (tn != null) {
            c = tn.getCookie(type);
        }
        if (c == null) {
            c = super.getCookie(type);
        }
        return c;
    }

    public void stateChanged(int oldState, int newState) {
        if (newState == 3 || newState == 4 || newState == 6) {
            if (oldState == 5) {
                this.instanceTargetChildren.showLastNodes();
                this.getChildren().getNodes(true);
            } else {
                this.instanceTarget = null;
                this.resetDelegateTargetNode();
                this.instanceTargetChildren.hideNodes();
                this.setChildren((Children)this.instanceTargetChildren);
                this.instanceTargetChildren.updateNodes(this);
                this.getChildren().getNodes(true);
            }
        } else {
            this.instanceTargetChildren.hideNodes();
        }
    }

    public static class InstanceTargetChildren
    extends FilterNode.Children {
        private ServerTarget target;
        private Node lastDelegateTargetNode;

        public InstanceTargetChildren(Node original) {
            super(original);
        }

        public void updateNodes(final InstanceTargetXNode parent) {
            if (this.isFurtherExpandable()) {
                if (this.original == Node.EMPTY) {
                    this.changeOriginal(this.createWaitNode());
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            Node newOriginal = null;
                            if (parent != null) {
                                newOriginal = parent.getDelegateTargetNode();
                                InstanceTargetChildren.this.lastDelegateTargetNode = newOriginal;
                            }
                            if (newOriginal != null) {
                                InstanceTargetChildren.this.changeOriginal(newOriginal);
                            } else {
                                InstanceTargetChildren.this.changeOriginal(Node.EMPTY);
                            }
                        }
                    });
                }
            } else {
                this.changeOriginal(Node.EMPTY);
            }
        }

        public void hideNodes() {
            this.changeOriginal(Node.EMPTY);
        }

        public void showLastNodes() {
            Node node = this.lastDelegateTargetNode;
            if (node != null) {
                this.changeOriginal(node);
            }
        }

        private Node createWaitNode() {
            AbstractNode node = new AbstractNode(FilterNode.Children.LEAF);
            node.setName(NbBundle.getMessage(InstanceTargetXNode.class, (String)"LBL_WaitNode_DisplayName"));
            node.setIconBaseWithExtension("org/openide/src/resources/wait.gif");
            Children.Array children = new Children.Array();
            children.add(new Node[]{node});
            return new AbstractNode((Children)children);
        }

        private boolean isFurtherExpandable() {
            ServerRegistryNode root = ServerRegistryNode.getServerRegistryNode();
            if (root != null) {
                return root.isExpandablePassTargetNode();
            }
            return true;
        }
    }
}

