/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ExceptionBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.FieldBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.LineBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.MethodBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.PersistenceManager;
import org.netbeans.modules.debugger.jpda.breakpoints.ThreadBreakpointImpl;
import org.netbeans.spi.debugger.ContextProvider;

public class BreakpointsEngineListener
extends LazyActionsManagerListener
implements PropertyChangeListener,
DebuggerManagerListener {
    private static boolean verbose = System.getProperty("netbeans.debugger.breakpoints") != null;
    private JPDADebuggerImpl debugger;
    private SourcePath engineContext;
    private boolean started = false;
    private Session session;
    private BreakpointsReader breakpointsReader;
    private HashMap breakpointToImpl = new HashMap();

    public BreakpointsEngineListener(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
        this.engineContext = (SourcePath)lookupProvider.lookupFirst(null, SourcePath.class);
        this.session = (Session)lookupProvider.lookupFirst(null, Session.class);
        this.debugger.addPropertyChangeListener("state", this);
        this.breakpointsReader = PersistenceManager.findBreakpointsReader();
    }

    protected void destroy() {
        this.debugger.removePropertyChangeListener("state", this);
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.removeBreakpointImpls();
    }

    public String[] getProperties() {
        return new String[]{"asd"};
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.debugger.getState() == 2) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.createBreakpointImpls();
            DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        }
        if (this.debugger.getState() == 4) {
            this.removeBreakpointImpls();
            this.started = false;
            DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        }
    }

    public void actionPerformed(Object action) {
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.createBreakpointImpl(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.removeBreakpointImpl(breakpoint);
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    private void createBreakpointImpls() {
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = bs.length;
        for (int i = 0; i < k; ++i) {
            this.createBreakpointImpl(bs[i]);
        }
    }

    private void removeBreakpointImpls() {
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = bs.length;
        for (int i = 0; i < k; ++i) {
            this.removeBreakpointImpl(bs[i]);
        }
    }

    public void fixBreakpointImpls() {
        Iterator i = this.breakpointToImpl.values().iterator();
        while (i.hasNext()) {
            ((BreakpointImpl)i.next()).fixed();
        }
    }

    private void createBreakpointImpl(Breakpoint b) {
        if (this.breakpointToImpl.containsKey(b)) {
            return;
        }
        if (verbose) {
            System.out.println("B create breakpoint impl for breakpoint: " + b);
        }
        if (b instanceof LineBreakpoint) {
            this.breakpointToImpl.put(b, new LineBreakpointImpl((LineBreakpoint)b, this.breakpointsReader, this.debugger, this.session, this.engineContext));
        } else if (b instanceof ExceptionBreakpoint) {
            this.breakpointToImpl.put(b, new ExceptionBreakpointImpl((ExceptionBreakpoint)b, this.debugger, this.session));
        } else if (b instanceof MethodBreakpoint) {
            this.breakpointToImpl.put(b, new MethodBreakpointImpl((MethodBreakpoint)b, this.debugger, this.session));
        } else if (b instanceof FieldBreakpoint) {
            this.breakpointToImpl.put(b, new FieldBreakpointImpl((FieldBreakpoint)b, this.debugger, this.session));
        } else if (b instanceof ThreadBreakpoint) {
            this.breakpointToImpl.put(b, new ThreadBreakpointImpl((ThreadBreakpoint)b, this.debugger, this.session));
        } else if (b instanceof ClassLoadUnloadBreakpoint) {
            this.breakpointToImpl.put(b, new ClassBreakpointImpl((ClassLoadUnloadBreakpoint)b, this.debugger, this.session));
        }
    }

    private void removeBreakpointImpl(Breakpoint b) {
        BreakpointImpl impl;
        if (verbose) {
            System.out.println("B remove breakpoint impl for breakpoint: " + b);
        }
        if ((impl = (BreakpointImpl)this.breakpointToImpl.get(b)) == null) {
            return;
        }
        impl.remove();
        this.breakpointToImpl.remove(b);
    }
}

