/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.JspConfig;
import org.netbeans.modules.j2ee.dd.api.web.JspPropertyGroup;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.xml.multiview.Error;
import org.openide.util.NbBundle;

public class SectionValidator {
    static Error validateServlets(WebApp webApp) {
        Servlet[] servlets = webApp.getServlet();
        Error error = null;
        block0: for (int i = 0; i < servlets.length; ++i) {
            Error.ErrorLocation loc;
            String name = servlets[i].getServletName();
            if (name == null || name.length() == 0) {
                loc = new Error.ErrorLocation((Object)servlets[i], "ServletName");
                error = new Error(2, "Servlet Name", loc);
                break;
            }
            name = servlets[i].getServletClass();
            if (name == null) {
                name = servlets[i].getJspFile();
            }
            if (name == null || name.length() == 0) {
                loc = new Error.ErrorLocation((Object)servlets[i], "ServletClass");
                error = new Error(2, "Servlet Class", loc);
                break;
            }
            String[] urlPatterns = DDUtils.getUrlPatterns(webApp, servlets[i]);
            for (int j = 0; j < urlPatterns.length; ++j) {
                Error.ErrorLocation loc2;
                String errMessage = DDUtils.checkServletMappig(urlPatterns[j]);
                if (errMessage != null) {
                    loc2 = new Error.ErrorLocation((Object)servlets[i], "ServletMapping");
                    error = new Error(0, errMessage, loc2);
                    continue block0;
                }
                if (!DDUtils.isServletMapping(webApp, servlets[i], urlPatterns[j])) continue;
                loc2 = new Error.ErrorLocation((Object)servlets[i], "ServletMapping");
                error = new Error(3, urlPatterns[j], loc2);
                continue block0;
            }
        }
        return error;
    }

    static Error validateFilters(WebApp webApp) {
        Filter[] filters = webApp.getFilter();
        Error error = null;
        for (int i = 0; i < filters.length; ++i) {
            String name = filters[i].getFilterName();
            if (name == null || name.length() == 0) {
                Error.ErrorLocation loc = new Error.ErrorLocation((Object)filters[i], "FilterName");
                error = new Error(2, "Filter Name", loc);
                break;
            }
            name = filters[i].getFilterClass();
            if (name != null && name.length() != 0) continue;
            Error.ErrorLocation loc = new Error.ErrorLocation((Object)filters[i], "FilterClass");
            error = new Error(2, "Filter Class", loc);
            break;
        }
        return error;
    }

    static Error validatePages(WebApp webApp) {
        Error error = null;
        JspConfig jspConfig = null;
        JspPropertyGroup[] groups = null;
        try {
            jspConfig = webApp.getSingleJspConfig();
        }
        catch (VersionNotSupportedException ex) {
            return null;
        }
        if (jspConfig == null) {
            return null;
        }
        groups = jspConfig.getJspPropertyGroup();
        if (groups == null) {
            return null;
        }
        for (int i = 0; i < groups.length; ++i) {
            if (groups[i].sizeUrlPattern() != 0) continue;
            Error.ErrorLocation loc = new Error.ErrorLocation((Object)groups[i], "url_patterns");
            error = new Error(2, "URL Pattern", loc);
            break;
        }
        return error;
    }

    static String validateNewServlet(WebApp webApp, String servletName, String servletClass, String jspFile, String urlPatterns) {
        if (servletName.length() == 0) {
            return NbBundle.getMessage((Class)SectionValidator.class, (String)"TXT_EmptyServletName");
        }
        Servlet[] servlets = webApp.getServlet();
        boolean exists = false;
        for (int i = 0; i < servlets.length; ++i) {
            if (!servletName.equals(servlets[i].getServletName())) continue;
            exists = true;
            break;
        }
        if (exists) {
            return NbBundle.getMessage((Class)SectionValidator.class, (String)"TXT_ServletNameExists", (Object)servletName);
        }
        if (servletClass.length() == 0 && jspFile.length() == 0) {
            return NbBundle.getMessage((Class)SectionValidator.class, (String)"TXT_Servlet_BothMissing");
        }
        if (servletClass.length() > 0 && jspFile.length() > 0) {
            return NbBundle.getMessage((Class)SectionValidator.class, (String)"TXT_Servlet_BothSpecified");
        }
        String[] patterns = DDUtils.getStringArray(urlPatterns);
        if (patterns.length > 0) {
            for (int i = 0; i < patterns.length; ++i) {
                String errMessage = DDUtils.checkServletMappig(patterns[i]);
                if (errMessage != null) {
                    return errMessage;
                }
                if (!DDUtils.isServletMapping(webApp, patterns[i])) continue;
                return NbBundle.getMessage((Class)SectionValidator.class, (String)"TXT_UrlPatternExists", (Object)patterns[i]);
            }
        }
        return null;
    }

    static String validateNewFilter(WebApp webApp, String filterName, String filterClass) {
        if (filterName.length() == 0) {
            return NbBundle.getMessage((Class)SectionValidator.class, (String)"TXT_EmptyFilterName");
        }
        Filter[] filters = webApp.getFilter();
        boolean exists = false;
        for (int i = 0; i < filters.length; ++i) {
            if (!filterName.equals(filters[i].getFilterName())) continue;
            exists = true;
            break;
        }
        if (exists) {
            return NbBundle.getMessage((Class)SectionValidator.class, (String)"TXT_FilterNameExists", (Object)filterName);
        }
        if (filterClass.length() == 0) {
            return NbBundle.getMessage((Class)SectionValidator.class, (String)"TXT_EmptyFilterClass");
        }
        return null;
    }

    static String validateNewJspPropertyGroup(String urlPatterns) {
        String[] patterns = DDUtils.getStringArray(urlPatterns);
        if (patterns.length == 0) {
            return NbBundle.getMessage((Class)SectionValidator.class, (String)"TXT_EmptyUrls");
        }
        return null;
    }
}

