/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.blueprints.ui.overview;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class OverviewPageTopComponent
extends TopComponent
implements HyperlinkListener {
    private static final long serialVersionUID = 6051472310161712674L;
    private static OverviewPageTopComponent instance;
    private static final String PREFERRED_ID = "BluePrintsSolution";
    private String overviewFile;
    private HtmlBrowser.URLDisplayer browser = HtmlBrowser.URLDisplayer.getDefault();
    private static boolean firstTime;
    private String optionalTabName = ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/overview/Bundle").getString("SOLUTION_EXTRA_PAGE_TAB");
    private JTabbedPane jTabbedPane1;
    private JEditorPane mainEditorPane;
    private JScrollPane mainScrollPane;
    private JEditorPane optionalEditorPane;
    private JScrollPane optionalScrollPane;

    private OverviewPageTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage((Class)OverviewPageTopComponent.class, (String)"CTL_OverviewPageTopComponent"));
        this.setToolTipText(NbBundle.getMessage((Class)OverviewPageTopComponent.class, (String)"HINT_OverviewPageTopComponent"));
        this.jTabbedPane1.remove(this.optionalScrollPane);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.mainScrollPane = new JScrollPane();
        this.mainEditorPane = new JEditorPane();
        this.optionalScrollPane = new JScrollPane();
        this.optionalEditorPane = new JEditorPane();
        this.setLayout(new BorderLayout());
        this.mainScrollPane.setViewportView(this.mainEditorPane);
        this.jTabbedPane1.addTab(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/overview/Bundle").getString("SOLUTION_PAGE_TAB"), this.mainScrollPane);
        this.optionalScrollPane.setViewportView(this.optionalEditorPane);
        this.jTabbedPane1.addTab("tab2", this.optionalScrollPane);
        this.add(this.jTabbedPane1, "Center");
    }

    public static synchronized OverviewPageTopComponent getDefault() {
        if (instance == null) {
            instance = new OverviewPageTopComponent();
        }
        return instance;
    }

    public static synchronized OverviewPageTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find OverviewPage component. It will not be located properly in the window system.");
            return OverviewPageTopComponent.getDefault();
        }
        if (win instanceof OverviewPageTopComponent) {
            return (OverviewPageTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'BluePrintsSolution' ID. That is a potential source of errors and unexpected behavior.");
        return OverviewPageTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
        this.mainEditorPane.setEditorKit(new HTMLEditorKit());
        this.mainEditorPane.setEditorKitForContentType("text/html", new HTMLEditorKit());
        this.mainEditorPane.setEditable(false);
        this.mainEditorPane.addHyperlinkListener(this);
        try {
            URL demoDetailsURL = new URL("nbresloc:" + this.overviewFile);
            this.mainEditorPane.setPage(demoDetailsURL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        HyperlinkEvent.EventType type = e.getEventType();
        if (type == HyperlinkEvent.EventType.ACTIVATED) {
            this.updatePageWithURL(e.getURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePageWithURL(URL u) {
        if (u != null) {
            String protocol = u.getProtocol();
            if (protocol != null && (protocol.equals("http") || protocol.equals("https"))) {
                this.browser.showURL(u);
            } else {
                Cursor currentC = this.mainEditorPane.getCursor();
                Cursor busyC = Cursor.getPredefinedCursor(0);
                try {
                    this.optionalEditorPane.setEditorKit(new HTMLEditorKit());
                    this.mainEditorPane.setEditorKitForContentType("text/html", new HTMLEditorKit());
                    this.optionalEditorPane.setEditable(false);
                    this.optionalEditorPane.addHyperlinkListener(this);
                    this.optionalEditorPane.setPage(u);
                    firstTime = false;
                    this.optionalEditorPane.setPage(u);
                    String fileName = this.optionalTabName;
                    File f = new File(u.getFile());
                    if (f != null) {
                        fileName = f.getName();
                    }
                    this.jTabbedPane1.addTab(fileName, this.optionalScrollPane);
                    this.jTabbedPane1.setSelectedComponent(this.optionalScrollPane);
                    this.optionalEditorPane.setCursor(busyC);
                }
                catch (IOException e) {
                    this.mainEditorPane.setCursor(currentC);
                }
                finally {
                    this.mainEditorPane.setCursor(currentC);
                }
            }
        }
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void setOverviewFile(String overviewFile) {
        this.overviewFile = overviewFile;
        this.jTabbedPane1.removeAll();
        this.jTabbedPane1.addTab(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/overview/Bundle").getString("SOLUTION_PAGE_TAB"), this.mainScrollPane);
    }

    static {
        firstTime = true;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return OverviewPageTopComponent.getDefault();
        }
    }
}

