/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.client;

import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.client.WebServicesClientViewAccessor;
import org.netbeans.modules.websvc.spi.client.WebServicesClientViewImpl;
import org.netbeans.modules.websvc.spi.client.WebServicesClientViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public final class WebServicesClientView {
    private WebServicesClientViewImpl impl;
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(WebServicesClientViewProvider.class));

    private WebServicesClientView(WebServicesClientViewImpl impl) {
        if (impl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = impl;
    }

    public static WebServicesClientView getWebServicesClientView(FileObject f) {
        WebServicesClientView wsv;
        WebServicesClientViewProvider impl;
        if (f == null) {
            throw new NullPointerException("Passed null to WebServicesClientView.getWebServicesClientView(FileObject)");
        }
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            impl = (WebServicesClientViewProvider)it.next();
            wsv = impl.findWebServicesClientView(f);
            if (wsv == null) continue;
            return wsv;
        }
        impl = (WebServicesClientViewProvider)Lookup.getDefault().lookup(WebServicesClientViewProvider.class);
        if (impl != null) {
            wsv = impl.findWebServicesClientView(f);
            return wsv;
        }
        return null;
    }

    public Node createWebServiceClientView(Project p) {
        return this.impl.createWebServiceClientView(p);
    }

    public Node createWebServiceClientView(SourceGroup sg) {
        return this.impl.createWebServiceClientView(sg);
    }

    public Node createWebServiceClientView(FileObject wsdlFolder) {
        return this.impl.createWebServiceClientView(wsdlFolder);
    }

    static {
        WebServicesClientViewAccessor.DEFAULT = new WebServicesClientViewAccessor(){

            public WebServicesClientView createWebServicesClientView(WebServicesClientViewImpl spiWebServicesClientView) {
                return new WebServicesClientView(spiWebServicesClientView);
            }

            public WebServicesClientViewImpl getWebServicesClientViewImpl(WebServicesClientView wsv) {
                return wsv == null ? null : wsv.impl;
            }
        };
    }
}

