/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.DefinedName;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Workbook;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.FunctionLookup;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.Token;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class TokenEncoder {
    private FunctionLookup fl;
    private String parseString = new String();
    private int index;
    private Workbook wb;

    public TokenEncoder() {
        this.fl = new FunctionLookup();
    }

    public void setWorkbook(Workbook workbook) {
        this.wb = workbook;
    }

    public byte[] getByte(Token token) throws IOException {
        Vector vector = null;
        if (token.getTokenType() == 1) {
            vector = this.operatorEncoder(token);
        } else if (token.getTokenType() == 4 || token.getTokenType() == 3) {
            vector = this.functionEncoder(token);
        } else {
            switch (token.getTokenID()) {
                case 35: {
                    vector = this.nameDefinitionEncoder(token);
                    break;
                }
                case 58: {
                    vector = this.threeDCellRefEncoder(token);
                    break;
                }
                case 59: {
                    vector = this.threeDAreaRefEncoder(token);
                    break;
                }
                case 68: {
                    vector = this.cellRefEncoder(token);
                    break;
                }
                case 37: {
                    vector = this.areaRefEncoder(token);
                    break;
                }
                case 31: {
                    vector = this.numEncoder(token);
                    break;
                }
                case 23: {
                    vector = this.stringEncoder(token);
                    break;
                }
                default: {
                    Debug.log((int)2, (String)"Encoder found unrecognized Token");
                }
            }
        }
        byte[] byArray = new byte[vector.size()];
        int n = 0;
        String string = new String();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Byte by = (Byte)enumeration.nextElement();
            string = string + by + " ";
            byArray[n] = by;
            ++n;
        }
        Debug.log((int)4, (String)("Encoding Token " + token.getValue() + " as [" + string + "]"));
        return byArray;
    }

    private Vector operatorEncoder(Token token) {
        Vector<Byte> vector = new Vector<Byte>();
        vector.add(new Byte((byte)token.getTokenID()));
        return vector;
    }

    private Vector stringEncoder(Token token) throws IOException {
        Vector<Byte> vector = new Vector<Byte>();
        vector.add(new Byte((byte)token.getTokenID()));
        vector.add(new Byte((byte)token.getValue().length()));
        vector.add(new Byte(1));
        byte[] byArray = token.getValue().getBytes("UTF-16LE");
        for (int i = 0; i < byArray.length; ++i) {
            vector.add(new Byte(byArray[i]));
        }
        return vector;
    }

    private Vector numEncoder(Token token) {
        Vector<Byte> vector = new Vector<Byte>();
        double d = Double.parseDouble(token.getValue());
        vector.add(new Byte((byte)token.getTokenID()));
        byte[] byArray = EndianConverter.writeDouble((double)d);
        for (int i = 0; i < byArray.length; ++i) {
            vector.add(new Byte(byArray[i]));
        }
        return vector;
    }

    private int char2int(char c) {
        if (!Character.isLetter(c)) {
            return -1;
        }
        c = Character.toUpperCase(c);
        return c - 65;
    }

    private boolean isAlpha(char c) {
        return Character.isLetter(c);
    }

    private boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    private boolean isAlphaNum(char c) {
        return this.isAlpha(c) || this.isDigit(c);
    }

    private int column() {
        char c = this.parseString.charAt(this.index);
        String string = new String();
        int n = 0;
        while (this.isAlpha(c)) {
            string = string + c;
            ++this.index;
            c = this.parseString.charAt(this.index);
        }
        if (string.length() == 1) {
            n = this.char2int(string.charAt(0));
        } else if (string.length() == 2) {
            n = this.char2int(string.charAt(0)) + 1;
            n = n * 26 + this.char2int(string.charAt(1));
        } else {
            Debug.log((int)2, (String)("Invalid Column Reference " + string));
        }
        return n;
    }

    private int row() {
        char c = this.parseString.charAt(this.index);
        String string = new String();
        boolean bl = false;
        boolean bl2 = true;
        do {
            string = string + c;
            ++this.index;
            if (this.index >= this.parseString.length()) {
                bl2 = false;
                continue;
            }
            c = this.parseString.charAt(this.index);
        } while (this.isDigit(c) && bl2);
        return Integer.parseInt(string) - 1;
    }

    private byte[] encodeCellCoordinates(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 49152;
        this.index = 0;
        this.parseString = string;
        Debug.log((int)4, (String)("Encoding cell coordinates " + string));
        if (string.charAt(this.index) == '$') {
            n3 &= 0x8000;
            ++this.index;
        }
        n = this.column();
        if (string.charAt(this.index) == '$') {
            n3 &= 0x4000;
            ++this.index;
        }
        n2 = this.row();
        byte[] byArray = new byte[]{(byte)(n2 |= n3), (byte)(n2 >> 8), (byte)n};
        return byArray;
    }

    private Vector nameDefinitionEncoder(Token token) {
        String string;
        Vector<Byte> vector = new Vector<Byte>();
        String string2 = token.getValue();
        Debug.log((int)4, (String)("NameDefinitionEncoder : " + string2));
        vector.add(new Byte((byte)token.getTokenID()));
        Enumeration enumeration = this.wb.getDefinedNames();
        int n = 0;
        do {
            DefinedName definedName = (DefinedName)enumeration.nextElement();
            string = definedName.getName();
            Debug.log((int)4, (String)("Name pulled from DefinedName : " + string));
            ++n;
        } while (!string2.equalsIgnoreCase(string) && enumeration.hasMoreElements());
        vector.add(new Byte((byte)n));
        vector.add(new Byte(0));
        for (int i = 0; i < 12; ++i) {
            vector.add(new Byte(0));
        }
        return vector;
    }

    private Vector cellRefEncoder(Token token) {
        Vector<Byte> vector = new Vector<Byte>();
        vector.add(new Byte((byte)token.getTokenID()));
        byte[] byArray = this.encodeCellCoordinates(token.getValue());
        for (int i = 0; i < byArray.length; ++i) {
            vector.add(new Byte(byArray[i]));
        }
        return vector;
    }

    private short findSheetIndex(String string) {
        String string2;
        int n = 0;
        String string3 = string.startsWith("$") ? string.substring(1, string.length()) : string.substring(0, string.length());
        Debug.log((int)4, (String)("Searching for Worksheet : " + string3));
        Vector vector = this.wb.getWorksheetNames();
        Enumeration enumeration = vector.elements();
        do {
            string2 = (String)enumeration.nextElement();
            n = (short)(n + 1);
        } while (!string2.equalsIgnoreCase(string3) && enumeration.hasMoreElements());
        Debug.log((int)4, (String)("Setting sheetindex to " + n));
        return (short)(n - 1);
    }

    private Vector threeDCellRefEncoder(Token token) {
        short s;
        Vector<Byte> vector = new Vector<Byte>();
        this.parseString = token.getValue();
        Debug.log((int)4, (String)("Encoding 3D Cell reference " + token));
        vector.add(new Byte((byte)token.getTokenID()));
        vector.add(new Byte(-1));
        vector.add(new Byte(-1));
        for (int i = 0; i < 8; ++i) {
            vector.add(new Byte(0));
        }
        String string = this.parseString.substring(0, this.parseString.indexOf(46) + 1);
        if (string.indexOf(58) != -1) {
            string = this.parseString.substring(0, this.parseString.indexOf(58));
            s = this.findSheetIndex(string);
            string = this.parseString.substring(this.parseString.indexOf(58) + 1, this.parseString.length());
            short s2 = this.findSheetIndex(string);
            vector.add(new Byte((byte)s));
            vector.add(new Byte(0));
            vector.add(new Byte((byte)s2));
            vector.add(new Byte(0));
        } else {
            string = this.parseString.substring(0, this.parseString.indexOf(46));
            s = this.findSheetIndex(string);
            vector.add(new Byte((byte)s));
            vector.add(new Byte(0));
            vector.add(new Byte((byte)s));
            vector.add(new Byte(0));
        }
        String string2 = this.parseString.substring(this.parseString.indexOf(46) + 1, this.parseString.length());
        Debug.log((int)4, (String)("Parsing : " + string2));
        byte[] byArray = this.encodeCellCoordinates(string2);
        for (int i = 0; i < byArray.length; ++i) {
            vector.add(new Byte(byArray[i]));
        }
        return vector;
    }

    private Vector threeDAreaRefEncoder(Token token) {
        Object object;
        Vector<Byte> vector = new Vector<Byte>();
        this.parseString = token.getValue();
        Debug.log((int)4, (String)("Encoding 3D Area reference " + token));
        vector.add(new Byte((byte)token.getTokenID()));
        vector.add(new Byte(-1));
        vector.add(new Byte(-1));
        for (int i = 0; i < 8; ++i) {
            vector.add(new Byte(0));
        }
        String string = this.parseString.substring(0, this.parseString.indexOf(58));
        String string2 = string.substring(this.parseString.indexOf(46) + 1, string.length());
        String string3 = string.substring(0, string.indexOf(46));
        short s = this.findSheetIndex(string3);
        String string4 = this.parseString.substring(this.parseString.indexOf(58) + 1, this.parseString.length());
        Debug.log((int)4, (String)("param2: " + string4));
        String string5 = string4.substring(string4.indexOf(46) + 1, string4.length());
        Debug.log((int)4, (String)("cellRef2: " + string5));
        if (string4.indexOf(46) == -1) {
            vector.add(new Byte((byte)s));
            vector.add(new Byte(0));
            vector.add(new Byte((byte)s));
            vector.add(new Byte(0));
        } else {
            object = string4.substring(0, string4.indexOf(46));
            short s2 = this.findSheetIndex((String)object);
            vector.add(new Byte((byte)s));
            vector.add(new Byte(0));
            vector.add(new Byte((byte)s2));
            vector.add(new Byte(0));
        }
        object = this.encodeCellCoordinates(string2);
        byte[] byArray = this.encodeCellCoordinates(string5);
        vector.add(new Byte((byte)object[0]));
        vector.add(new Byte((byte)object[1]));
        vector.add(new Byte(byArray[0]));
        vector.add(new Byte(byArray[1]));
        vector.add(new Byte((byte)object[2]));
        vector.add(new Byte(byArray[2]));
        return vector;
    }

    private Vector areaRefEncoder(Token token) {
        Vector<Byte> vector = new Vector<Byte>();
        vector.add(new Byte((byte)token.getTokenID()));
        String string = token.getValue();
        String string2 = new String();
        String string3 = new String();
        if (string.indexOf(58) == -1) {
            Debug.log((int)2, (String)"Invalid Cell Range, could not find :");
        } else {
            string2 = string.substring(0, string.indexOf(58));
            string3 = string.substring(string.indexOf(58) + 1, string.length());
        }
        byte[] byArray = this.encodeCellCoordinates(string2);
        byte[] byArray2 = this.encodeCellCoordinates(string3);
        vector.add(new Byte(byArray[0]));
        vector.add(new Byte(byArray[1]));
        vector.add(new Byte(byArray2[0]));
        vector.add(new Byte(byArray2[1]));
        vector.add(new Byte(byArray[2]));
        vector.add(new Byte(byArray2[2]));
        return vector;
    }

    private Vector functionEncoder(Token token) {
        Vector<Byte> vector = new Vector<Byte>();
        int n = token.getTokenID();
        if (token.getTokenType() == 4) {
            vector.add(new Byte(66));
            vector.add(new Byte((byte)token.getNumArgs()));
        } else {
            vector.add(new Byte(65));
        }
        vector.add(new Byte((byte)n));
        vector.add(new Byte((byte)(n >> 8)));
        return vector;
    }
}

