/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.Component;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.jgraph.GPGraphpad;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.pad.GPBarFactory;
import org.jgraph.pad.GPDocument;
import org.jgraph.pad.GPGraph;
import org.jgraph.pad.resources.TranslatorConstants;
import org.jgraph.utils.Utilities;

public abstract class AbstractActionDefault
extends AbstractAction
implements TranslatorConstants {
    protected GPGraphpad graphpad;

    public AbstractActionDefault() {
        this((GPGraphpad)null);
    }

    public AbstractActionDefault(GPGraphpad gPGraphpad) {
        this.graphpad = gPGraphpad;
        this.putValue("Name", Utilities.getClassNameWithoutPackage(this.getClass()));
    }

    public AbstractActionDefault(String string) {
        super(string);
    }

    public AbstractActionDefault(GPGraphpad gPGraphpad, String string) {
        super(string);
        this.graphpad = gPGraphpad;
    }

    public AbstractActionDefault(GPGraphpad gPGraphpad, String string, Icon icon) {
        super(string, icon);
        this.graphpad = gPGraphpad;
    }

    public AbstractActionDefault(String string, Icon icon) {
        super(string, icon);
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public GPGraph getCurrentGraph() {
        return this.graphpad.getCurrentGraph();
    }

    public GraphLayoutCache getCurrentGraphLayoutCache() {
        return this.graphpad.getCurrentDocument().getGraphLayoutCache();
    }

    public void setSelectionAttributes(Map map) {
        if (this.graphpad != null && this.graphpad.getCurrentDocument() != null) {
            this.graphpad.getCurrentDocument().setSelectionAttributes(map);
        }
    }

    public void setFontSizeForSelection(float f) {
        if (this.graphpad != null && this.graphpad.getCurrentDocument() != null) {
            this.graphpad.getCurrentDocument().setFontSizeForSelection(f);
        }
    }

    public void setFontStyleForSelection(int n) {
        if (this.graphpad != null && this.graphpad.getCurrentDocument() != null) {
            this.graphpad.getCurrentDocument().setFontStyleForSelection(n);
        }
    }

    public void setFontNameForSelection(String string) {
        if (this.graphpad != null && this.graphpad.getCurrentDocument() != null) {
            this.graphpad.getCurrentDocument().setFontNameForSelection(string);
        }
    }

    public GPDocument getCurrentDocument() {
        return this.graphpad.getCurrentDocument();
    }

    public Component[] getMenuComponents() {
        return new Component[]{this.getMenuComponent(null)};
    }

    public Component[] getToolComponents() {
        return new Component[]{this.getToolComponent(null)};
    }

    protected Component getMenuComponent(String string) {
        JMenuItem jMenuItem = new JMenuItem(this);
        GPBarFactory.fillMenuButton(jMenuItem, this.getName(), string);
        String string2 = this.getPresentationText(string);
        if (string2 != null) {
            jMenuItem.setText(string2);
        }
        return jMenuItem;
    }

    protected Component getToolComponent(String string) {
        JButton jButton = new JButton(this){

            public float getAlignmentY() {
                return 0.5f;
            }
        };
        return GPBarFactory.fillToolbarButton(jButton, this.getName(), string);
    }

    public void update() {
        if (this.graphpad.getCurrentDocument() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public String getPresentationText(String string) {
        return null;
    }

    public void setGraphpad(GPGraphpad gPGraphpad) {
        this.graphpad = gPGraphpad;
    }

    public GPGraphpad getGraphpad() {
        return this.graphpad;
    }
}

