/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgraph.GPGraphpad;
import org.jgraph.JGraph;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.layout.LayoutAlgorithm;
import org.jgraph.layout.LayoutController;
import org.jgraph.layout.LayoutRegistry;
import org.jgraph.pad.GPGraph;
import org.jgraph.pad.GPUserObject;
import org.jgraph.pad.actions.AbstractActionDefault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileImportGXL
extends AbstractActionDefault {
    public FileImportGXL(GPGraphpad gPGraphpad) {
        super(gPGraphpad);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog(this.graphpad.getFrame(), "GXL File", 0);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        try {
            String string = fileDialog.getDirectory() + fileDialog.getFile();
            GPGraph gPGraph = this.getCurrentGraph();
            FileImportGXL.parseGXLFileInto(string, gPGraph);
        }
        catch (Exception exception) {
            this.graphpad.error(exception.toString());
        }
    }

    static void fetchNodeViewProperties(Node node, Map map) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equals("view")) {
                Element element = (Element)node2;
                Font font = GraphConstants.defaultFont;
                String string = null;
                if (element.getAttribute("font-name") != null) {
                    string = element.getAttribute("font-name").toString();
                }
                float f = font.getSize2D();
                if (element.getAttribute("font-size") != null) {
                    try {
                        f = Float.parseFloat(element.getAttribute("font-size"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                int n2 = 0;
                if (element.getAttribute("font-style") != null) {
                    String string2 = element.getAttribute("font-style");
                    if (string2.equals("plain")) {
                        n2 = 0;
                    }
                    if (string2.indexOf("italic") != -1) {
                        n2 += 2;
                    }
                    if (string2.indexOf("bold") != -1) {
                        ++n2;
                    }
                }
                font = string != null ? new Font(string, n2, (int)f) : font.deriveFont(n2, f);
                GraphConstants.setFont(map, font);
                if (element.getAttribute("color") != null) {
                    try {
                        int n3 = Integer.parseInt(element.getAttribute("color"));
                        GraphConstants.setForeground(map, new Color(n3));
                        GraphConstants.setBorderColor(map, new Color(n3));
                        GraphConstants.setLineColor(map, new Color(n3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (element.getAttribute("background-color") != null) {
                    try {
                        int n4 = Integer.parseInt(element.getAttribute("background-color"));
                        GraphConstants.setBackground(map, new Color(n4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (element.getAttribute("auto-size") != null) {
                    GraphConstants.setAutoSize(map, "true".equals(element.getAttribute("auto-size")));
                }
            }
            ++n;
        }
    }

    static void fetchEdgeViewProperties(Node node, Map map) {
        FileImportGXL.fetchNodeViewProperties(node, map);
    }

    public static void parseGXLFileInto(String string, GPGraph gPGraph) throws Exception {
        String string2 = null;
        GraphModel graphModel = gPGraph.getModel();
        File file = new File(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ConnectionSet connectionSet = new ConnectionSet();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() == 0) {
            return;
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeName().equals("graph")) {
                Element element2 = (Element)node;
                NodeList nodeList2 = element2.getChildNodes();
                boolean bl = "directed".equals(element2.getAttribute("edgemode")) || "defaultdirected".equals(element2.getAttribute("edgemode"));
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    Node node2 = nodeList2.item(n2);
                    String string3 = FileImportGXL.getLabel(node2);
                    if (node2.getAttributes() != null && node2.getNodeName() != null) {
                        Object object;
                        Object object2;
                        Node node3;
                        Object object3;
                        String string4 = node2.getNodeName().toString().toLowerCase();
                        if (string4.equals("node")) {
                            object3 = null;
                            node3 = node2.getAttributes().getNamedItem("id");
                            if (node3 != null) {
                                object3 = node3.getNodeValue();
                            }
                            if (object3 != null && !hashtable.keySet().contains(object3)) {
                                object2 = new DefaultGraphCell(new GPUserObject(string3));
                                ((DefaultMutableTreeNode)object2).add(new DefaultPort());
                                hashtable.put(object3, object2);
                                object = FileImportGXL.createDefaultAttributes();
                                FileImportGXL.fetchNodeViewProperties(node2, (Map)object);
                                hashtable2.put(object2, object);
                                arrayList.add(object2);
                            }
                        } else if (string4.equals("edge")) {
                            DefaultGraphCell defaultGraphCell;
                            object3 = (Element)node2;
                            node3 = node2.getAttributes().getNamedItem("from");
                            object2 = null;
                            if (node3 != null) {
                                object2 = node3.getNodeValue();
                            }
                            node3 = node2.getAttributes().getNamedItem("to");
                            object = null;
                            if (node3 != null) {
                                object = node3.getNodeValue();
                            }
                            DefaultEdge defaultEdge = new DefaultEdge(new GPUserObject(string3));
                            if (object2 != null && (defaultGraphCell = (DefaultGraphCell)hashtable.get(object2)) != null) {
                                connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), true);
                            }
                            if (object != null && (defaultGraphCell = (DefaultGraphCell)hashtable.get(object)) != null) {
                                connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), false);
                            }
                            boolean bl2 = ("true".equals(object3.getAttribute("isdirected")) || bl) && !"false".equals(object3.getAttribute("isdirected"));
                            Map map = GraphConstants.createMap();
                            if (bl2) {
                                GraphConstants.setLineEnd(map, 1);
                                GraphConstants.setEndFill(map, true);
                            }
                            FileImportGXL.fetchEdgeViewProperties((Node)object3, map);
                            hashtable2.put(defaultEdge, map);
                            arrayList.add(defaultEdge);
                        } else if (string4.equals("view")) {
                            string2 = ((Element)node2).getAttribute("defaultlayout");
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        graphModel.insert(arrayList.toArray(), hashtable2, connectionSet, null, null);
        if (string2 != null) {
            FileImportGXL.applyLayout(gPGraph, string2);
        }
    }

    static void applyLayout(JGraph jGraph, String string) {
        if (string == null) {
            return;
        }
        Iterator iterator = LayoutRegistry.registeredLayoutControllers();
        while (iterator.hasNext()) {
            LayoutController layoutController = (LayoutController)iterator.next();
            if (!string.equals(layoutController.toString())) continue;
            LayoutAlgorithm layoutAlgorithm = layoutController.getLayoutAlgorithm();
            layoutAlgorithm.perform(jGraph, true, layoutController.getConfiguration());
            return;
        }
    }

    public static Map createDefaultAttributes() {
        Map map = GraphConstants.createMap();
        GraphConstants.setBorderColor(map, Color.black);
        return map;
    }

    protected static String getLabel(Node node) {
        String string = null;
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equals("attr") && node2.getAttributes().getNamedItem("name").getNodeValue().equals("Label")) {
                NodeList nodeList2 = node2.getChildNodes();
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    Node node3;
                    if (nodeList2.item(n2).getNodeName().equals("string") && (node3 = nodeList2.item(n2).getFirstChild()) != null) {
                        string = node3.getNodeValue();
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return string != null ? string : new String("");
    }
}

