/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ServerCookie;

public final class Cookies {
    private static Log log;
    public static final int INITIAL_SIZE = 4;
    ServerCookie[] scookies = new ServerCookie[4];
    int cookieCount = 0;
    boolean unprocessed = true;
    MimeHeaders headers;
    public static final char[] SEPARATORS;
    protected static final boolean[] separators;
    static final int dbg = 0;
    static /* synthetic */ Class class$org$apache$tomcat$util$http$Cookies;

    public Cookies(MimeHeaders headers) {
        this.headers = headers;
    }

    public Cookies() {
    }

    public void setHeaders(MimeHeaders headers) {
        this.recycle();
        this.headers = headers;
    }

    public void recycle() {
        for (int i = 0; i < this.cookieCount; ++i) {
            if (this.scookies[i] == null) continue;
            this.scookies[i].recycle();
        }
        this.cookieCount = 0;
        this.unprocessed = true;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("=== Cookies ===");
        int count = this.getCookieCount();
        for (int i = 0; i < count; ++i) {
            pw.println(this.getCookie(i).toString());
        }
        return sw.toString();
    }

    public ServerCookie getCookie(int idx) {
        if (this.unprocessed) {
            this.getCookieCount();
        }
        return this.scookies[idx];
    }

    public int getCookieCount() {
        if (this.unprocessed) {
            this.unprocessed = false;
            this.processCookies(this.headers);
        }
        return this.cookieCount;
    }

    public ServerCookie addCookie() {
        ServerCookie c;
        if (this.cookieCount >= this.scookies.length) {
            ServerCookie[] scookiesTmp = new ServerCookie[2 * this.cookieCount];
            System.arraycopy(this.scookies, 0, scookiesTmp, 0, this.cookieCount);
            this.scookies = scookiesTmp;
        }
        if ((c = this.scookies[this.cookieCount]) == null) {
            this.scookies[this.cookieCount] = c = new ServerCookie();
        }
        ++this.cookieCount;
        return c;
    }

    public void processCookies(MimeHeaders headers) {
        if (headers == null) {
            return;
        }
        int pos = 0;
        while (pos >= 0 && (pos = headers.findHeader("Cookie", pos)) >= 0) {
            MessageBytes cookieValue = headers.getValue(pos);
            if (cookieValue == null || cookieValue.isNull()) {
                ++pos;
                continue;
            }
            if (cookieValue.getType() == 2) {
                ByteChunk bc = cookieValue.getByteChunk();
                this.processCookieHeader(bc.getBytes(), bc.getOffset(), bc.getLength());
            } else {
                this.processCookieHeader(cookieValue.toString());
            }
            ++pos;
        }
    }

    public static boolean equals(String s, byte[] b, int start, int end) {
        int blen = end - start;
        if (b == null || blen != s.length()) {
            return false;
        }
        int boff = start;
        for (int i = 0; i < blen; ++i) {
            if (b[boff++] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void processCookieHeader(String cookieString) {
        StringTokenizer tok = new StringTokenizer(cookieString, ";", false);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            int i = token.indexOf("=");
            if (i <= -1) continue;
            String name = token.substring(0, i).trim();
            String value = token.substring(i + 1, token.length()).trim();
            value = Cookies.stripQuote(value);
            ServerCookie cookie = this.addCookie();
            cookie.getName().setString(name);
            cookie.getValue().setString(value);
        }
    }

    private static String stripQuote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            try {
                return value.substring(1, value.length() - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public void log(String s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cookies: " + s));
        }
    }

    public static final boolean isSeparator(byte c) {
        if (c > 0 && c < 126) {
            return separators[c];
        }
        return false;
    }

    public static final boolean isWhiteSpace(byte c) {
        return c == 32 || c == 9 || c == 10 || c == 13 || c == 12;
    }

    /*
     * Unable to fully structure code
     */
    public final void processCookieHeader(byte[] bytes, int off, int len) {
        if (len <= 0 || bytes == null) {
            return;
        }
        end = off + len;
        pos = off;
        nameStart = 0;
        nameEnd = 0;
        valueStart = 0;
        valueEnd = 0;
        version = 0;
        sc = null;
        while (pos < end) {
            block22: {
                block21: {
                    isSpecial = false;
                    isQuoted = false;
                    while (pos < end && (Cookies.isSeparator(bytes[pos]) || Cookies.isWhiteSpace(bytes[pos]))) {
                        ++pos;
                    }
                    if (pos >= end) {
                        return;
                    }
                    if (bytes[pos] == 36) {
                        isSpecial = true;
                    }
                    valueStart = nameStart = ++pos;
                    valueEnd = nameStart;
                    for (pos = nameEnd = Cookies.getTokenEndPosition(bytes, pos, end); pos < end && Cookies.isWhiteSpace(bytes[pos]); ++pos) {
                    }
                    if (pos >= end || bytes[pos] != 61) break block21;
                    while (++pos < end && Cookies.isWhiteSpace(bytes[pos])) {
                    }
                    if (pos >= end) {
                        return;
                    }
                    switch (bytes[pos]) {
                        case 34: {
                            isQuoted = true;
                            valueStart = pos + 1;
                            pos = valueEnd = Cookies.getQuotedValueEndPosition(bytes, valueStart, end);
                            if (pos >= end) {
                                return;
                            }
                            break block22;
                        }
                        case 44: 
                        case 59: {
                            valueEnd = -1;
                            valueStart = -1;
                            break block22;
                        }
                        default: {
                            if (Cookies.isSeparator(bytes[pos])) ** GOTO lbl47
                            valueStart = pos;
                            pos = valueEnd = Cookies.getTokenEndPosition(bytes, valueStart, end);
                            break block22;
lbl47:
                            // 1 sources

                            this.log("Invalid cookie. Value not a token or quoted value");
                            while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                                ++pos;
                            }
                            ++pos;
                            sc = null;
                            break;
                        }
                    }
                    continue;
                }
                valueEnd = -1;
                valueStart = -1;
                pos = nameEnd;
            }
            while (pos < end && Cookies.isWhiteSpace(bytes[pos])) {
                ++pos;
            }
            while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                ++pos;
            }
            ++pos;
            if (isSpecial) {
                isSpecial = false;
                if (Cookies.equals("Version", bytes, nameStart, nameEnd) && sc == null) {
                    if (bytes[valueStart] != 49 || valueEnd != valueStart + 1) continue;
                    version = 1;
                    continue;
                }
                if (sc == null) continue;
                if (Cookies.equals("Domain", bytes, nameStart, nameEnd)) {
                    sc.getDomain().setBytes(bytes, valueStart, valueEnd - valueStart);
                    continue;
                }
                if (Cookies.equals("Path", bytes, nameStart, nameEnd)) {
                    sc.getPath().setBytes(bytes, valueStart, valueEnd - valueStart);
                    continue;
                }
                if (Cookies.equals("Port", bytes, nameStart, nameEnd)) continue;
                this.log("Unknown Special Cookie");
                continue;
            }
            sc = this.addCookie();
            sc.setVersion(version);
            sc.getName().setBytes(bytes, nameStart, nameEnd - nameStart);
            if (valueStart != -1) {
                sc.getValue().setBytes(bytes, valueStart, valueEnd - valueStart);
                if (!isQuoted) continue;
                ServerCookie.unescapeDoubleQuotes(sc.getValue().getByteChunk());
                continue;
            }
            sc.getValue().setString("");
        }
    }

    public static final int getTokenEndPosition(byte[] bytes, int off, int end) {
        int pos;
        for (pos = off; pos < end && !Cookies.isSeparator(bytes[pos]); ++pos) {
        }
        if (pos > end) {
            return end;
        }
        return pos;
    }

    public static final int getQuotedValueEndPosition(byte[] bytes, int off, int end) {
        int pos = off;
        while (pos < end) {
            if (bytes[pos] == 34) {
                return pos;
            }
            if (bytes[pos] == 92 && pos < end - 1) {
                pos += 2;
                continue;
            }
            ++pos;
        }
        return end;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i;
        log = LogFactory.getLog((Class)(class$org$apache$tomcat$util$http$Cookies == null ? (class$org$apache$tomcat$util$http$Cookies = Cookies.class$("org.apache.tomcat.util.http.Cookies")) : class$org$apache$tomcat$util$http$Cookies));
        SEPARATORS = new char[]{'\t', ' ', '\"', '\'', '(', ')', ',', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '{', '}'};
        separators = new boolean[128];
        for (i = 0; i < 128; ++i) {
            Cookies.separators[i] = false;
        }
        for (i = 0; i < SEPARATORS.length; ++i) {
            Cookies.separators[Cookies.SEPARATORS[i]] = true;
        }
    }
}

