/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;

public class TreeControlTag
extends TagSupport {
    static final String DEFAULT_IMAGES = "images";
    static final String IMAGE_HANDLE_DOWN_LAST = "handledownlast.gif";
    static final String IMAGE_HANDLE_DOWN_MIDDLE = "handledownmiddle.gif";
    static final String IMAGE_HANDLE_RIGHT_LAST = "handlerightlast.gif";
    static final String IMAGE_HANDLE_RIGHT_MIDDLE = "handlerightmiddle.gif";
    static final String IMAGE_LINE_LAST = "linelastnode.gif";
    static final String IMAGE_LINE_MIDDLE = "linemiddlenode.gif";
    static final String IMAGE_LINE_VERTICAL = "linevertical.gif";
    protected String action = null;
    protected String images = "images";
    protected String scope = null;
    protected String style = null;
    protected String styleSelected = null;
    protected String styleUnselected = null;
    protected String tree = null;

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getImages() {
        return this.images;
    }

    public void setImages(String images) {
        this.images = images;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (!("page".equals(scope) || "request".equals(scope) || "session".equals(scope) || "application".equals(scope))) {
            throw new IllegalArgumentException("Invalid scope '" + scope + "'");
        }
        this.scope = scope;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleSelected() {
        return this.styleSelected;
    }

    public void setStyleSelected(String styleSelected) {
        this.styleSelected = styleSelected;
    }

    public String getStyleUnselected() {
        return this.styleUnselected;
    }

    public void setStyleUnselected(String styleUnselected) {
        this.styleUnselected = styleUnselected;
    }

    public String getTree() {
        return this.tree;
    }

    public void setTree(String tree) {
        this.tree = tree;
    }

    public int doEndTag() throws JspException {
        TreeControl treeControl = this.getTreeControl();
        JspWriter out = this.pageContext.getOut();
        try {
            out.print("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"");
            if (this.style != null) {
                out.print(" class=\"");
                out.print(this.style);
                out.print("\"");
            }
            out.println(">");
            int level = 0;
            TreeControlNode node = treeControl.getRoot();
            this.render(out, node, level, treeControl.getWidth(), true);
            out.println("</table>");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    public void release() {
        this.action = null;
        this.images = DEFAULT_IMAGES;
        this.scope = null;
        this.style = null;
        this.styleSelected = null;
        this.styleUnselected = null;
        this.tree = null;
    }

    protected TreeControl getTreeControl() throws JspException {
        Object treeControl = null;
        if (this.scope == null) {
            treeControl = this.pageContext.findAttribute(this.tree);
        } else if ("page".equals(this.scope)) {
            treeControl = this.pageContext.getAttribute(this.tree, 1);
        } else if ("request".equals(this.scope)) {
            treeControl = this.pageContext.getAttribute(this.tree, 2);
        } else if ("session".equals(this.scope)) {
            treeControl = this.pageContext.getAttribute(this.tree, 3);
        } else if ("application".equals(this.scope)) {
            treeControl = this.pageContext.getAttribute(this.tree, 4);
        }
        if (treeControl == null) {
            throw new JspException("Cannot find tree control attribute '" + this.tree + "'");
        }
        if (!(treeControl instanceof TreeControl)) {
            throw new JspException("Invalid tree control attribute '" + this.tree + "'");
        }
        return (TreeControl)treeControl;
    }

    protected void render(JspWriter out, TreeControlNode node, int level, int width, boolean last) throws IOException {
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        if ("ROOT-NODE".equalsIgnoreCase(node.getName()) && node.getLabel() == null) {
            TreeControlNode[] children = node.findChildren();
            int lastIndex = children.length - 1;
            int newLevel = level + 1;
            for (int i = 0; i < children.length; ++i) {
                this.render(out, children[i], newLevel, width, i == lastIndex);
            }
            return;
        }
        out.println("  <tr valign=\"middle\">");
        for (int i = 0; i < level; ++i) {
            int levels = level - i;
            TreeControlNode parent = node;
            for (int j = 1; j <= levels; ++j) {
                parent = parent.getParent();
            }
            if (parent.isLast()) {
                out.print("    <td></td>");
            } else {
                out.print("    <td><img src=\"");
                out.print(this.images);
                out.print("/");
                out.print(IMAGE_LINE_VERTICAL);
                out.print("\" alt=\"\" border=\"0\"></td>");
            }
            out.println();
        }
        String encodedNodeName = URLEncoder.encode(node.getName(), "UTF-8");
        String action = this.replace(this.getAction(), "{name}", encodedNodeName);
        String updateTreeAction = this.replace(this.getAction(), "tree={name}", "select=" + encodedNodeName);
        updateTreeAction = ((HttpServletResponse)this.pageContext.getResponse()).encodeURL(updateTreeAction);
        out.print("    <td>");
        if (action != null && !node.isLeaf()) {
            out.print("<a href=\"");
            out.print(response.encodeURL(action));
            out.print("\">");
        }
        out.print("<img src=\"");
        out.print(this.images);
        out.print("/");
        if (node.isLeaf()) {
            if (node.isLast()) {
                out.print(IMAGE_LINE_LAST);
            } else {
                out.print(IMAGE_LINE_MIDDLE);
            }
            out.print("\" alt=\"");
        } else if (node.isExpanded()) {
            if (node.isLast()) {
                out.print(IMAGE_HANDLE_DOWN_LAST);
            } else {
                out.print(IMAGE_HANDLE_DOWN_MIDDLE);
            }
            out.print("\" alt=\"close node");
        } else {
            if (node.isLast()) {
                out.print(IMAGE_HANDLE_RIGHT_LAST);
            } else {
                out.print(IMAGE_HANDLE_RIGHT_MIDDLE);
            }
            out.print("\" alt=\"expand node");
        }
        out.print("\" border=\"0\">");
        if (action != null && !node.isLeaf()) {
            out.print("</a>");
        }
        out.println("</td>");
        String hyperlink = null;
        if (node.getAction() != null) {
            hyperlink = ((HttpServletResponse)this.pageContext.getResponse()).encodeURL(node.getAction());
        }
        out.print("    <td colspan=\"");
        out.print(width - level + 1);
        out.print("\">");
        if (node.getIcon() != null) {
            if (hyperlink != null) {
                out.print("<a href=\"");
                out.print(hyperlink);
                out.print("\"");
                String target = node.getTarget();
                if (target != null) {
                    out.print(" target=\"");
                    out.print(target);
                    out.print("\"");
                }
                out.print(" onclick=\"");
                out.print("self.location.href='" + updateTreeAction + "'");
                out.print("\"");
                out.print(">");
            }
            out.print("<img src=\"");
            out.print(this.images);
            out.print("/");
            out.print(node.getIcon());
            out.print("\" alt=\"");
            out.print("\" border=\"0\">");
            if (hyperlink != null) {
                out.print("</a>");
            }
        }
        if (node.getLabel() != null) {
            String labelStyle = null;
            if (node.isSelected() && this.styleSelected != null) {
                labelStyle = this.styleSelected;
            } else if (!node.isSelected() && this.styleUnselected != null) {
                labelStyle = this.styleUnselected;
            }
            if (hyperlink != null) {
                out.print(" <a href=\"");
                out.print(hyperlink);
                out.print("\"");
                String target = node.getTarget();
                if (target != null) {
                    out.print(" target=\"");
                    out.print(target);
                    out.print("\"");
                }
                if (labelStyle != null) {
                    out.print(" class=\"");
                    out.print(labelStyle);
                    out.print("\"");
                }
                out.print(" onclick=\"");
                out.print("self.location.href='" + updateTreeAction + "'");
                out.print("\"");
                out.print(">");
            } else if (labelStyle != null) {
                out.print("<span class=\"");
                out.print(labelStyle);
                out.print("\">");
            }
            out.print(node.getLabel());
            if (hyperlink != null) {
                out.print("</a>");
            } else if (labelStyle != null) {
                out.print("</span>");
            }
        }
        out.println("</td>");
        out.println("  </tr>");
        if (node.isExpanded()) {
            TreeControlNode[] children = node.findChildren();
            int lastIndex = children.length - 1;
            int newLevel = level + 1;
            for (int i = 0; i < children.length; ++i) {
                this.render(out, children[i], newLevel, width, i == lastIndex);
            }
        }
    }

    protected String replace(String template, String placeholder, String value) {
        int index;
        if (template == null) {
            return null;
        }
        if (placeholder == null || value == null) {
            return template;
        }
        while ((index = template.indexOf(placeholder)) >= 0) {
            StringBuffer temp = new StringBuffer(template.substring(0, index));
            temp.append(value);
            temp.append(template.substring(index + placeholder.length()));
            template = temp.toString();
        }
        return template;
    }
}

