/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.io.IOException;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.resources.MailSessionForm;
import org.apache.webapp.admin.resources.ResourceUtils;

public final class SaveMailSessionAction
extends Action {
    private MBeanServer mserver = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        MessageResources resources = this.getResources(request);
        Locale locale = this.getLocale(request);
        if (this.isCancelled(request)) {
            return mapping.findForward("List MailSessions Setup");
        }
        if (!this.isTokenValid(request)) {
            response.sendError(400, resources.getMessage(locale, "users.error.token"));
            return null;
        }
        MailSessionForm mailSessionForm = (MailSessionForm)form;
        String objectName = mailSessionForm.getObjectName();
        if (objectName == null) {
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            Object[] params = new Object[]{mailSessionForm.getName(), "javax.mail.Session"};
            String resourcetype = mailSessionForm.getResourcetype();
            String path = mailSessionForm.getPath();
            String host = mailSessionForm.getHost();
            String domain = mailSessionForm.getDomain();
            ObjectName oname = null;
            try {
                if (resourcetype.equals("Global")) {
                    oname = new ObjectName(domain + ":type=Resource" + ",resourcetype=Global" + ",class=" + params[1] + ",name=" + params[0]);
                } else if (resourcetype.equals("Context")) {
                    oname = new ObjectName(domain + ":type=Resource" + ",resourcetype=Context" + ",path=" + path + ",host=" + host + ",class=" + params[1] + ",name=" + params[0]);
                }
                if (this.mserver.isRegistered(oname)) {
                    ActionMessages errors = new ActionMessages();
                    errors.add("name", new ActionMessage("resources.invalid.name"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                oname = ResourceUtils.getNamingResourceObjectName(domain, resourcetype, path, host);
                objectName = (String)this.mserver.invoke(oname, "addResource", params, signature);
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.invoke", (Object)"addResource"), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.invoke", (Object)"addResource"));
                return null;
            }
        }
        String attribute = null;
        try {
            ObjectName oname = new ObjectName(objectName);
            attribute = "mail.smtp.host";
            this.mserver.setAttribute(oname, new Attribute(attribute, mailSessionForm.getMailhost()));
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.set.attribute", (Object)attribute), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.set.attribute", (Object)attribute));
            return null;
        }
        return mapping.findForward("MailSessions List Setup");
    }
}

