import os, sys
import unittest
from sets import Set
import traceback

if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing                 import ZopeTestCase
from Products.PloneTestCase import PloneTestCase

ZopeTestCase.installProduct('PageCacheManager')
ZopeTestCase.installProduct('CMFSquidTool')
ZopeTestCase.installProduct('CacheSetup')

PloneTestCase.setupPloneSite()

from Products.CMFCore.utils  import getToolByName
from Products.CacheSetup.Extensions.Install import install as installCacheSetup, uninstall as uninstallCacheSetup
import Products.CacheSetup.config as config

# util for making content in a container
def makeContent(container, id, portal_type, title=None):
    container.invokeFactory(id=id, type_name=portal_type)
    o = getattr(container, id)
    if title is not None:
        o.setTitle(title)
    return o


# This is the test case. You will have to add test_<methods> to your
# class inorder to assert things about your Product.
class CacheManagerTest(PloneTestCase.PloneTestCase):
    USER1 = 'user1'
    
    def afterSetUp(self):
        PloneTestCase.PloneTestCase.afterSetUp(self)
        
        # Add a couple of users
        self.portal.acl_users._doAddUser('manager', 'secret', ['Manager'], [])
        self.portal.acl_users._doAddUser(self.USER1, 'secret', ['Member'], [])
        self.login('manager')

    def test_install(self):
        cpm = self.portal.caching_policy_manager
        cpm.addPolicy('foo', 'python:0', '', 1, 1, 0, 1, 'foo', '')
        original_class = cpm.__class__
        
        installCacheSetup(self.portal)
        installCacheSetup(self.portal)
        cpm = self.portal.caching_policy_manager
        self.assertNotEqual(cpm.__class__, original_class)
        #self.failIf('caching_policy_manager' in self.portal.objectIds())
        
        uninstallCacheSetup(self.portal)
        cpm = self.portal.caching_policy_manager
        self.assertEqual(cpm.__class__, original_class)
        lp = cpm.listPolicies()
        self.assertEqual(len(lp), 1)
        (id, p) = lp[0]
        self.assertEqual(id, 'foo')
        self.assertEqual(p.getPredicate(), 'python:0')
        
        

def test_suite():
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(CacheManagerTest))
    return suite

if __name__ == '__main__':
    framework()
