/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.utils;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.ToolTipManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jgraph.utils.BrowserLauncher;

public class HTMLPane
extends JEditorPane {
    protected CustomLinkHandler linkHandler = new CustomLinkHandler(this);
    protected boolean toolTipOriginalEnabledStatus = true;

    public HTMLPane() {
        this(false);
    }

    public HTMLPane(boolean bl) {
        this.setEditable(bl);
        this.setContentType("text/html");
        this.addHyperlinkListener(this.linkHandler);
        this.toolTipOriginalEnabledStatus = ToolTipManager.sharedInstance().isEnabled();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.linkHandler.isHoveringOverHyperlink() && this.linkHandler.getHoveredURL() != null) {
            ToolTipManager.sharedInstance().setEnabled(true);
            return this.linkHandler.getHoveredURL();
        }
        ToolTipManager.sharedInstance().setEnabled(false);
        return null;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return new Point(mouseEvent.getX() + 10, mouseEvent.getY() + 25);
    }

    public boolean isHoveringOverHyperlink() {
        return this.linkHandler.isHoveringOverHyperlink();
    }

    public String getHoveredURL() {
        return this.linkHandler.getHoveredURL();
    }

    protected class CustomLinkHandler
    implements HyperlinkListener {
        protected JEditorPane pane = null;
        protected boolean isHovering = false;
        protected String hoveredURLString = null;

        public CustomLinkHandler(JEditorPane jEditorPane) {
            this.pane = jEditorPane;
        }

        private CustomLinkHandler() {
        }

        public boolean isHoveringOverHyperlink() {
            if (this.pane.isEditable()) {
                return false;
            }
            return this.isHovering;
        }

        public String getHoveredURL() {
            return this.hoveredURLString;
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            block5: {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    this.isHovering = true;
                    URL uRL = hyperlinkEvent.getURL();
                    this.hoveredURLString = uRL != null ? uRL.toExternalForm() : null;
                } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    this.isHovering = false;
                    this.hoveredURLString = null;
                }
                if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block5;
                try {
                    BrowserLauncher.openURL(hyperlinkEvent.getURL());
                }
                catch (Exception exception) {
                    System.out.println("Error dealing with browser.");
                    exception.printStackTrace();
                }
            }
        }
    }
}

