/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.run;

import br.arca.morcego.Morcego;
import br.arca.morcego.structure.Graph;

public class Rotator
implements Runnable {
    private Graph graph;
    private float xTheta;
    private float yTheta;
    private boolean spinning;

    public Rotator(Graph g) {
        this.graph = g;
        this.yTheta = 0.0f;
        this.xTheta = 0.0f;
        this.spinning = false;
    }

    public boolean isSpinning() {
        return this.spinning;
    }

    public void spin(float xTheta, float yTheta) {
        this.spinning = true;
        this.xTheta = xTheta;
        this.yTheta = yTheta;
        Rotator rotator = this;
        synchronized (rotator) {
            this.notify();
        }
    }

    public void stop() {
        this.spinning = false;
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        while (true) {
            if (!this.isSpinning()) {
                Rotator rotator = this;
                synchronized (rotator) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.graph.rotate(this.xTheta, this.yTheta);
            Morcego.notifyRenderer();
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

