<?php

function got_mod_rewrite() {
	global $is_apache;

	// take 3 educated guesses as to whether or not mod_rewrite is available
	if ( !$is_apache )
		return false;

	if ( function_exists( 'apache_get_modules' ) ) {
		if ( !in_array( 'mod_rewrite', apache_get_modules() ) )
			return false;
	}

	return true;
}

// Returns an array of strings from a file (.htaccess ) from between BEGIN
// and END markers.
function extract_from_markers( $filename, $marker ) {
	$result = array ();

	if (!file_exists( $filename ) ) {
		return $result;
	}

	if ( $markerdata = explode( "\n", implode( '', file( $filename ) ) ));
	{
		$state = false;
		foreach ( $markerdata as $markerline ) {
			if (strpos($markerline, '# END ' . $marker) !== false)
				$state = false;
			if ( $state )
				$result[] = $markerline;
			if (strpos($markerline, '# BEGIN ' . $marker) !== false)
				$state = true;
		}
	}

	return $result;
}

// Inserts an array of strings into a file (.htaccess ), placing it between
// BEGIN and END markers.  Replaces existing marked info.  Retains surrounding
// data.  Creates file if none exists.
// Returns true on write success, false on failure.
function insert_with_markers( $filename, $marker, $insertion ) {
	return;
	if (!file_exists( $filename ) || is_writeable( $filename ) ) {
		if (!file_exists( $filename ) ) {
			$markerdata = '';
		} else {
			$markerdata = explode( "\n", implode( '', file( $filename ) ) );
		}

		$f = fopen( $filename, 'w' );
		$foundit = false;
		if ( $markerdata ) {
			$state = true;
			foreach ( $markerdata as $n => $markerline ) {
				if (strpos($markerline, '# BEGIN ' . $marker) !== false)
					$state = false;
				if ( $state ) {
					if ( $n + 1 < count( $markerdata ) )
						fwrite( $f, "{$markerline}\n" );
					else
						fwrite( $f, "{$markerline}" );
				}
				if (strpos($markerline, '# END ' . $marker) !== false) {
					fwrite( $f, "# BEGIN {$marker}\n" );
					if ( is_array( $insertion ))
						foreach ( $insertion as $insertline )
							fwrite( $f, "{$insertline}\n" );
					fwrite( $f, "# END {$marker}\n" );
					$state = true;
					$foundit = true;
				}
			}
		}
		if (!$foundit) {
			fwrite( $f, "# BEGIN {$marker}\n" );
			foreach ( $insertion as $insertline )
				fwrite( $f, "{$insertline}\n" );
			fwrite( $f, "# END {$marker}\n" );
		}
		fclose( $f );
		return true;
	} else {
		return false;
	}
}

/**
 * Updates the htaccess file with the current rules if it is writable.
 *
 * Always writes to the file if it exists and is writable to ensure that we blank out old rules.
 */

function save_mod_rewrite_rules() {
	global $wp_rewrite;

	$home_path = get_home_path();
	$htaccess_file = $home_path.'.htaccess';

	// If the file doesn't already exists check for write access to the directory and whether of not we have some rules.
	// else check for write access to the file.
	if ((!file_exists($htaccess_file) && is_writable($home_path) && $wp_rewrite->using_mod_rewrite_permalinks()) || is_writable($htaccess_file)) {
		if ( got_mod_rewrite() ) {
			$rules = explode( "\n", $wp_rewrite->mod_rewrite_rules() );
			return insert_with_markers( $htaccess_file, 'WordPress', $rules );
		}
	}

	return false;
}

function update_recently_edited( $file ) {
	$oldfiles = (array ) get_option( 'recently_edited' );
	if ( $oldfiles ) {
		$oldfiles = array_reverse( $oldfiles );
		$oldfiles[] = $file;
		$oldfiles = array_reverse( $oldfiles );
		$oldfiles = array_unique( $oldfiles );
		if ( 5 < count( $oldfiles ))
			array_pop( $oldfiles );
	} else {
		$oldfiles[] = $file;
	}
	update_option( 'recently_edited', $oldfiles );
}

// If siteurl or home changed, reset cookies and flush rewrite rules.
function update_home_siteurl( $old_value, $value ) {
	global $wp_rewrite, $user_login, $user_pass_md5;

	if ( defined( "WP_INSTALLING" ) )
		return;

	// If home changed, write rewrite rules to new location.
	$wp_rewrite->flush_rules();
	// Clear cookies for old paths.
	wp_clearcookie();
	// Set cookies for new paths.
	wp_setcookie( $user_login, $user_pass_md5, true, get_option( 'home' ), get_option( 'siteurl' ));
}

add_action( 'update_option_home', 'update_home_siteurl', 10, 2 );
add_action( 'update_option_siteurl', 'update_home_siteurl', 10, 2 );

function url_shorten( $url ) {
	$short_url = str_replace( 'http://', '', stripslashes( $url ));
	$short_url = str_replace( 'www.', '', $short_url );
	if ('/' == substr( $short_url, -1 ))
		$short_url = substr( $short_url, 0, -1 );
	if ( strlen( $short_url ) > 35 )
		$short_url = substr( $short_url, 0, 32 ).'...';
	return $short_url;
}

function wp_reset_vars( $vars ) {
	for ( $i=0; $i<count( $vars ); $i += 1 ) {
		$var = $vars[$i];
		global $$var;

		if (!isset( $$var ) ) {
			if ( empty( $_POST["$var"] ) ) {
				if ( empty( $_GET["$var"] ) )
					$$var = '';
				else
					$$var = $_GET["$var"];
			} else {
				$$var = $_POST["$var"];
			}
		}
	}
}

function add_option_update_handler($option_group, $option_name, $sanitize_callback = '') {
	global $new_whitelist_options, $sanitize_callbacks;
	$new_whitelist_options[ $option_group ][] = $option_name;
	if( $sanitize_callback != '' )
		add_filter( "sanitize_option_{$option_name}", $sanitize_callback );
}

function remove_option_update_handler($option_group, $option_name, $sanitize_callback = '') {
	global $new_whitelist_options, $sanitize_callbacks;
	$pos = array_search( $option_name, $new_whitelist_options );
	if( $pos !== false )
		unset( $new_whitelist_options[ $option_group ][ $pos ] );
	if( $sanitize_callback != '' )
		remove_filter( "sanitize_option_{$option_name}", $sanitize_callback );
}

function option_update_filter( $options ) {
	global $new_whitelist_options;

	if( is_array( $new_whitelist_options ) )
		$options = add_option_whitelist( $new_whitelist_options, $options );

	return $options;
}
add_filter( 'whitelist_options', 'option_update_filter' );

function add_option_whitelist( $new_options, $options = '' ) {
	if( $options == '' ) {
		global $whitelist_options;
	} else {
		$whitelist_options = $options;
	}
	foreach( $new_options as $page => $keys ) {
		foreach( $keys as $key ) {
			$pos = array_search( $key, $whitelist_options[ $page ] );
			if( $pos === false )
				$whitelist_options[ $page ][] = $key;
		}
	}
	return $whitelist_options;
}

function remove_option_whitelist( $del_options, $options = '' ) {
	if( $options == '' ) {
		global $whitelist_options;
	} else {
		$whitelist_options = $options;
	}
	foreach( $del_options as $page => $keys ) {
		foreach( $keys as $key ) {
			$pos = array_search( $key, $whitelist_options[ $page ] );
			if( $pos !== false )
				unset( $whitelist_options[ $page ][ $pos ] );
		}
	}
	return $whitelist_options;
}
?>
