/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.diff;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.diff.SQLObjectComparator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLRelationshipComparator
implements Comparator<SQLRelationship> {
    private static Logger logger = Logger.getLogger(SQLRelationship.class);
    SQLObjectComparator comparator = new SQLObjectComparator();

    @Override
    public int compare(SQLRelationship r1, SQLRelationship r2) {
        if (r1 == r2) {
            return 0;
        }
        if (r1 == null) {
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        int result = this.comparator.compare(r1.getPkTable(), r2.getPkTable());
        if (result != 0) {
            return result;
        }
        result = this.comparator.compare(r1.getFkTable(), r2.getFkTable());
        if (result != 0) {
            return result;
        }
        TreeSet<SQLObject> sourceColPk = new TreeSet<SQLObject>(this.comparator);
        TreeSet<SQLObject> targetColPk = new TreeSet<SQLObject>(this.comparator);
        TreeSet<SQLObject> sourceColFk = new TreeSet<SQLObject>(this.comparator);
        TreeSet<SQLObject> targetColFk = new TreeSet<SQLObject>(this.comparator);
        try {
            for (SQLRelationship.ColumnMapping cm : r1.getChildren()) {
                sourceColPk.add(cm.getPkColumn());
                sourceColFk.add(cm.getFkColumn());
            }
        }
        catch (ArchitectException e) {
            logger.debug((Object)("The source columnMapping has no PK Columns!  Shouldn't happen!" + e));
        }
        try {
            for (SQLRelationship.ColumnMapping cm : r2.getChildren()) {
                targetColPk.add(cm.getPkColumn());
                targetColFk.add(cm.getFkColumn());
            }
        }
        catch (ArchitectException e) {
            logger.debug((Object)("The target columnMapping has no PK Columns!  Shouldn't happen!" + e));
        }
        result = this.compareColumns(sourceColPk, targetColPk);
        if (result != 0) {
            return result;
        }
        result = this.compareColumns(sourceColFk, targetColFk);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public int compareColumns(Set<SQLColumn> source, Set<SQLColumn> target) {
        boolean targetContinue;
        boolean sourceContinue;
        Iterator<SQLColumn> sourceIter = source.iterator();
        Iterator<SQLColumn> targetIter = target.iterator();
        do {
            SQLColumn targetColumn;
            SQLColumn sourceColumn;
            if (sourceIter.hasNext()) {
                sourceContinue = true;
                sourceColumn = sourceIter.next();
            } else {
                sourceContinue = false;
                sourceColumn = null;
            }
            if (targetIter.hasNext()) {
                targetContinue = true;
                targetColumn = targetIter.next();
            } else {
                targetContinue = false;
                targetColumn = null;
            }
            int result = this.comparator.compare(sourceColumn, targetColumn);
            if (result == 0) continue;
            return result;
        } while (sourceContinue || targetContinue);
        return 0;
    }
}

