/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.profile.ProfileResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileChangeEvent
extends EventObject {
    List<ProfileResult> profileResultList = new ArrayList<ProfileResult>();

    public ProfileChangeEvent(Object source, ProfileResult pr) {
        super(source);
        this.profileResultList.add(pr);
    }

    public ProfileChangeEvent(Object source, List<ProfileResult> prList) {
        super(source);
        this.profileResultList = new ArrayList<ProfileResult>(prList);
    }

    public List<ProfileResult> getProfileResult() {
        return Collections.unmodifiableList(this.profileResultList);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ProfileChangeEvent(");
        for (ProfileResult pr : this.profileResultList) {
            Object profiledObject = pr.getProfiledObject();
            String name = profiledObject != null ? ((SQLObject)profiledObject).getName() : "unknown profiled object";
            buf.append(String.format(" [%s, %s]", name, pr));
        }
        buf.append(" )");
        return buf.toString();
    }
}

