/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.sql.SQLRunner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;

public class ReaderParserTest
extends TestCase {
    private BufferedReader getReader(String data) {
        return new BufferedReader(new StringReader(data));
    }

    private String getStatement(String input) throws IOException {
        return SQLRunner.getStatement(this.getReader(input));
    }

    public void testGetStatement1() throws Exception {
        String[] data = new String[]{"\\d;", "\\d\n;"};
        String r1 = this.getStatement(data[0]);
        String r2 = this.getStatement(data[1]);
        ReaderParserTest.assertEquals((String)r1.trim(), (String)r2.trim());
    }

    public void testGetStatement2() throws Exception {
        String command = "-- This is a comment";
        ReaderParserTest.assertNull((Object)SQLRunner.getStatement(this.getReader(command)));
        command = "# This is a comment";
        ReaderParserTest.assertNull((Object)SQLRunner.getStatement(this.getReader(command)));
        command = "*;\n";
        ReaderParserTest.assertEquals((String)"*", (String)this.getStatement(command));
        command = "select\n# a comment\n*;\n";
        ReaderParserTest.assertEquals((String)"select *", (String)this.getStatement(command));
    }
}

