# $Id: ssl-alerts.bro 416 2004-09-17 03:52:28Z vern $
#
# Interface for SSL/TLS support.

# --- constant definitions of the SSL/TLS alert/error records ---

# --- Error descriptions for SSLv2.
const SSLv2_PE_NO_CIPHER = 0x0001;
const SSLv2_PE_NO_CERTIFICATE = 0x0002;
const SSLv2_PE_BAD_CERTIFICATE = 0x0004;
const SSLv2_PE_UNSUPPORTED_CERTIFICATE_TYPE = 0x0006;

# --- Alert descriptions in SSLv3.0 and SSLv3.1.
const SSLv3x_ALERT_DESCR_CLOSE_NOTIFY = 0;
const SSLv3x_ALERT_DESCR_UNEXPECTED_MESSSAGE = 10;
const SSLv3x_ALERT_DESCR_BAD_RECORD_MAC = 20;
const SSLv3x_ALERT_DESCR_DECOMPRESSION_FAILURE = 30;
const SSLv3x_ALERT_DESCR_HANDSHAKE_FAILURE = 40;
const SSLv3x_ALERT_DESCR_BAD_CERTIFICATE = 42;
const SSLv3x_ALERT_DESCR_UNSUPPORTED_CERTIFICATE = 43;
const SSLv3x_ALERT_DESCR_CERTIFICATE_REVOKED = 44;
const SSLv3x_ALERT_DESCR_CERTIFICATE_EXPIRED = 45;
const SSLv3x_ALERT_DESCR_CERTIFICATE_UNKNOWN = 46;

# --- Alert descriptions only in SSLv3.0.
const SSLv30_ALERT_DESCR_NO_CERTIFICATE = 41;

# --- Alert descriptions only in SSLv3.1.
const SSLv31_ALERT_DESCR_DESCRYPTION_FAILED = 21;
const SSLv31_ALERT_DESCR_RECORD_OVERFLOW = 22;
const SSLv31_ALERT_DESCR_ILLEGAL_PARAMETER = 47;
const SSLv31_ALERT_DESCR_UNKNOWN_CA = 48;
const SSLv31_ALERT_DESCR_ACCESS_DENIED = 49;
const SSLv31_ALERT_DESCR_DECODE_ERROR = 50;
const SSLv31_ALERT_DESCR_DECRYPT_ERROR = 51;
const SSLv31_ALERT_DESCR_EXPORT_RESTRICTION = 60;
const SSLv31_ALERT_DESCR_PROTOCOL_VERSION = 70;
const SSLv31_ALERT_DESCR_INSUFFICIENT_SECURITY = 71;
const SSLv31_ALERT_DESCR_INTERNAL_ERROR = 80;
const SSLv31_ALERT_DESCR_USER_CANCELED = 90;
const SSLv31_ALERT_DESCR_NO_RENEGOTIATION = 100;

# --- This is a table of all known alert descriptions.
# --- It can be used for detecting unknown alerts and for
# --- converting the alert descriptions constants into a human readable format.

const ssl_alert_desc: table[count] of string = {
	# --- SSLv2
	[SSLv2_PE_NO_CIPHER] = "SSLv2_PE_NO_CIPHER",
	[SSLv2_PE_NO_CERTIFICATE] = "SSLv2_PE_NO_CERTIFICATE",
	[SSLv2_PE_BAD_CERTIFICATE] = "SSLv2_PE_BAD_CERTIFICATE",
	[SSLv2_PE_UNSUPPORTED_CERTIFICATE_TYPE] =
		"SSLv2_PE_UNSUPPORTED_CERTIFICATE_TYPE",

	# --- sslv30
	[SSLv30_ALERT_DESCR_NO_CERTIFICATE] =
		"SSLv30_ALERT_DESCR_NO_CERTIFICATE",

	# --- sslv31
	[SSLv31_ALERT_DESCR_DESCRYPTION_FAILED] =
		"SSLv31_ALERT_DESCR_DESCRYPTION_FAILED",
	[SSLv31_ALERT_DESCR_RECORD_OVERFLOW] =
		"SSLv31_ALERT_DESCR_RECORD_OVERFLOW",
	[SSLv31_ALERT_DESCR_ILLEGAL_PARAMETER] =
		"SSLv31_ALERT_DESCR_ILLEGAL_PARAMETER",
	[SSLv31_ALERT_DESCR_UNKNOWN_CA] = "SSLv31_ALERT_DESCR_UNKNOWN_CA",
	[SSLv31_ALERT_DESCR_ACCESS_DENIED] = "SSLv31_ALERT_DESCR_ACCESS_DENIED",
	[SSLv31_ALERT_DESCR_DECODE_ERROR] = "SSLv31_ALERT_DESCR_DECODE_ERROR",
	[SSLv31_ALERT_DESCR_DECRYPT_ERROR] = "SSLv31_ALERT_DESCR_DECRYPT_ERROR",
	[SSLv31_ALERT_DESCR_EXPORT_RESTRICTION] =
		"SSLv31_ALERT_DESCR_EXPORT_RESTRICTION",
	[SSLv31_ALERT_DESCR_PROTOCOL_VERSION] =
		"SSLv31_ALERT_DESCR_PROTOCOL_VERSION",
	[SSLv31_ALERT_DESCR_INSUFFICIENT_SECURITY] =
		"SSLv31_ALERT_DESCR_INSUFFICIENT_SECURITY",
	[SSLv31_ALERT_DESCR_INTERNAL_ERROR] =
		"SSLv31_ALERT_DESCR_INTERNAL_ERROR",
	[SSLv31_ALERT_DESCR_USER_CANCELED] =
		"SSLv31_ALERT_DESCR_USER_CANCELED",
	[SSLv31_ALERT_DESCR_NO_RENEGOTIATION] =
		"SSLv31_ALERT_DESCR_NO_RENEGOTIATION",

	# -- sslv3.0 and sslv3.1
	[SSLv3x_ALERT_DESCR_CLOSE_NOTIFY] = "SSLv3x_ALERT_DESCR_CLOSE_NOTIFY",
	[SSLv3x_ALERT_DESCR_UNEXPECTED_MESSSAGE] =
		"SSLv3x_ALERT_DESCR_UNEXPECTED_MESSSAGE",
	[SSLv3x_ALERT_DESCR_BAD_RECORD_MAC] =
		"SSLv3x_ALERT_DESCR_BAD_RECORD_MAC",
	[SSLv3x_ALERT_DESCR_DECOMPRESSION_FAILURE] =
		"SSLv3x_ALERT_DESCR_DECOMPRESSION_FAILURE",
	[SSLv3x_ALERT_DESCR_HANDSHAKE_FAILURE] =
		"SSLv3x_ALERT_DESCR_HANDSHAKE_FAILURE",
	[SSLv3x_ALERT_DESCR_BAD_CERTIFICATE] =
		"SSLv3x_ALERT_DESCR_BAD_CERTIFICATE",
	[SSLv3x_ALERT_DESCR_UNSUPPORTED_CERTIFICATE] =
		"SSLv3x_ALERT_DESCR_UNSUPPORTED_CERTIFICATE",
	[SSLv3x_ALERT_DESCR_CERTIFICATE_REVOKED] =
		"SSLv3x_ALERT_DESCR_CERTIFICATE_REVOKED",
	[SSLv3x_ALERT_DESCR_CERTIFICATE_EXPIRED] =
		"SSLv3x_ALERT_DESCR_CERTIFICATE_EXPIRED",
	[SSLv3x_ALERT_DESCR_CERTIFICATE_UNKNOWN] =
		"SSLv3x_ALERT_DESCR_CERTIFICATE_UNKNOWN",
};

# --- definitions for SSLv2 error levels:
# NOTE: We currently use the SSLv3x alert levels "WARNING" and "FATAL"
#       for SSLv2, since SSLv2 does not support an explicit error level.

# --- definitions for SSLv3.0/SSLv3.1 alert levels
const SSLv3x_ALERT_LEVEL_WARNING = 1;
const SSLv3x_ALERT_LEVEL_FATAL = 2;

# --- This is a table of all known alert levels.
# --- It can be used for detecting unknown alert levels and for
# --- converting the alert level constants into a human readable format.

const ssl_alert_level: table[count] of string = {
	[SSLv3x_ALERT_LEVEL_WARNING] = "SSLv3x_ALERT_LEVEL_WARNING",
	[SSLv3x_ALERT_LEVEL_FATAL] = "SSLv3x_ALERT_LEVEL_FATAL",
};
