/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.util.UtfOps;

public class StringBinding
extends TupleBinding {
    public Object entryToObject(TupleInput tupleInput) {
        return tupleInput.readString();
    }

    public void objectToEntry(Object object, TupleOutput tupleOutput) {
        tupleOutput.writeString((String)object);
    }

    protected TupleOutput getTupleOutput(Object object) {
        return StringBinding.sizedOutput((String)object);
    }

    public static String entryToString(DatabaseEntry databaseEntry) {
        return StringBinding.entryToInput(databaseEntry).readString();
    }

    public static void stringToEntry(String string, DatabaseEntry databaseEntry) {
        StringBinding.outputToEntry(StringBinding.sizedOutput(string).writeString(string), databaseEntry);
    }

    private static TupleOutput sizedOutput(String string) {
        int n = string == null ? 1 : UtfOps.getByteLength(string.toCharArray());
        return new TupleOutput(new byte[++n]);
    }
}

