/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final boolean LOGGING = SystemProperties.getBoolean("findbugs.shutdownLogging");

    public static void runLogAtShutdown(Runnable r) {
        if (LOGGING) {
            Runtime.getRuntime().addShutdownHook(new Thread(r));
        }
    }

    public static int nullSafeHashcode(@CheckForNull Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public static <T> boolean nullSafeEquals(@CheckForNull T o1, @CheckForNull T o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static Reader getReader(InputStream in) throws UnsupportedEncodingException {
        return new InputStreamReader(in, "UTF-8");
    }

    public static Reader getFileReader(String filename) throws UnsupportedEncodingException, FileNotFoundException {
        return Util.getReader(new FileInputStream(filename));
    }

    public static Reader getFileReader(File filename) throws UnsupportedEncodingException, FileNotFoundException {
        return Util.getReader(new FileInputStream(filename));
    }

    public static Writer getWriter(OutputStream out) throws UnsupportedEncodingException, FileNotFoundException {
        return new OutputStreamWriter(out, "UTF-8");
    }

    public static Writer getFileWriter(String filename) throws UnsupportedEncodingException, FileNotFoundException {
        return Util.getWriter(new FileOutputStream(filename));
    }
}

