/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRoot;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TestSessionLabelProvider
extends LabelProvider {
    private final TestRunnerViewPart fTestRunnerPart;
    private final int fLayoutMode;

    public TestSessionLabelProvider(TestRunnerViewPart testRunnerPart, int layoutMode) {
        this.fTestRunnerPart = testRunnerPart;
        this.fLayoutMode = layoutMode;
    }

    public String getText(Object element) {
        if (element instanceof TestCaseElement) {
            TestCaseElement testCaseElement = (TestCaseElement)element;
            String testMethodName = testCaseElement.getTestMethodName();
            if (this.fLayoutMode == 1) {
                return this.getElementLabel(testMethodName, testCaseElement);
            }
            String className = testCaseElement.getClassName();
            return Messages.format(JUnitMessages.TestSessionLabelProvider_testMethodName_className, new Object[]{testMethodName, className});
        }
        if (element instanceof TestElement) {
            TestElement testElement = (TestElement)element;
            String testName = testElement.getTestName();
            return this.getElementLabel(testName, testElement);
        }
        throw new IllegalArgumentException(String.valueOf(element));
    }

    private String getElementLabel(String name, TestElement testElement) {
        if (this.fLayoutMode == 1 && testElement.getParent() instanceof TestRoot) {
            String testKindDisplayName = this.fTestRunnerPart.getTestKindDisplayName();
            if (testKindDisplayName == null) {
                return name;
            }
            return Messages.format(JUnitMessages.TestSessionLabelProvider_testName_JUnitVersion, new Object[]{name, testKindDisplayName});
        }
        return name;
    }

    public Image getImage(Object element) {
        if (element instanceof TestCaseElement) {
            TestCaseElement testCaseElement = (TestCaseElement)element;
            if (testCaseElement.isIgnored()) {
                return this.fTestRunnerPart.fTestIgnoredIcon;
            }
            TestElement.Status status = testCaseElement.getStatus();
            if (status.isNotRun()) {
                return this.fTestRunnerPart.fTestIcon;
            }
            if (status.isRunning()) {
                return this.fTestRunnerPart.fTestRunningIcon;
            }
            if (status.isError()) {
                return this.fTestRunnerPart.fTestErrorIcon;
            }
            if (status.isFailure()) {
                return this.fTestRunnerPart.fTestFailIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fTestOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        if (element instanceof TestSuiteElement) {
            TestElement.Status status = ((TestSuiteElement)element).getStatus();
            if (status.isNotRun()) {
                return this.fTestRunnerPart.fSuiteIcon;
            }
            if (status.isRunning()) {
                return this.fTestRunnerPart.fSuiteRunningIcon;
            }
            if (status.isError()) {
                return this.fTestRunnerPart.fSuiteErrorIcon;
            }
            if (status.isFailure()) {
                return this.fTestRunnerPart.fSuiteFailIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fSuiteOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        throw new IllegalArgumentException(String.valueOf(element));
    }
}

