/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.TransliteratorIDParser;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;

class AnyTransliterator
extends Transliterator {
    static final char TARGET_SEP = '-';
    static final char VARIANT_SEP = '/';
    static final String ANY = "Any";
    static final String NULL_ID = "Null";
    static final String LATIN_PIVOT = "-Latin;Latin-";
    private Map cache;
    private String target;
    private int targetScript;

    protected void handleTransliterate(Replaceable text, Transliterator.Position pos, boolean isIncremental) {
        int allStart = pos.start;
        int allLimit = pos.limit;
        ScriptRunIterator it = new ScriptRunIterator(text, pos.contextStart, pos.contextLimit);
        while (it.next()) {
            if (it.limit <= allStart) continue;
            Transliterator t = this.getTransliterator(it.scriptCode);
            if (t == null) {
                pos.start = it.limit;
                continue;
            }
            boolean incremental = isIncremental && it.limit >= allLimit;
            pos.start = Math.max(allStart, it.start);
            int limit = pos.limit = Math.min(allLimit, it.limit);
            t.filteredTransliterate(text, pos, incremental);
            int delta = pos.limit - limit;
            it.adjustLimit(delta);
            if (it.limit >= (allLimit += delta)) break;
        }
        pos.limit = allLimit;
    }

    private AnyTransliterator(String id, String theTarget, String theVariant, int theTargetScript) {
        super(id, null);
        this.targetScript = theTargetScript;
        this.cache = new HashMap();
        this.target = theTarget;
        if (theVariant.length() > 0) {
            this.target = String.valueOf(theTarget) + '/' + theVariant;
        }
    }

    private Transliterator getTransliterator(int source) {
        if (source == this.targetScript || source == -1) {
            return null;
        }
        Integer key = new Integer(source);
        Transliterator t = (Transliterator)this.cache.get(key);
        if (t == null) {
            String sourceName = UScript.getName(source);
            String id = String.valueOf(sourceName) + '-' + this.target;
            t = Transliterator.getInstance(id, 0);
            if (t == null) {
                id = String.valueOf(sourceName) + LATIN_PIVOT + this.target;
                t = Transliterator.getInstance(id, 0);
            }
            if (t != null) {
                this.cache.put(key, t);
            }
        }
        return t;
    }

    static void register() {
        HashSet<String> seen = new HashSet<String>();
        Enumeration s = Transliterator.getAvailableSources();
        while (s.hasMoreElements()) {
            String source = (String)s.nextElement();
            if (source.equalsIgnoreCase(ANY)) continue;
            Enumeration t = Transliterator.getAvailableTargets(source);
            while (t.hasMoreElements()) {
                String target = (String)t.nextElement();
                if (seen.contains(target)) continue;
                seen.add(target);
                int targetScript = AnyTransliterator.scriptNameToCode(target);
                if (targetScript == -1) continue;
                Enumeration v = Transliterator.getAvailableVariants(source, target);
                while (v.hasMoreElements()) {
                    String variant = (String)v.nextElement();
                    String id = TransliteratorIDParser.STVtoID(ANY, target, variant);
                    AnyTransliterator trans = new AnyTransliterator(id, target, variant, targetScript);
                    Transliterator.registerInstance(trans);
                    Transliterator.registerSpecialInverse(target, NULL_ID, false);
                }
            }
        }
    }

    private static int scriptNameToCode(String name) {
        try {
            int[] codes = UScript.getCode(name);
            return codes != null ? codes[0] : -1;
        }
        catch (MissingResourceException missingResourceException) {
            return -1;
        }
    }

    private static class ScriptRunIterator {
        private Replaceable text;
        private int textStart;
        private int textLimit;
        public int scriptCode;
        public int start;
        public int limit;

        public ScriptRunIterator(Replaceable text, int start, int limit) {
            this.text = text;
            this.textStart = start;
            this.textLimit = limit;
            this.limit = start;
        }

        /*
         * Unable to fully structure code
         */
        public boolean next() {
            this.scriptCode = -1;
            this.start = this.limit;
            if (this.start != this.textLimit) ** GOTO lbl7
            return false;
            while ((s = UScript.getScript(ch = this.text.char32At(this.start - 1))) == 0 || s == 1) {
                --this.start;
lbl7:
                // 2 sources

                if (this.start > this.textStart) continue;
            }
            while (this.limit < this.textLimit) {
                ch = this.text.char32At(this.limit);
                s = UScript.getScript(ch);
                if (s != 0 && s != 1) {
                    if (this.scriptCode == -1) {
                        this.scriptCode = s;
                    } else if (s != this.scriptCode) break;
                }
                ++this.limit;
            }
            return true;
        }

        public void adjustLimit(int delta) {
            this.limit += delta;
            this.textLimit += delta;
        }
    }
}

