/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.BaseKeyring;
import gnu.javax.crypto.keyring.CertPathEntry;
import gnu.javax.crypto.keyring.CompressedEntry;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.IPrivateKeyring;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.MaskableEnvelopeEntry;
import gnu.javax.crypto.keyring.PasswordAuthenticatedEntry;
import gnu.javax.crypto.keyring.PasswordEncryptedEntry;
import gnu.javax.crypto.keyring.PrivateKeyEntry;
import gnu.javax.crypto.keyring.Properties;
import gnu.javax.crypto.keyring.PublicKeyEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;

public class GnuPrivateKeyring
extends BaseKeyring
implements IPrivateKeyring {
    private static final Logger log = Logger.getLogger(GnuPrivateKeyring.class$("gnu.javax.crypto.keyring.GnuPrivateKeyring").getName());
    public static final int USAGE = 3;
    protected String mac;
    protected int maclen;
    protected String cipher;
    protected String mode;
    protected int keylen;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public GnuPrivateKeyring(String string, int n, String string2, String string3, int n2) {
        this.keyring = new PasswordAuthenticatedEntry(string, n, new Properties());
        this.keyring2 = new CompressedEntry(new Properties());
        this.keyring.add(this.keyring2);
        this.mac = string;
        this.maclen = n;
        this.cipher = string2;
        this.mode = string3;
        this.keylen = n2;
    }

    public GnuPrivateKeyring() {
        this("HMAC-SHA-1", 20, "AES", "OFB", 16);
    }

    public boolean containsPrivateKey(String string) {
        boolean bl = false;
        if (this.containsAlias(string)) {
            Iterator iterator = this.get(string).iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof PasswordAuthenticatedEntry)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public Key getPrivateKey(String string, char[] cArray) throws UnrecoverableKeyException {
        Key key = null;
        if (this.containsAlias(string)) {
            Object object;
            PasswordAuthenticatedEntry passwordAuthenticatedEntry = null;
            Object object2 = this.get(string).iterator();
            while (object2.hasNext()) {
                object = (Entry)object2.next();
                if (!(object instanceof PasswordAuthenticatedEntry)) continue;
                passwordAuthenticatedEntry = (PasswordAuthenticatedEntry)object;
                break;
            }
            if (passwordAuthenticatedEntry != null) {
                Entry entry;
                try {
                    passwordAuthenticatedEntry.verify(cArray);
                }
                catch (Exception exception) {
                    throw new UnrecoverableKeyException("authentication failed");
                }
                object2 = null;
                object = passwordAuthenticatedEntry.getEntries().iterator();
                while (object.hasNext()) {
                    entry = (Entry)object.next();
                    if (!(entry instanceof PasswordEncryptedEntry)) continue;
                    object2 = (PasswordEncryptedEntry)entry;
                    break;
                }
                if (object2 != null) {
                    try {
                        ((PasswordEncryptedEntry)object2).decrypt(cArray);
                    }
                    catch (Exception exception) {
                        log.throwing(this.getClass().getName(), "getPrivateKey", exception);
                        throw new UnrecoverableKeyException("decryption failed");
                    }
                    object = ((MaskableEnvelopeEntry)object2).get(string).iterator();
                    while (object.hasNext()) {
                        entry = (Entry)object.next();
                        if (!(entry instanceof PrivateKeyEntry)) continue;
                        key = ((PrivateKeyEntry)entry).getKey();
                        break;
                    }
                }
            }
        }
        return key;
    }

    public void putPrivateKey(String string, Key key, char[] cArray) {
        block4: {
            if (this.containsPrivateKey(string)) break block4;
            string = this.fixAlias(string);
            Properties properties = new Properties();
            properties.put("alias", string);
            PrivateKeyEntry privateKeyEntry = new PrivateKeyEntry(key, new Date(), properties);
            PasswordEncryptedEntry passwordEncryptedEntry = new PasswordEncryptedEntry(this.cipher, this.mode, this.keylen, new Properties());
            passwordEncryptedEntry.add(privateKeyEntry);
            try {
                passwordEncryptedEntry.encode(null, cArray);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.toString());
            }
            PasswordAuthenticatedEntry passwordAuthenticatedEntry = new PasswordAuthenticatedEntry(this.mac, this.maclen, new Properties());
            passwordAuthenticatedEntry.add(passwordEncryptedEntry);
            try {
                passwordAuthenticatedEntry.encode(null, cArray);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.toString());
            }
            this.keyring.add(passwordAuthenticatedEntry);
        }
    }

    public boolean containsPublicKey(String string) {
        boolean bl = false;
        if (this.containsAlias(string)) {
            Iterator iterator = this.get(string).iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof PublicKeyEntry)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public PublicKey getPublicKey(String string) {
        PublicKey publicKey = null;
        if (this.containsAlias(string)) {
            Iterator iterator = this.get(string).iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (!(entry instanceof PublicKeyEntry)) continue;
                publicKey = ((PublicKeyEntry)entry).getKey();
                break;
            }
        }
        return publicKey;
    }

    public void putPublicKey(String string, PublicKey publicKey) {
        block0: {
            if (this.containsPublicKey(string)) break block0;
            Properties properties = new Properties();
            properties.put("alias", this.fixAlias(string));
            this.add(new PublicKeyEntry(publicKey, new Date(), properties));
        }
    }

    public boolean containsCertPath(String string) {
        boolean bl = false;
        if (this.containsAlias(string)) {
            Iterator iterator = this.get(string).iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof CertPathEntry)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public Certificate[] getCertPath(String string) {
        Certificate[] certificateArray = null;
        if (this.containsAlias(string)) {
            Iterator iterator = this.get(string).iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (!(entry instanceof CertPathEntry)) continue;
                certificateArray = ((CertPathEntry)entry).getCertPath();
                break;
            }
        }
        return certificateArray;
    }

    public void putCertPath(String string, Certificate[] certificateArray) {
        block0: {
            if (this.containsCertPath(string)) break block0;
            Properties properties = new Properties();
            properties.put("alias", this.fixAlias(string));
            this.add(new CertPathEntry(certificateArray, new Date(), properties));
        }
    }

    protected void load(InputStream inputStream, char[] cArray) throws IOException {
        if (inputStream.read() != 3) {
            throw new MalformedKeyringException("incompatible keyring usage");
        }
        if (inputStream.read() != 3) {
            throw new MalformedKeyringException("expecting password-authenticated entry tag");
        }
        this.keyring = PasswordAuthenticatedEntry.decode(new DataInputStream(inputStream), cArray);
    }

    protected void store(OutputStream outputStream, char[] cArray) throws IOException {
        outputStream.write(3);
        this.keyring.encode(new DataOutputStream(outputStream), cArray);
    }
}

