/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public final class Math {
    private static Random rand;
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;

    private Math() {
    }

    public static int abs(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    public static long abs(long l) {
        if (l < 0L) {
            return -l;
        }
        return l;
    }

    public static float abs(float f) {
        if (f <= 0.0f) {
            return 0.0f - f;
        }
        return f;
    }

    public static double abs(double d) {
        if (d <= 0.0) {
            return 0.0 - d;
        }
        return d;
    }

    public static int min(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    public static long min(long l, long l2) {
        if (l < l2) {
            return l;
        }
        return l2;
    }

    public static float min(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f) {
            return -(-f - f2);
        }
        if (f < f2) {
            return f;
        }
        return f2;
    }

    public static double min(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0) {
            return -(-d - d2);
        }
        if (d < d2) {
            return d;
        }
        return d2;
    }

    public static int max(int n, int n2) {
        if (n > n2) {
            return n;
        }
        return n2;
    }

    public static long max(long l, long l2) {
        if (l > l2) {
            return l;
        }
        return l2;
    }

    public static float max(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f) {
            return f - -f2;
        }
        if (f > f2) {
            return f;
        }
        return f2;
    }

    public static double max(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0) {
            return d - -d2;
        }
        if (d > d2) {
            return d;
        }
        return d2;
    }

    public static native double sin(double var0);

    public static native double cos(double var0);

    public static native double tan(double var0);

    public static native double asin(double var0);

    public static native double acos(double var0);

    public static native double atan(double var0);

    public static native double atan2(double var0, double var2);

    public static native double exp(double var0);

    public static native double log(double var0);

    public static native double sqrt(double var0);

    public static native double pow(double var0, double var2);

    public static native double IEEEremainder(double var0, double var2);

    public static native double ceil(double var0);

    public static native double floor(double var0);

    public static native double rint(double var0);

    public static int round(float f) {
        if (f != f) {
            return 0;
        }
        return (int)Math.floor(f + 0.5f);
    }

    public static long round(double d) {
        if (d != d) {
            return 0L;
        }
        return (long)Math.floor(d + 0.5);
    }

    public static synchronized double random() {
        if (rand == null) {
            rand = new Random();
        }
        return rand.nextDouble();
    }

    public static double toRadians(double d) {
        return d * Math.PI / 180.0;
    }

    public static double toDegrees(double d) {
        return d * 180.0 / Math.PI;
    }

    public static native double cbrt(double var0);

    public static native double cosh(double var0);

    public static native double expm1(double var0);

    public static native double hypot(double var0, double var2);

    public static native double log10(double var0);

    public static native double log1p(double var0);

    public static double signum(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d > 0.0) {
            return 1.0;
        }
        if (d < 0.0) {
            return -1.0;
        }
        return d;
    }

    public static float signum(float f) {
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        if (f > 0.0f) {
            return 1.0f;
        }
        if (f < 0.0f) {
            return -1.0f;
        }
        return f;
    }

    public static native double sinh(double var0);

    public static native double tanh(double var0);

    public static double ulp(double d) {
        long l;
        if (Double.isNaN(d)) {
            return d;
        }
        if (Double.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == 0.0) {
            return Double.MIN_VALUE;
        }
        long l2 = Double.doubleToLongBits(d);
        int n = 52;
        int n2 = 11;
        long l3 = (1L << (n & 0x3F)) - 1L;
        long l4 = l2 & l3;
        long l5 = (1L << (n2 & 0x3F)) - 1L;
        long l6 = l2 >>> (n & 0x3F) & l5;
        if (l6 == 0L) {
            long l7 = l6 << (n & 0x3F) | 1L;
            return Double.longBitsToDouble(l7);
        }
        long l8 = l6 - (long)n;
        if (l8 > 0L) {
            l = 0L;
        } else {
            l = 1L << ((int)(1L - l8) & 0x3F);
            l8 = 0L;
        }
        return Double.longBitsToDouble(l8 << (n & 0x3F) | l);
    }

    public static float ulp(float f) {
        int n;
        if (Float.isNaN(f)) {
            return f;
        }
        if (Float.isInfinite(f)) {
            return Float.POSITIVE_INFINITY;
        }
        if ((double)f == 0.0) {
            return Float.MIN_VALUE;
        }
        int n2 = Float.floatToIntBits(f);
        int n3 = 23;
        int n4 = 8;
        int n5 = (1 << (n3 & 0x1F)) - 1;
        int n6 = n2 & n5;
        int n7 = (1 << (n4 & 0x1F)) - 1;
        int n8 = n2 >>> (n3 & 0x1F) & n7;
        if (n8 == 0) {
            int n9 = n8 << (n3 & 0x1F) | 1;
            return Float.intBitsToFloat(n9);
        }
        int n10 = n8 - n3;
        if (n10 > 0) {
            n = 0;
        } else {
            n = 1 << (1 - n10 & 0x1F);
            n10 = 0;
        }
        return Float.intBitsToFloat(n10 << (n3 & 0x1F) | n);
    }
}

