/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedList
extends AbstractSequentialList
implements List,
Cloneable,
Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    transient Entry first;
    transient Entry last;
    transient int size;

    private /* synthetic */ void finit$() {
        this.size = 0;
    }

    Entry getEntry(int n) {
        Entry entry;
        if (n < this.size / 2) {
            entry = this.first;
            while (n-- > 0) {
                entry = entry.next;
            }
        } else {
            entry = this.last;
            while (++n < this.size) {
                entry = entry.previous;
            }
        }
        return entry;
    }

    void removeEntry(Entry entry) {
        ++this.modCount;
        --this.size;
        if (this.size == 0) {
            this.last = null;
            this.first = null;
        } else if (entry == this.first) {
            this.first = entry.next;
            entry.next.previous = null;
        } else if (entry == this.last) {
            this.last = entry.previous;
            entry.previous.next = null;
        } else {
            entry.next.previous = entry.previous;
            entry.previous.next = entry.next;
        }
    }

    private void checkBoundsInclusive(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
    }

    private void checkBoundsExclusive(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
    }

    public LinkedList() {
        this.finit$();
    }

    public LinkedList(Collection collection) {
        this.finit$();
        this.addAll(collection);
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.first.data;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.last.data;
    }

    public Object removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        --this.size;
        Object object = this.first.data;
        if (this.first.next != null) {
            this.first.next.previous = null;
        } else {
            this.last = null;
        }
        this.first = this.first.next;
        return object;
    }

    public Object removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        --this.size;
        Object object = this.last.data;
        if (this.last.previous != null) {
            this.last.previous.next = null;
        } else {
            this.first = null;
        }
        this.last = this.last.previous;
        return object;
    }

    public void addFirst(Object object) {
        Entry entry = new Entry(object);
        ++this.modCount;
        if (this.size == 0) {
            this.first = this.last = entry;
        } else {
            entry.next = this.first;
            this.first.previous = entry;
            this.first = entry;
        }
        ++this.size;
    }

    public void addLast(Object object) {
        this.addLastEntry(new Entry(object));
    }

    private void addLastEntry(Entry entry) {
        ++this.modCount;
        if (this.size == 0) {
            this.first = this.last = entry;
        } else {
            entry.previous = this.last;
            this.last.next = entry;
            this.last = entry;
        }
        ++this.size;
    }

    public boolean contains(Object object) {
        Entry entry = this.first;
        while (entry != null) {
            if (AbstractCollection.equals(object, entry.data)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean add(Object object) {
        this.addLastEntry(new Entry(object));
        return true;
    }

    public boolean remove(Object object) {
        Entry entry = this.first;
        while (entry != null) {
            if (AbstractCollection.equals(object, entry.data)) {
                this.removeEntry(entry);
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    public boolean addAll(int n, Collection collection) {
        this.checkBoundsInclusive(n);
        int n2 = collection.size();
        if (n2 == 0) {
            return false;
        }
        Iterator iterator = collection.iterator();
        Entry entry = null;
        Entry entry2 = null;
        if (n != this.size) {
            entry = this.getEntry(n);
            entry2 = entry.previous;
        } else {
            entry2 = this.last;
        }
        Entry entry3 = new Entry(iterator.next());
        entry3.previous = entry2;
        Entry entry4 = entry3;
        Entry entry5 = entry3;
        for (int i = 1; i < n2; ++i) {
            entry3 = new Entry(iterator.next());
            entry3.previous = entry4;
            entry4.next = entry3;
            entry4 = entry3;
        }
        ++this.modCount;
        this.size += n2;
        entry4.next = entry;
        if (entry != null) {
            entry.previous = entry3;
        } else {
            this.last = entry3;
        }
        if (entry2 != null) {
            entry2.next = entry5;
        } else {
            this.first = entry5;
        }
        return true;
    }

    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            this.first = null;
            this.last = null;
            this.size = 0;
        }
    }

    public Object get(int n) {
        this.checkBoundsExclusive(n);
        return this.getEntry((int)n).data;
    }

    public Object set(int n, Object object) {
        this.checkBoundsExclusive(n);
        Entry entry = this.getEntry(n);
        Object object2 = entry.data;
        entry.data = object;
        return object2;
    }

    public void add(int n, Object object) {
        this.checkBoundsInclusive(n);
        Entry entry = new Entry(object);
        if (n < this.size) {
            Entry entry2;
            ++this.modCount;
            entry.next = entry2 = this.getEntry(n);
            entry.previous = entry2.previous;
            if (entry2.previous == null) {
                this.first = entry;
            } else {
                entry2.previous.next = entry;
            }
            entry2.previous = entry;
            ++this.size;
        } else {
            this.addLastEntry(entry);
        }
    }

    public Object remove(int n) {
        this.checkBoundsExclusive(n);
        Entry entry = this.getEntry(n);
        this.removeEntry(entry);
        return entry.data;
    }

    public int indexOf(Object object) {
        int n = 0;
        Entry entry = this.first;
        while (entry != null) {
            if (AbstractCollection.equals(object, entry.data)) {
                return n;
            }
            ++n;
            entry = entry.next;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n = this.size - 1;
        Entry entry = this.last;
        while (entry != null) {
            if (AbstractCollection.equals(object, entry.data)) {
                return n;
            }
            --n;
            entry = entry.previous;
        }
        return -1;
    }

    public ListIterator listIterator(int n) {
        this.checkBoundsInclusive(n);
        return new LinkedListItr(this, n);
    }

    public Object clone() {
        LinkedList linkedList = null;
        try {
            linkedList = (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        linkedList.clear();
        linkedList.addAll(this);
        return linkedList;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        Entry entry = this.first;
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = entry.data;
            entry = entry.next;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        } else if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        Entry entry = this.first;
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = entry.data;
            entry = entry.next;
        }
        return objectArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Entry entry = this.first;
        while (entry != null) {
            objectOutputStream.writeObject(entry.data);
            entry = entry.next;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        while (--n >= 0) {
            this.addLastEntry(new Entry(objectInputStream.readObject()));
        }
    }

    private final class LinkedListItr
    implements ListIterator {
        private /* synthetic */ LinkedList this$0;
        private int knownMod;
        private Entry next;
        private Entry previous;
        private Entry lastReturned;
        private int position;

        private /* synthetic */ void finit$() {
            this.knownMod = this.this$0.modCount;
        }

        LinkedListItr(LinkedList linkedList, int n) {
            this.this$0 = linkedList;
            this.finit$();
            if (n == linkedList.size) {
                this.next = null;
                this.previous = linkedList.last;
            } else {
                this.next = linkedList.getEntry(n);
                this.previous = this.next.previous;
            }
            this.position = n;
        }

        private void checkMod() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        public int nextIndex() {
            return this.position;
        }

        public int previousIndex() {
            return this.position - 1;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public boolean hasPrevious() {
            return this.previous != null;
        }

        public Object next() {
            this.checkMod();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ++this.position;
            this.lastReturned = this.previous = this.next;
            this.next = this.lastReturned.next;
            return this.lastReturned.data;
        }

        public Object previous() {
            this.checkMod();
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            --this.position;
            this.lastReturned = this.next = this.previous;
            this.previous = this.lastReturned.previous;
            return this.lastReturned.data;
        }

        public void remove() {
            this.checkMod();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this.lastReturned == this.previous) {
                --this.position;
            }
            this.next = this.lastReturned.next;
            this.previous = this.lastReturned.previous;
            this.this$0.removeEntry(this.lastReturned);
            ++this.knownMod;
            this.lastReturned = null;
        }

        public void add(Object object) {
            this.checkMod();
            ++this.this$0.modCount;
            ++this.knownMod;
            ++this.this$0.size;
            ++this.position;
            Entry entry = new Entry(object);
            entry.previous = this.previous;
            entry.next = this.next;
            if (this.previous != null) {
                this.previous.next = entry;
            } else {
                this.this$0.first = entry;
            }
            if (this.next != null) {
                this.next.previous = entry;
            } else {
                this.this$0.last = entry;
            }
            this.previous = entry;
            this.lastReturned = null;
        }

        public void set(Object object) {
            this.checkMod();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.lastReturned.data = object;
        }
    }

    private static final class Entry {
        Object data;
        Entry next;
        Entry previous;

        Entry(Object object) {
            this.data = object;
        }
    }
}

