/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.ClassWriter;
import com.sun.java.util.jar.pack.NativeUnpack;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.PackageReader;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.Utils;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;

public class UnpackerImpl
implements Pack200.Unpacker {
    final PropMap _props = new PropMap();
    Object _nunp;

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._props.addListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._props.removeListener(propertyChangeListener);
    }

    public SortedMap properties() {
        return this._props;
    }

    public String toString() {
        return Utils.getVersionString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpack(InputStream inputStream, JarOutputStream jarOutputStream) throws IOException {
        assert (Utils.currentInstance.get() == null);
        TimeZone timeZone = this._props.getBoolean("com.sun.java.util.jar.pack.default.timezone") ? null : TimeZone.getDefault();
        try {
            Utils.currentInstance.set(this);
            if (timeZone != null) {
                TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
            }
            int n = this._props.getInteger("com.sun.java.util.jar.pack.verbose");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            if (Utils.isJarMagic(Utils.readMagic(bufferedInputStream))) {
                if (n > 0) {
                    Utils.log.info("Copying unpacked JAR file...");
                }
                Utils.copyJarFile(new JarInputStream(bufferedInputStream), jarOutputStream);
            } else if (this._props.getBoolean("com.sun.java.util.jar.pack.disable.native")) {
                new DoUnpack().run(bufferedInputStream, jarOutputStream);
                bufferedInputStream.close();
                Utils.markJarFile(jarOutputStream);
            } else {
                new NativeUnpack(this).run(bufferedInputStream, jarOutputStream);
                bufferedInputStream.close();
                Utils.markJarFile(jarOutputStream);
            }
        }
        finally {
            this._nunp = null;
            Utils.currentInstance.set(null);
            if (timeZone != null) {
                TimeZone.setDefault(timeZone);
            }
        }
    }

    @Override
    public void unpack(File file, JarOutputStream jarOutputStream) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.unpack(fileInputStream, jarOutputStream);
        if (this._props.getBoolean("com.sun.java.util.jar.pack.unpack.remove.packfile")) {
            file.delete();
        }
    }

    private class DoUnpack {
        final int verbose;
        final Package pkg;
        final boolean keepModtime;
        final boolean keepDeflateHint;
        final int modtime;
        final boolean deflateHint;
        final CRC32 crc;
        final ByteArrayOutputStream bufOut;
        final OutputStream crcOut;

        private DoUnpack() {
            this.verbose = UnpackerImpl.this._props.getInteger("com.sun.java.util.jar.pack.verbose");
            UnpackerImpl.this._props.setInteger("unpack.progress", 0);
            this.pkg = new Package();
            this.keepModtime = "keep".equals(UnpackerImpl.this._props.getProperty("com.sun.java.util.jar.pack.unpack.modification.time", "keep"));
            this.keepDeflateHint = "keep".equals(UnpackerImpl.this._props.getProperty("unpack.deflate.hint", "keep"));
            this.modtime = !this.keepModtime ? UnpackerImpl.this._props.getTime("com.sun.java.util.jar.pack.unpack.modification.time") : this.pkg.default_modtime;
            this.deflateHint = this.keepDeflateHint ? false : UnpackerImpl.this._props.getBoolean("unpack.deflate.hint");
            this.crc = new CRC32();
            this.bufOut = new ByteArrayOutputStream();
            this.crcOut = new CheckedOutputStream(this.bufOut, this.crc);
        }

        public void run(BufferedInputStream bufferedInputStream, JarOutputStream jarOutputStream) throws IOException {
            if (this.verbose > 0) {
                UnpackerImpl.this._props.list(System.out);
            }
            int n = 1;
            while (true) {
                this.unpackSegment(bufferedInputStream, jarOutputStream);
                if (!Utils.isPackMagic(Utils.readMagic(bufferedInputStream))) break;
                if (this.verbose > 0) {
                    Utils.log.info("Finished segment #" + n);
                }
                ++n;
            }
        }

        private void unpackSegment(InputStream inputStream, JarOutputStream jarOutputStream) throws IOException {
            UnpackerImpl.this._props.setProperty("unpack.progress", "0");
            new PackageReader(this.pkg, inputStream).read();
            if (UnpackerImpl.this._props.getBoolean("unpack.strip.debug")) {
                this.pkg.stripAttributeKind("Debug");
            }
            if (UnpackerImpl.this._props.getBoolean("unpack.strip.compile")) {
                this.pkg.stripAttributeKind("Compile");
            }
            UnpackerImpl.this._props.setProperty("unpack.progress", "50");
            this.pkg.ensureAllClassFiles();
            HashSet hashSet = new HashSet(this.pkg.getClasses());
            for (Package.File file : this.pkg.getFiles()) {
                boolean bl;
                String string = file.nameString;
                JarEntry jarEntry = new JarEntry(Utils.getJarEntryName(string));
                boolean bl2 = this.keepDeflateHint ? (file.options & 1) != 0 || (this.pkg.default_options & 0x20) != 0 : this.deflateHint;
                boolean bl3 = bl = !bl2;
                if (bl) {
                    this.crc.reset();
                }
                this.bufOut.reset();
                if (file.isClassStub()) {
                    Package.Class clazz = file.getStubClass();
                    assert (clazz != null);
                    new ClassWriter(clazz, bl ? this.crcOut : this.bufOut).write();
                    hashSet.remove(clazz);
                } else {
                    file.writeTo(bl ? this.crcOut : this.bufOut);
                }
                jarEntry.setMethod(bl2 ? 8 : 0);
                if (bl) {
                    if (this.verbose > 0) {
                        Utils.log.info("stored size=" + this.bufOut.size() + " and crc=" + this.crc.getValue());
                    }
                    jarEntry.setMethod(0);
                    jarEntry.setSize(this.bufOut.size());
                    jarEntry.setCrc(this.crc.getValue());
                }
                if (this.keepModtime) {
                    jarEntry.setTime(file.modtime);
                    jarEntry.setTime((long)file.modtime * 1000L);
                } else {
                    jarEntry.setTime((long)this.modtime * 1000L);
                }
                jarOutputStream.putNextEntry(jarEntry);
                this.bufOut.writeTo(jarOutputStream);
                jarOutputStream.closeEntry();
                if (this.verbose <= 0) continue;
                Utils.log.info("Writing " + Utils.zeString(jarEntry));
            }
            assert (hashSet.isEmpty());
            UnpackerImpl.this._props.setProperty("unpack.progress", "100");
            this.pkg.reset();
        }
    }
}

