/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file.attribute;

import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public final class FileTime
implements Comparable<FileTime> {
    private final long value;
    private final TimeUnit unit;
    private String valueAsString;

    private FileTime(long l, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException();
        }
        this.value = l;
        this.unit = timeUnit;
    }

    public static FileTime from(long l, TimeUnit timeUnit) {
        return new FileTime(l, timeUnit);
    }

    public static FileTime fromMillis(long l) {
        return new FileTime(l, TimeUnit.MILLISECONDS);
    }

    public long to(TimeUnit timeUnit) {
        return timeUnit.convert(this.value, this.unit);
    }

    public long toMillis() {
        return this.unit.toMillis(this.value);
    }

    public boolean equals(Object object) {
        return object instanceof FileTime ? this.compareTo((FileTime)object) == 0 : false;
    }

    public int hashCode() {
        long l = this.toMillis();
        return (int)(l ^ l >>> 32);
    }

    @Override
    public int compareTo(FileTime fileTime) {
        long l;
        long l2;
        if (this.unit == fileTime.unit) {
            return this.value < fileTime.value ? -1 : (this.value == fileTime.value ? 0 : 1);
        }
        long l3 = this.unit.toDays(this.value);
        if (l3 != (l2 = fileTime.unit.toDays(fileTime.value))) {
            return l3 < l2 ? -1 : 1;
        }
        long l4 = this.remainderInNanos(l3);
        return l4 < (l = fileTime.remainderInNanos(l2)) ? -1 : (l4 == l ? 0 : 1);
    }

    private long remainderInNanos(long l) {
        long l2;
        switch (this.unit) {
            case DAYS: {
                l2 = 1L;
                break;
            }
            case HOURS: {
                l2 = 24L;
                break;
            }
            case MINUTES: {
                l2 = 1440L;
                break;
            }
            case SECONDS: {
                l2 = 86400L;
                break;
            }
            case MILLISECONDS: {
                l2 = 86400000L;
                break;
            }
            case MICROSECONDS: {
                l2 = 86400000000L;
                break;
            }
            case NANOSECONDS: {
                l2 = 86400000000000L;
                break;
            }
            default: {
                throw new AssertionError((Object)"Unit not handled");
            }
        }
        long l3 = this.value - l * l2;
        return this.unit.toNanos(l3);
    }

    public String toString() {
        String string = this.valueAsString;
        if (string == null) {
            long l = this.toMillis();
            String string2 = "";
            if (this.unit.compareTo(TimeUnit.SECONDS) < 0) {
                int n;
                long l2;
                switch (this.unit) {
                    case MILLISECONDS: {
                        l2 = 1000L;
                        n = 3;
                        break;
                    }
                    case MICROSECONDS: {
                        l2 = 1000000L;
                        n = 6;
                        break;
                    }
                    case NANOSECONDS: {
                        l2 = 1000000000L;
                        n = 9;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unit not handled");
                    }
                }
                long l3 = this.value % l2;
                if (l3 != 0L) {
                    if (l3 < 0L) {
                        l3 += l2;
                        if (l != Long.MIN_VALUE) {
                            --l;
                        }
                    }
                    String string3 = Long.toString(l3);
                    int n2 = string3.length();
                    n -= n2;
                    StringBuilder stringBuilder = new StringBuilder(".");
                    while (n-- > 0) {
                        stringBuilder.append('0');
                    }
                    if (string3.charAt(n2 - 1) == '0') {
                        --n2;
                        while (string3.charAt(n2 - 1) == '0') {
                            --n2;
                        }
                        stringBuilder.append(string3.substring(0, n2));
                    } else {
                        stringBuilder.append(string3);
                    }
                    string2 = stringBuilder.toString();
                }
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.ROOT);
            if (this.value < 0L) {
                gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
            }
            gregorianCalendar.setTimeInMillis(l);
            String string4 = gregorianCalendar.get(0) == 0 ? "-" : "";
            this.valueAsString = string = new Formatter(Locale.ROOT).format("%s%tFT%tR:%tS%sZ", string4, gregorianCalendar, gregorianCalendar, gregorianCalendar, string2).toString();
        }
        return string;
    }
}

