/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.regex.ASCII;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public final class Matcher
implements MatchResult {
    Pattern parentPattern;
    int[] groups;
    int from;
    int to;
    int lookbehindTo;
    CharSequence text;
    static final int ENDANCHOR = 1;
    static final int NOANCHOR = 0;
    int acceptMode = 0;
    int first = -1;
    int last = 0;
    int oldLast = -1;
    int lastAppendPosition = 0;
    int[] locals;
    boolean hitEnd;
    boolean requireEnd;
    boolean transparentBounds = false;
    boolean anchoringBounds = true;

    Matcher() {
    }

    Matcher(Pattern pattern, CharSequence charSequence) {
        this.parentPattern = pattern;
        this.text = charSequence;
        int n = Math.max(pattern.capturingGroupCount, 10);
        this.groups = new int[n * 2];
        this.locals = new int[pattern.localCount];
        this.reset();
    }

    public Pattern pattern() {
        return this.parentPattern;
    }

    public MatchResult toMatchResult() {
        Matcher matcher = new Matcher(this.parentPattern, this.text.toString());
        matcher.first = this.first;
        matcher.last = this.last;
        matcher.groups = (int[])this.groups.clone();
        return matcher;
    }

    public Matcher usePattern(Pattern pattern) {
        int n;
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.parentPattern = pattern;
        int n2 = Math.max(pattern.capturingGroupCount, 10);
        this.groups = new int[n2 * 2];
        this.locals = new int[pattern.localCount];
        for (n = 0; n < this.groups.length; ++n) {
            this.groups[n] = -1;
        }
        for (n = 0; n < this.locals.length; ++n) {
            this.locals[n] = -1;
        }
        return this;
    }

    public Matcher reset() {
        int n;
        this.first = -1;
        this.last = 0;
        this.oldLast = -1;
        for (n = 0; n < this.groups.length; ++n) {
            this.groups[n] = -1;
        }
        for (n = 0; n < this.locals.length; ++n) {
            this.locals[n] = -1;
        }
        this.lastAppendPosition = 0;
        this.from = 0;
        this.to = this.getTextLength();
        return this;
    }

    public Matcher reset(CharSequence charSequence) {
        this.text = charSequence;
        return this.reset();
    }

    @Override
    public int start() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.first;
    }

    @Override
    public int start(int n) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (n > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + n);
        }
        return this.groups[n * 2];
    }

    @Override
    public int end() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.last;
    }

    @Override
    public int end(int n) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (n > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + n);
        }
        return this.groups[n * 2 + 1];
    }

    @Override
    public String group() {
        return this.group(0);
    }

    @Override
    public String group(int n) {
        if (this.first < 0) {
            throw new IllegalStateException("No match found");
        }
        if (n < 0 || n > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + n);
        }
        if (this.groups[n * 2] == -1 || this.groups[n * 2 + 1] == -1) {
            return null;
        }
        return this.getSubSequence(this.groups[n * 2], this.groups[n * 2 + 1]).toString();
    }

    public String group(String string) {
        if (string == null) {
            throw new NullPointerException("Null group name");
        }
        if (this.first < 0) {
            throw new IllegalStateException("No match found");
        }
        if (!this.parentPattern.namedGroups().containsKey(string)) {
            throw new IllegalArgumentException("No group with name <" + string + ">");
        }
        int n = this.parentPattern.namedGroups().get(string);
        if (this.groups[n * 2] == -1 || this.groups[n * 2 + 1] == -1) {
            return null;
        }
        return this.getSubSequence(this.groups[n * 2], this.groups[n * 2 + 1]).toString();
    }

    @Override
    public int groupCount() {
        return this.parentPattern.capturingGroupCount - 1;
    }

    public boolean matches() {
        return this.match(this.from, 1);
    }

    public boolean find() {
        int n = this.last;
        if (n == this.first) {
            ++n;
        }
        if (n < this.from) {
            n = this.from;
        }
        if (n > this.to) {
            for (int i = 0; i < this.groups.length; ++i) {
                this.groups[i] = -1;
            }
            return false;
        }
        return this.search(n);
    }

    public boolean find(int n) {
        int n2 = this.getTextLength();
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("Illegal start index");
        }
        this.reset();
        return this.search(n);
    }

    public boolean lookingAt() {
        return this.match(this.from, 0);
    }

    public static String quoteReplacement(String string) {
        if (string.indexOf(92) == -1 && string.indexOf(36) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == '$') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Matcher appendReplacement(StringBuffer stringBuffer, String string) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\') {
                c = string.charAt(++n);
                stringBuilder.append(c);
                ++n;
                continue;
            }
            if (c == '$') {
                c = string.charAt(++n);
                int n2 = -1;
                if (c == '<') {
                    ++n;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    while (n < string.length() && (ASCII.isLower(c = string.charAt(n)) || ASCII.isUpper(c) || ASCII.isDigit(c))) {
                        stringBuilder2.append(c);
                        ++n;
                    }
                    if (stringBuilder2.length() == 0) {
                        throw new IllegalArgumentException("named capturing group has 0 length name");
                    }
                    if (c != '>') {
                        throw new IllegalArgumentException("named capturing group is missing trailing '>'");
                    }
                    String string2 = stringBuilder2.toString();
                    if (!this.parentPattern.namedGroups().containsKey(string2)) {
                        throw new IllegalArgumentException("No group with name <" + string2 + ">");
                    }
                    n2 = this.parentPattern.namedGroups().get(string2);
                    ++n;
                } else {
                    int n3;
                    n2 = c - 48;
                    if (n2 < 0 || n2 > 9) {
                        throw new IllegalArgumentException("Illegal group reference");
                    }
                    ++n;
                    boolean bl = false;
                    while (!bl && n < string.length() && (n3 = string.charAt(n) - 48) >= 0 && n3 <= 9) {
                        int n4 = n2 * 10 + n3;
                        if (this.groupCount() < n4) {
                            bl = true;
                            continue;
                        }
                        n2 = n4;
                        ++n;
                    }
                }
                if (this.start(n2) == -1 || this.end(n2) == -1) continue;
                stringBuilder.append(this.text, this.start(n2), this.end(n2));
                continue;
            }
            stringBuilder.append(c);
            ++n;
        }
        stringBuffer.append(this.text, this.lastAppendPosition, this.first);
        stringBuffer.append(stringBuilder);
        this.lastAppendPosition = this.last;
        return this;
    }

    public StringBuffer appendTail(StringBuffer stringBuffer) {
        stringBuffer.append(this.text, this.lastAppendPosition, this.getTextLength());
        return stringBuffer;
    }

    public String replaceAll(String string) {
        this.reset();
        boolean bl = this.find();
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            do {
                this.appendReplacement(stringBuffer, string);
            } while (bl = this.find());
            this.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return this.text.toString();
    }

    public String replaceFirst(String string) {
        if (string == null) {
            throw new NullPointerException("replacement");
        }
        this.reset();
        if (!this.find()) {
            return this.text.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.appendReplacement(stringBuffer, string);
        this.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public Matcher region(int n, int n2) {
        if (n < 0 || n > this.getTextLength()) {
            throw new IndexOutOfBoundsException("start");
        }
        if (n2 < 0 || n2 > this.getTextLength()) {
            throw new IndexOutOfBoundsException("end");
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("start > end");
        }
        this.reset();
        this.from = n;
        this.to = n2;
        return this;
    }

    public int regionStart() {
        return this.from;
    }

    public int regionEnd() {
        return this.to;
    }

    public boolean hasTransparentBounds() {
        return this.transparentBounds;
    }

    public Matcher useTransparentBounds(boolean bl) {
        this.transparentBounds = bl;
        return this;
    }

    public boolean hasAnchoringBounds() {
        return this.anchoringBounds;
    }

    public Matcher useAnchoringBounds(boolean bl) {
        this.anchoringBounds = bl;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("java.util.regex.Matcher");
        stringBuilder.append("[pattern=" + this.pattern());
        stringBuilder.append(" region=");
        stringBuilder.append(this.regionStart() + "," + this.regionEnd());
        stringBuilder.append(" lastmatch=");
        if (this.first >= 0 && this.group() != null) {
            stringBuilder.append(this.group());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean hitEnd() {
        return this.hitEnd;
    }

    public boolean requireEnd() {
        return this.requireEnd;
    }

    boolean search(int n) {
        boolean bl;
        this.hitEnd = false;
        this.requireEnd = false;
        this.first = n = n < 0 ? 0 : n;
        this.oldLast = this.oldLast < 0 ? n : this.oldLast;
        for (bl = false; bl < this.groups.length; bl += 1) {
            this.groups[bl] = -1;
        }
        this.acceptMode = 0;
        bl = this.parentPattern.root.match(this, n, this.text);
        if (!bl) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return bl;
    }

    boolean match(int n, int n2) {
        boolean bl;
        this.hitEnd = false;
        this.requireEnd = false;
        this.first = n = n < 0 ? 0 : n;
        this.oldLast = this.oldLast < 0 ? n : this.oldLast;
        for (bl = false; bl < this.groups.length; bl += 1) {
            this.groups[bl] = -1;
        }
        this.acceptMode = n2;
        bl = this.parentPattern.matchRoot.match(this, n, this.text);
        if (!bl) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return bl;
    }

    int getTextLength() {
        return this.text.length();
    }

    CharSequence getSubSequence(int n, int n2) {
        return this.text.subSequence(n, n2);
    }

    char charAt(int n) {
        return this.text.charAt(n);
    }
}

