/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import javax.management.Descriptor;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class MBeanConstructorInfo
extends MBeanFeatureInfo
implements Cloneable {
    static final long serialVersionUID = 4433990064191844427L;
    static final MBeanConstructorInfo[] NO_CONSTRUCTORS = new MBeanConstructorInfo[0];
    private final transient boolean arrayGettersSafe;
    private final MBeanParameterInfo[] signature;

    public MBeanConstructorInfo(String string, Constructor<?> constructor) {
        this(constructor.getName(), string, MBeanConstructorInfo.constructorSignature(constructor), Introspector.descriptorForElement(constructor, false));
    }

    public MBeanConstructorInfo(String string, String string2, MBeanParameterInfo[] mBeanParameterInfoArray) {
        this(string, string2, mBeanParameterInfoArray, null);
    }

    public MBeanConstructorInfo(String string, String string2, MBeanParameterInfo[] mBeanParameterInfoArray, Descriptor descriptor) {
        super(string, string2, descriptor);
        mBeanParameterInfoArray = mBeanParameterInfoArray == null || mBeanParameterInfoArray.length == 0 ? MBeanParameterInfo.NO_PARAMS : (MBeanParameterInfo[])mBeanParameterInfoArray.clone();
        this.signature = mBeanParameterInfoArray;
        this.arrayGettersSafe = MBeanInfo.arrayGettersSafe(this.getClass(), MBeanConstructorInfo.class);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public MBeanParameterInfo[] getSignature() {
        if (this.signature.length == 0) {
            return this.signature;
        }
        return (MBeanParameterInfo[])this.signature.clone();
    }

    private MBeanParameterInfo[] fastGetSignature() {
        if (this.arrayGettersSafe) {
            return this.signature;
        }
        return this.getSignature();
    }

    public String toString() {
        return this.getClass().getName() + "[" + "description=" + this.getDescription() + ", " + "name=" + this.getName() + ", " + "signature=" + Arrays.asList(this.fastGetSignature()) + ", " + "descriptor=" + this.getDescriptor() + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MBeanConstructorInfo)) {
            return false;
        }
        MBeanConstructorInfo mBeanConstructorInfo = (MBeanConstructorInfo)object;
        return mBeanConstructorInfo.getName().equals(this.getName()) && mBeanConstructorInfo.getDescription().equals(this.getDescription()) && Arrays.equals(mBeanConstructorInfo.fastGetSignature(), this.fastGetSignature()) && mBeanConstructorInfo.getDescriptor().equals(this.getDescriptor());
    }

    @Override
    public int hashCode() {
        int n = this.getName().hashCode();
        MBeanParameterInfo[] mBeanParameterInfoArray = this.fastGetSignature();
        for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
            n ^= mBeanParameterInfoArray[i].hashCode();
        }
        return n;
    }

    private static MBeanParameterInfo[] constructorSignature(Constructor<?> constructor) {
        Class<?>[] classArray = constructor.getParameterTypes();
        Annotation[][] annotationArray = constructor.getParameterAnnotations();
        return MBeanOperationInfo.parameters(classArray, annotationArray);
    }
}

