/*
 * Decompiled with CFR 0.152.
 */
package javax.management.event;

import com.sun.jmx.event.DaemonThreadFactory;
import com.sun.jmx.event.RepeatedSingletonJob;
import com.sun.jmx.remote.util.ClassLogger;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanException;
import javax.management.event.EventClientDelegateMBean;
import javax.management.event.EventReceiver;
import javax.management.event.EventRelay;
import javax.management.event.FetchingEventForwarder;
import javax.management.remote.NotificationResult;

public class FetchingEventRelay
implements EventRelay {
    public static final int DEFAULT_BUFFER_SIZE = 1000;
    public static final long DEFAULT_WAITING_TIMEOUT = 60000L;
    public static final int DEFAULT_MAX_NOTIFICATIONS = 1000;
    private long startSequenceNumber = 0L;
    private EventReceiver eventReceiver = null;
    private final EventClientDelegateMBean delegate;
    private String clientId;
    private boolean stopped = false;
    private final Executor fetchExecutor;
    private final ExecutorService defaultExecutor;
    private final MyJob fetchingJob;
    private final long timeout;
    private final int maxNotifs;
    private static final ClassLogger logger = new ClassLogger("javax.management.event", "FetchingEventRelay");
    private static final ThreadFactory daemonThreadFactory = new DaemonThreadFactory("JMX FetchingEventRelay executor %d");

    public FetchingEventRelay(EventClientDelegateMBean eventClientDelegateMBean) throws IOException, MBeanException {
        this(eventClientDelegateMBean, null);
    }

    public FetchingEventRelay(EventClientDelegateMBean eventClientDelegateMBean, Executor executor) throws IOException, MBeanException {
        this(eventClientDelegateMBean, 1000, 60000L, 1000, executor);
    }

    public FetchingEventRelay(EventClientDelegateMBean eventClientDelegateMBean, int n, long l, int n2, Executor executor) throws IOException, MBeanException {
        this(eventClientDelegateMBean, n, l, n2, executor, FetchingEventForwarder.class.getName(), new Object[]{n}, new String[]{Integer.TYPE.getName()});
    }

    public FetchingEventRelay(EventClientDelegateMBean eventClientDelegateMBean, int n, long l, int n2, Executor executor, String string, Object[] objectArray, String[] stringArray) throws IOException, MBeanException {
        if (logger.traceOn()) {
            logger.trace("FetchingEventRelay", "delegateMBean " + n + " " + l + " " + n2 + " " + executor + " " + string + " ");
        }
        if (eventClientDelegateMBean == null) {
            throw new NullPointerException("Null EventClientDelegateMBean!");
        }
        if (n <= 1) {
            throw new IllegalArgumentException("The bufferSize cannot be less than 1, no meaning.");
        }
        if (n2 <= 1) {
            throw new IllegalArgumentException("The maxNotifs cannot be less than 1, no meaning.");
        }
        this.clientId = eventClientDelegateMBean.addClient(string, objectArray, stringArray);
        this.delegate = eventClientDelegateMBean;
        this.timeout = l;
        this.maxNotifs = n2;
        if (executor == null) {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, daemonThreadFactory);
            scheduledThreadPoolExecutor.setKeepAliveTime(1L, TimeUnit.SECONDS);
            scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
            executor = scheduledThreadPoolExecutor;
            this.defaultExecutor = scheduledThreadPoolExecutor;
        } else {
            this.defaultExecutor = null;
        }
        this.fetchExecutor = executor;
        this.startSequenceNumber = 0L;
        this.fetchingJob = new MyJob();
    }

    @Override
    public synchronized void setEventReceiver(EventReceiver eventReceiver) {
        if (logger.traceOn()) {
            logger.trace("setEventReceiver", "" + eventReceiver);
        }
        EventReceiver eventReceiver2 = this.eventReceiver;
        this.eventReceiver = eventReceiver;
        if (eventReceiver2 == null && eventReceiver != null) {
            this.fetchingJob.resume();
        }
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public synchronized void stop() {
        if (logger.traceOn()) {
            logger.trace("stop", "");
        }
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.clientId = null;
        if (this.defaultExecutor != null) {
            this.defaultExecutor.shutdown();
        }
    }

    private NotificationResult fetchOne() throws Exception {
        logger.trace("fetchOne", "");
        while (true) {
            try {
                return this.delegate.fetchNotifications(this.clientId, this.startSequenceNumber, 1, this.timeout);
            }
            catch (Exception exception) {
                if (FetchingEventRelay.isSerialOrClassNotFound(exception)) {
                    if (logger.traceOn()) {
                        logger.trace("fetchOne", "Ignore", exception);
                    }
                    this.eventReceiver.nonFatal(exception);
                    ++this.startSequenceNumber;
                    continue;
                }
                throw exception;
            }
            break;
        }
    }

    static boolean isSerialOrClassNotFound(Exception exception) {
        Throwable throwable;
        for (throwable = exception.getCause(); throwable != null && !(throwable instanceof ClassNotFoundException) && !(throwable instanceof NotSerializableException); throwable = throwable.getCause()) {
        }
        return throwable instanceof ClassNotFoundException || throwable instanceof NotSerializableException;
    }

    private class MyJob
    extends RepeatedSingletonJob {
        public MyJob() {
            super(FetchingEventRelay.this.fetchExecutor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSuspended() {
            boolean bl;
            FetchingEventRelay fetchingEventRelay = FetchingEventRelay.this;
            synchronized (fetchingEventRelay) {
                bl = FetchingEventRelay.this.stopped || FetchingEventRelay.this.eventReceiver == null || FetchingEventRelay.this.clientId == null;
            }
            if (logger.traceOn()) {
                logger.trace("-MyJob-isSuspended", "" + bl);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void task() {
            logger.trace("MyJob-task", "");
            long l = FetchingEventRelay.this.timeout;
            NotificationResult notificationResult = null;
            Exception exception = null;
            try {
                notificationResult = FetchingEventRelay.this.delegate.fetchNotifications(FetchingEventRelay.this.clientId, FetchingEventRelay.this.startSequenceNumber, FetchingEventRelay.this.maxNotifs, l);
            }
            catch (Exception exception2) {
                if (FetchingEventRelay.isSerialOrClassNotFound(exception2)) {
                    try {
                        notificationResult = FetchingEventRelay.this.fetchOne();
                    }
                    catch (Exception exception3) {
                        exception = exception2;
                    }
                }
                exception = exception2;
            }
            if (exception != null && !this.isSuspended()) {
                logger.fine("MyJob-task", "Failed to fetch notification, stopping...", exception);
                try {
                    FetchingEventRelay.this.eventReceiver.failed(exception);
                }
                catch (Exception exception4) {
                    logger.trace("MyJob-task", "exception from eventReceiver.failed", exception4);
                }
                FetchingEventRelay.this.stop();
            } else if (notificationResult != null) {
                try {
                    FetchingEventRelay.this.eventReceiver.receive(notificationResult);
                }
                catch (RuntimeException runtimeException) {
                    logger.trace("MyJob-task", "exception delivering notifs to EventClient", runtimeException);
                }
                finally {
                    FetchingEventRelay.this.startSequenceNumber = notificationResult.getNextSequenceNumber();
                }
            }
        }
    }
}

