/*
 * Decompiled with CFR 0.152.
 */
package javax.management.namespace;

import java.io.IOException;
import java.util.UUID;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.namespace.JMXNamespaceMBean;
import javax.management.namespace.JMXNamespaces;

public class JMXNamespace
implements JMXNamespaceMBean,
MBeanRegistration {
    public static final String TYPE = "JMXNamespace";
    public static final String TYPE_ASSIGNMENT = "type=JMXNamespace";
    private volatile MBeanServer mbeanServer;
    private volatile ObjectName objectName;
    private final MBeanServer sourceServer;
    private final String uuid;

    public JMXNamespace(MBeanServer mBeanServer) {
        this.sourceServer = mBeanServer;
        this.uuid = UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        JMXNamespace jMXNamespace = this;
        synchronized (jMXNamespace) {
            if (this.objectName != null && !this.objectName.equals(objectName)) {
                throw new IllegalStateException("Already registered under another name: " + this.objectName);
            }
            this.objectName = this.validateHandlerName(objectName);
            this.mbeanServer = mBeanServer;
        }
        return objectName;
    }

    ObjectName validateHandlerName(ObjectName objectName) {
        if (objectName == null) {
            throw new IllegalArgumentException("Must supply a valid name");
        }
        String string = JMXNamespaces.normalizeNamespaceName(objectName.getDomain());
        ObjectName objectName2 = JMXNamespaces.getNamespaceObjectName(string);
        if (!objectName.equals(objectName2)) {
            throw new IllegalArgumentException("invalid name space name: " + objectName);
        }
        return objectName;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postDeregister() {
        JMXNamespace jMXNamespace = this;
        synchronized (jMXNamespace) {
            this.mbeanServer = null;
            this.objectName = null;
        }
    }

    public final MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public MBeanServer getSourceServer() {
        return this.sourceServer;
    }

    public final ObjectName getObjectName() {
        return this.objectName;
    }

    String getHandlerName() {
        ObjectName objectName = this.getObjectName();
        if (objectName != null) {
            return objectName.toString();
        }
        return this.toString();
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        return this.getSourceServer().getMBeanCount();
    }

    @Override
    public String[] getDomains() throws IOException {
        return this.getSourceServer().getDomains();
    }

    @Override
    public String getDefaultDomain() throws IOException {
        return this.getSourceServer().getDefaultDomain();
    }

    @Override
    public final String getUUID() {
        return this.uuid;
    }
}

