/*
 * Decompiled with CFR 0.152.
 */
package javax.management.namespace;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeChangeNotification;
import javax.management.ClientContext;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.namespace.JMXNamespace;
import javax.management.namespace.JMXRemoteNamespaceMBean;
import javax.management.namespace.MBeanServerConnectionWrapper;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JMXRemoteNamespace
extends JMXNamespace
implements JMXRemoteNamespaceMBean,
NotificationEmitter {
    private static final Logger LOG = JmxProperties.NAMESPACE_LOGGER;
    private static final MBeanNotificationInfo connectNotification = new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "Connected", "Emitted when the Connected state of this object changes");
    private static AtomicLong seqNumber = new AtomicLong(0L);
    private final NotificationBroadcasterSupport broadcaster;
    private final ConnectionListener listener;
    private final JMXServiceURL jmxURL;
    private final Map<String, ?> optionsMap;
    private volatile MBeanServerConnection server = null;
    private volatile JMXConnector conn = null;
    private volatile ClassLoader defaultClassLoader = null;

    protected JMXRemoteNamespace(JMXServiceURL jMXServiceURL, Map<String, ?> map) {
        super(new JMXRemoteNamespaceDelegate());
        ((JMXRemoteNamespaceDelegate)super.getSourceServer()).initParentOnce(this);
        if (jMXServiceURL == null) {
            throw new IllegalArgumentException("Null URL");
        }
        this.jmxURL = jMXServiceURL;
        this.broadcaster = new NotificationBroadcasterSupport(connectNotification);
        this.optionsMap = JMXRemoteNamespace.unmodifiableMap(map);
        this.listener = new ConnectionListener();
    }

    private static <K, V> Map<K, V> unmodifiableMap(Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public JMXServiceURL getJMXServiceURL() {
        return this.jmxURL;
    }

    @Override
    public JMXServiceURL getAddress() {
        return this.getJMXServiceURL();
    }

    private Map<String, ?> getEnvMap() {
        return this.optionsMap;
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.broadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.broadcaster.getNotificationInfo();
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(notificationListener);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    private static long getNextSeqNumber() {
        return seqNumber.getAndIncrement();
    }

    protected void sendNotification(Notification notification) {
        if (notification.getSequenceNumber() <= 0L) {
            notification.setSequenceNumber(JMXRemoteNamespace.getNextSeqNumber());
        }
        if (notification.getSource() == null) {
            notification.setSource(this.getObjectName());
        }
        this.broadcaster.sendNotification(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState(ConnectionListener connectionListener, JMXConnectionNotification jMXConnectionNotification, JMXConnector jMXConnector) {
        boolean bl = false;
        JMXRemoteNamespace jMXRemoteNamespace = this;
        synchronized (jMXRemoteNamespace) {
            if (this.conn != jMXConnector || "jmx.remote.connection.failed".equals(jMXConnectionNotification.getType())) {
                bl = true;
            }
        }
        if (bl) {
            try {
                jMXConnector.removeConnectionNotificationListener(connectionListener, null, jMXConnector);
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "Failed to unregister connection listener" + exception);
                LOG.log(Level.FINEST, "Failed to unregister connection listener", exception);
            }
            try {
                jMXConnector.close();
            }
            catch (Exception exception) {
                LOG.log(Level.FINEST, "Failed to close old connector (failure was expected): " + exception);
            }
        }
        boolean bl2 = false;
        JMXConnector jMXConnector2 = this.conn;
        try {
            if (jMXConnector2 != null) {
                jMXConnector2.getConnectionId();
            }
        }
        catch (IOException iOException) {
            LOG.finest("Connector already closed: " + iOException);
            bl2 = true;
        }
        if (bl2) {
            this.switchConnection(jMXConnector2, null, null);
            try {
                if (jMXConnector2 != jMXConnector || !bl) {
                    jMXConnector2.close();
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.FINEST, "Failed to close connector (failure was expected): " + iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void switchConnection(JMXConnector jMXConnector, JMXConnector jMXConnector2, MBeanServerConnection mBeanServerConnection) {
        boolean bl = false;
        boolean bl2 = false;
        JMXRemoteNamespace jMXRemoteNamespace = this;
        synchronized (jMXRemoteNamespace) {
            if (jMXConnector != this.conn) {
                if (jMXConnector2 != null) {
                    try {
                        jMXConnector2.close();
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.FINEST, "Failed to close connector", iOException);
                    }
                }
                return;
            }
            if (this.conn == null && jMXConnector2 != null) {
                bl = true;
            }
            if (jMXConnector2 == null && this.conn != null) {
                bl2 = true;
            }
            this.conn = jMXConnector2;
            this.server = mBeanServerConnection;
        }
        if (bl || bl2) {
            boolean bl3 = bl2;
            boolean bl4 = bl;
            ObjectName objectName = this.getObjectName();
            Object object = objectName == null ? this : objectName;
            AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification(object, JMXRemoteNamespace.getNextSeqNumber(), System.currentTimeMillis(), String.valueOf(object) + (bl4 ? " connected" : " closed"), "Connected", "boolean", bl3, bl4);
            this.sendNotification(attributeChangeNotification);
        }
    }

    private void close(JMXConnector jMXConnector) {
        try {
            if (jMXConnector != null) {
                jMXConnector.close();
            }
        }
        catch (Exception exception) {
            LOG.finest("Ignoring exception when closing connector: " + exception);
        }
    }

    private JMXConnector connect(JMXServiceURL jMXServiceURL, Map<String, ?> map) throws IOException {
        JMXConnector jMXConnector = this.newJMXConnector(jMXServiceURL, map);
        jMXConnector.connect(map);
        return jMXConnector;
    }

    protected JMXConnector newJMXConnector(JMXServiceURL jMXServiceURL, Map<String, ?> map) throws IOException {
        return JMXConnectorFactory.newJMXConnector(this.jmxURL, map);
    }

    protected MBeanServerConnection getMBeanServerConnection(JMXConnector jMXConnector) throws IOException {
        MBeanServerConnection mBeanServerConnection = jMXConnector.getMBeanServerConnection();
        try {
            return ClientContext.withDynamicContext(mBeanServerConnection);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.log(Level.FINER, "ClientContext.withDynamicContext", illegalArgumentException);
            return mBeanServerConnection;
        }
    }

    @Override
    public void connect() throws IOException {
        MBeanServerConnection mBeanServerConnection;
        LOG.fine("connecting...");
        HashMap hashMap = new HashMap(this.getEnvMap());
        try {
            this.defaultClassLoader = EnvHelp.resolveServerClassLoader(hashMap, this.getMBeanServer());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            IOException iOException = new IOException("ClassLoader not found");
            iOException.initCause(instanceNotFoundException);
            throw iOException;
        }
        hashMap.put("jmx.remote.default.class.loader", this.defaultClassLoader);
        JMXServiceURL jMXServiceURL = this.getJMXServiceURL();
        JMXConnector jMXConnector = this.connect(jMXServiceURL, hashMap);
        try {
            mBeanServerConnection = this.getMBeanServerConnection(jMXConnector);
            jMXConnector.addConnectionNotificationListener(this.listener, null, jMXConnector);
        }
        catch (IOException iOException) {
            this.close(jMXConnector);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.close(jMXConnector);
            throw runtimeException;
        }
        this.switchConnection(this.conn, jMXConnector, mBeanServerConnection);
        LOG.fine("connected.");
    }

    @Override
    public void close() throws IOException {
        if (this.conn == null) {
            return;
        }
        LOG.fine("closing...");
        this.conn.close();
        this.switchConnection(this.conn, null, null);
        LOG.fine("closed.");
    }

    MBeanServerConnection getMBeanServerConnection() {
        if (this.conn == null) {
            throw this.newRuntimeIOException("getMBeanServerConnection: not connected");
        }
        return this.server;
    }

    private RuntimeException newRuntimeIOException(String string) {
        IllegalStateException illegalStateException = new IllegalStateException(string);
        return Util.newRuntimeIOException(new IOException(string, illegalStateException));
    }

    ClassLoader getDefaultClassLoader() {
        if (this.conn == null) {
            throw this.newRuntimeIOException("getMBeanServerConnection: not connected");
        }
        return this.defaultClassLoader;
    }

    @Override
    public boolean isConnected() {
        return this.conn != null && this.server != null;
    }

    @Override
    public void preDeregister() throws Exception {
        try {
            this.close();
        }
        catch (IOException iOException) {
            LOG.fine("Failed to close properly - exception ignored: " + iOException);
            LOG.log(Level.FINEST, "Failed to close properly - exception ignored", iOException);
        }
        super.preDeregister();
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        return this.getMBeanServerConnection().getMBeanCount();
    }

    @Override
    public String[] getDomains() throws IOException {
        return this.getMBeanServerConnection().getDomains();
    }

    @Override
    public String getDefaultDomain() throws IOException {
        return this.getMBeanServerConnection().getDefaultDomain();
    }

    public static JMXRemoteNamespace newJMXRemoteNamespace(JMXServiceURL jMXServiceURL, Map<String, ?> map) {
        return new JMXRemoteNamespace(jMXServiceURL, map);
    }

    private static class JMXRemoteNamespaceDelegate
    extends MBeanServerConnectionWrapper {
        private volatile JMXRemoteNamespace parent = null;

        JMXRemoteNamespaceDelegate() {
            super(null, null);
        }

        @Override
        public MBeanServerConnection getMBeanServerConnection() {
            return this.parent.getMBeanServerConnection();
        }

        @Override
        public ClassLoader getDefaultClassLoader() {
            return this.parent.getDefaultClassLoader();
        }

        synchronized void initParentOnce(JMXRemoteNamespace jMXRemoteNamespace) {
            if (this.parent != null) {
                throw new UnsupportedOperationException("parent already set");
            }
            this.parent = jMXRemoteNamespace;
        }
    }

    private class ConnectionListener
    implements NotificationListener {
        private ConnectionListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object object) {
            if (!(notification instanceof JMXConnectionNotification)) {
                return;
            }
            JMXConnectionNotification jMXConnectionNotification = (JMXConnectionNotification)notification;
            String string = jMXConnectionNotification.getType();
            if ("jmx.remote.connection.closed".equals(string) || "jmx.remote.connection.failed".equals(string)) {
                JMXRemoteNamespace.this.checkState(this, jMXConnectionNotification, (JMXConnector)object);
            }
        }
    }
}

