/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.logging.Logger;
import sun.awt.X11.Native;
import sun.awt.X11.UnsafeXDisposerRecord;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.java2d.Disposer;
import sun.misc.Unsafe;

public class XQueryTree {
    private static Unsafe unsafe = XlibWrapper.unsafe;
    private static final Logger log = Logger.getLogger("sun.awt.X11.XQueryTree");
    private boolean __executed = false;
    long _w;
    long root_ptr = unsafe.allocateMemory(Native.getLongSize());
    long parent_ptr = unsafe.allocateMemory(Native.getLongSize());
    long children_ptr = unsafe.allocateMemory(Native.getLongSize());
    long nchildren_ptr = unsafe.allocateMemory(Native.getIntSize());
    UnsafeXDisposerRecord disposer;

    public XQueryTree(long l) {
        this.set_w(l);
        this.disposer = new UnsafeXDisposerRecord("XQueryTree", new long[]{this.root_ptr, this.parent_ptr, this.nchildren_ptr}, new long[]{this.children_ptr});
        Disposer.addRecord(this, this.disposer);
        this.set_children(0L);
    }

    public int execute() {
        return this.execute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(XErrorHandler xErrorHandler) {
        XToolkit.awtLock();
        try {
            if (this.isDisposed()) {
                throw new IllegalStateException("Disposed");
            }
            if (this.__executed) {
                throw new IllegalStateException("Already executed");
            }
            this.__executed = true;
            if (xErrorHandler != null) {
                XToolkit.WITH_XERROR_HANDLER(xErrorHandler);
            }
            Native.putLong(this.children_ptr, 0L);
            int n = XlibWrapper.XQueryTree(XToolkit.getDisplay(), this.get_w(), this.root_ptr, this.parent_ptr, this.children_ptr, this.nchildren_ptr);
            if (xErrorHandler != null) {
                XToolkit.RESTORE_XERROR_HANDLER();
            }
            int n2 = n;
            return n2;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public boolean isExecuted() {
        return this.__executed;
    }

    public boolean isDisposed() {
        return this.disposer.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        XToolkit.awtLock();
        try {
            if (this.isDisposed()) {
                return;
            }
            this.disposer.dispose();
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public long get_w() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return this._w;
    }

    public void set_w(long l) {
        this._w = l;
    }

    public long get_root() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getLong(this.root_ptr);
    }

    public void set_root(long l) {
        Native.putLong(this.root_ptr, l);
    }

    public long get_parent() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getLong(this.parent_ptr);
    }

    public void set_parent(long l) {
        Native.putLong(this.parent_ptr, l);
    }

    public long get_children() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getLong(this.children_ptr);
    }

    public void set_children(long l) {
        Native.putLong(this.children_ptr, l);
    }

    public int get_nchildren() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getInt(this.nchildren_ptr);
    }

    public void set_nchildren(int n) {
        Native.putInt(this.nchildren_ptr, n);
    }
}

