/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.util.LinkedList;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.FileDispatcherImpl;

class DevPollArrayWrapper {
    static final short POLLIN = 1;
    static final short POLLPRI = 2;
    static final short POLLOUT = 4;
    static final short POLLRDNORM = 64;
    static final short POLLWRNORM = 4;
    static final short POLLRDBAND = 128;
    static final short POLLWRBAND = 256;
    static final short POLLNORM = 64;
    static final short POLLERR = 8;
    static final short POLLHUP = 16;
    static final short POLLNVAL = 32;
    static final short POLLREMOVE = 2048;
    static final short POLLCONN = 4;
    static final short SIZE_POLLFD = 8;
    static final short FD_OFFSET = 0;
    static final short EVENT_OFFSET = 4;
    static final short REVENT_OFFSET = 6;
    static final int OPEN_MAX = DevPollArrayWrapper.fdLimit();
    static final int NUM_POLLFDS = Math.min(OPEN_MAX - 1, 8192);
    private long pollArrayAddress;
    private AllocatedNativeObject updatePollArray;
    private int MAX_UPDATE_SIZE = Math.min(OPEN_MAX, 10000);
    private LinkedList<Updator> updateList = new LinkedList();
    private AllocatedNativeObject pollArray;
    int wfd;
    int outgoingInterruptFD;
    int incomingInterruptFD;
    int interruptedIndex;
    int updated;
    boolean interrupted = false;

    DevPollArrayWrapper() {
        int n = NUM_POLLFDS * 8;
        this.pollArray = new AllocatedNativeObject(n, true);
        this.pollArrayAddress = this.pollArray.address();
        n = this.MAX_UPDATE_SIZE * 8;
        this.updatePollArray = new AllocatedNativeObject(n, true);
        this.wfd = this.init();
    }

    void initInterrupt(int n, int n2) {
        this.outgoingInterruptFD = n2;
        this.incomingInterruptFD = n;
        this.register(this.wfd, n, 1);
    }

    void putReventOps(int n, int n2) {
        int n3 = 8 * n + 6;
        this.pollArray.putShort(n3, (short)n2);
    }

    int getEventOps(int n) {
        int n2 = 8 * n + 4;
        return this.pollArray.getShort(n2);
    }

    int getReventOps(int n) {
        int n2 = 8 * n + 6;
        return this.pollArray.getShort(n2);
    }

    int getDescriptor(int n) {
        int n2 = 8 * n + 0;
        return this.pollArray.getInt(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(int n, int n2) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            this.updateList.add(new Updator(n, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(int n) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            this.updateList.add(new Updator(n, 2048));
        }
    }

    void closeDevPollFD() throws IOException {
        FileDispatcherImpl.closeIntFD(this.wfd);
        this.pollArray.free();
        this.updatePollArray.free();
    }

    int poll(long l) throws IOException {
        this.updateRegistrations();
        this.updated = this.poll0(this.pollArrayAddress, NUM_POLLFDS, l, this.wfd);
        for (int i = 0; i < this.updated; ++i) {
            if (this.getDescriptor(i) != this.incomingInterruptFD) continue;
            this.interruptedIndex = i;
            this.interrupted = true;
            break;
        }
        return this.updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRegistrations() throws IOException {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            while (this.updateList.size() > 0) {
                int n = 0;
                Updator updator = null;
                while ((updator = this.updateList.poll()) != null) {
                    this.putPollFD(this.updatePollArray, n, updator.fd, (short)2048);
                    ++n;
                    if (updator.mask != 2048) {
                        this.putPollFD(this.updatePollArray, n, updator.fd, (short)updator.mask);
                        ++n;
                    }
                    if (n <= this.MAX_UPDATE_SIZE - 2) continue;
                }
                this.registerMultiple(this.wfd, this.updatePollArray.address(), n);
            }
        }
    }

    private void putPollFD(AllocatedNativeObject allocatedNativeObject, int n, int n2, short s) {
        int n3 = 8 * n;
        allocatedNativeObject.putInt(n3 + 0, n2);
        allocatedNativeObject.putShort(n3 + 4, s);
        allocatedNativeObject.putShort(n3 + 6, (short)0);
    }

    public void interrupt() {
        DevPollArrayWrapper.interrupt(this.outgoingInterruptFD);
    }

    public int interruptedIndex() {
        return this.interruptedIndex;
    }

    boolean interrupted() {
        return this.interrupted;
    }

    void clearInterrupted() {
        this.interrupted = false;
    }

    private native int init();

    private native void register(int var1, int var2, int var3);

    private native void registerMultiple(int var1, long var2, int var4) throws IOException;

    private native int poll0(long var1, int var3, long var4, int var6);

    private static native void interrupt(int var0);

    private static native int fdLimit();

    private static class Updator {
        int fd;
        int mask;

        Updator(int n, int n2) {
            this.fd = n;
            this.mask = n2;
        }
    }
}

